// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//

#ifndef POOMA_BENCHMARKS_RBSOR_RBSORINCPPTRAN_H
#define POOMA_BENCHMARKS_RBSOR_RBSORINCPPTRAN_H

// include files
#include "rbSORBase.h"


//-----------------------------------------------------------------------
// rbsorCppTran class definition.
//-----------------------------------------------------------------------

template <class PatchTag, bool UMP>
class rbsorCppTran : public rbsorBase<PatchTag,UMP> {
public:

  typedef typename rbsorBase<PatchTag, UMP>::Array2D Array2D;

  // Constructor allows us to specify number of patches in each direction.
  
  rbsorCppTran(int np = 1)
  : rbsorBase<PatchTag,UMP>(np) { }

  // This is a C++Tran benchmark, perhaps using UMP.

  const char* type() const { return rbsorBase<PatchTag,UMP>::CppTranType(); }
  const char* qualification() const
  {
    if (UMP)
      {
        if (typeid(PatchTag) == typeid(Brick))
          return "BrickUMP";
        else
          return "CompBrickUMP";
      }
    else
      {
        if (typeid(PatchTag) == typeid(Brick))
          return "Brick";
        else
          return "CompBrick";
      }
  }

  void run() 
  {
    const double fact = 1.0 / 5.0;
    Array2D &a = this->aRef();
    int i, j, k;

    // Run kernel.
    
    for (k = 0; k < 10; ++k)
    {
      // red
      for (j = 1; j <= this->n_m-3; j+=2) 
      {
        for (i = 1; i <= this->n_m-3; i+=2) 
	{
	  a(i,j) = fact *
	    ( a(i-1,j) + a(i+1,j) + a(i,j) + a(i,j-1) + a(i,j+1) );
	  a(i+1,j+1) = fact *
	    ( a(i,j+1) + a(i+2,j+1) + a(i+1,j+1) + a(i+1,j) + a(i+1,j+2) );
	}
      }
      // black
      for (j = 1; j <= this->n_m-3; j+=2) 
      {
        for (i = 1; i <= this->n_m-3; i+=2) 
	{
	  a(i+1,j) = fact *
	    ( a(i,j) + a(i+2,j) + a(i+1,j) + a(i+1,j-1) + a(i+1,j+1) );
	  a(i,j+1) = fact *
	    ( a(i-1,j+1) + a(i+1,j+1) + a(i,j+1) + a(i,j) + a(i,j+2) );
	}
      }
    }
     
    // Save result for checking.
    
    this->check_m = a(this->n_m / 2, this->n_m / 2);
  }
};

#endif // POOMA_BENCHMARKS_RBSOR_RBSORINCPPTRAN_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: rbSORinCppTran.h,v $   $Author: richard $
// $Revision: 1.4 $   $Date: 2004/11/01 18:15:19 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
