// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//

#ifndef POOMA_BENCHMARKS_RBSOR_RBSORINP2_H
#define POOMA_BENCHMARKS_RBSOR_RBSORINP2_H

// include files
#include "rbSORBase.h"


//-----------------------------------------------------------------------
// rbsorP2 class definition.
//-----------------------------------------------------------------------

template <class PatchTag, bool UMP>
class rbsorP2 : public rbsorBase<PatchTag,UMP> {
public:

  typedef typename rbsorBase<PatchTag, UMP>::Array2D Array2D;

  // Constructor allows us to specify number of patches in each direction.
  
  rbsorP2(int np = 1)
  : rbsorBase<PatchTag, UMP>(np) { }

  // This is a P2 benchmark, perhaps using UMP.

  const char* type() const { return rbsorBase<PatchTag,UMP>::P2Type(); }
  const char* qualification() const
  {
    if (UMP)
      {
        if (typeid(PatchTag) == typeid(Brick))
          return "BrickUMP";
        else
          return "CompBrickUMP";
      }
    else
      {
        if (typeid(PatchTag) == typeid(Brick))
          return "Brick";
        else
          return "CompBrick";
      }
  }

  void run() 
  {
    Array2D &a = this->aRef();
    int k;

    // Run kernel.
    
    for (k = 0; k < 10; ++k)
    {
      // red
      applySOR(a, this->I, this->J);
      applySOR(a, this->I+1, this->J+1);
      // black
      applySOR(a, this->I+1, this->J);
      applySOR(a, this->I, this->J+1);
    }

    Pooma::blockAndEvaluate();

    // Save result for checking.
    
    this->check_m = a(this->n_m / 2, this->n_m / 2);
  }
private:

  inline void applySOR(Array2D A, const Range<1>& i, const Range<1>& j)
  {
    A(i,j) = 0.2 * ( A(i-1,j) + A(i+1,j) + A(i,j) + A(i,j-1) + A(i,j+1) );
  }
};

#endif // POOMA_BENCHMARKS_RBSOR_RBSORINP2_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: rbSORinP2.h,v $   $Author: richard $
// $Revision: 1.4 $   $Date: 2004/11/01 18:15:19 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
