#!/usr/bin/env perl 
#   Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
#   Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
#
#   This file is part of FreePOOMA.
#
#   FreePOOMA is free software; you can redistribute it and/or modify it
#   under the terms of the Expat license.
#
#   This program is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
#   license for more details.
#
#   You should have received a copy of the Expat license along with
#   FreePOOMA; see the file LICENSE.

#####################################################################
#
# Prettify the link or compile commands by breaking them into 
# continued lines.
#
# Assumes we're reading just 1 line from stdin. Writes 1 or more
# lines to stdout.
#
# laa, 6/9/97
#####################################################################
local($DEBUG) = 0;
local($generic_target) = "<YOUR_TARGET_HERE>";
local($mode)  = shift(@ARGV);
local($target)= shift(@ARGV);
if ($DEBUG) {
	print "DEBUG = $DEBUG\n";
	print "mode  = $mode\n";
	print "target= $target\n";
}

$_ = <STDIN>;
if ($DEBUG) {
	print "-------------- Original Command Line --------------\n";
	print;
}

if ($mode =~ /ld/i) {		# clean up loader output
	s/ -L/ \\\n-L/g;
	s/\.o /.o \\\n/g;
	s/\.a /.a \\\n/g;
	s/ -l/ \\\n-l/g;
	s/ -o/ \\\n-o/g;
	s/ -I/ \\\n-I/g;	# These shouldn't be here, but...
}
elsif ($mode =~ /cc/i) {	# clean up compiler output
	s/ -o/ \\\n-o/g;
	s/ -I/ \\\n-I/g;
	s/ -D/ \\\n-D/;
#	s/(-I\S*)(.*)/$1 \\\n$2\n/g;	# put -I on a line by itself
#	s/(-I\S*)(.*)/$1 \n$2\n/g;	# put -I on a line by itself
	s/(-o \S*)(.*)/$1 \\\n$2\n/g;	# put -o on a line by itself
	s/\n (-.*)/\n$1/g;		# remove leading spaces
}
elsif ($mode =~ /ar/i) {	# clean up archiver output
	s/\.o /.o \\\n/g;
	s/\.a /.a \\\n/g;
}
else {
	print "Unknown mode for $ARGV[0]\n";
}
s/;/; \\\n/g;			# add newline to command separators
s/-o +${target}/-o ${generic_target}/g if ($target);	# substitute generic target description
s/-o ${generic_target} *(\W+)/-o ${generic_target} \\\n$1/g;	# substitute generic target description
s/\n\n/\n/g;				# remove completely blank lines
s/^\s*\\\s*$/\\/g;				# remove blank continued lines
s/\n \\//g;				# remove blank continued lines
$_ .= "\n";

if ($DEBUG) { print "\n-------------- Prettified Command Line --------------\n"; }
print;
if ($DEBUG) { print "-----------------------------------------------------\n"; }

print "\n\n";

# ACL:rcsinfo
#  ----------------------------------------------------------------------
#  $RCSfile: pretty.pl,v $   $Author: richard $
#  $Revision: 1.13 $   $Date: 2004/11/01 18:15:22 $
#  ----------------------------------------------------------------------
# ACL:rcsinfo
