.PHONY : all depend help wwwhelp clearflags findflags findinfo

.PHONY : showtimes showenv clean cleansuite realclean realcleansuite realrealcleansuite tar makestuff dirs
.PHONY : showalias echopoomaroot suiteinfo

depend: cleandepend
	@echo "Making Dependencies for suite=$(SUITE)."; \
	cd $(PROJECT_ROOT);\
	filelist=`$(FIND) $(PROJECT_ROOT)/src -type f -name "*.cmpl.cpp" -o -name "*.inst.cpp" | grep -v "tests\|FileTemplates\|SCCS\|CVS"`;\
	filelisttests=`$(FIND) $(PROJECT_ROOT)/src -type f -name "*.cpp" | grep -v "SCCS\|CVS" | grep "tests/.*\.cpp"`;\
	touch $(LIBRARY_ROOT)/depend.mk ; \
	$(MAKEDEPEND) -f $(LIBRARY_ROOT)/depend.mk $(shell echo $(SUITE_DEFINES) | $(TR) ' ' ',' ) $(SUITE_INCLUDES) $$filelist $$filelisttests 2> $(LIBRARY_ROOT)/depend.err;\
	$(PERL) $(SHARED_ROOT)/dependo.pl $(LIBRARY_ROOT)/depend.mk $(PROJECT_ROOT) $$filelist;\
	rm -f $(LIBRARY_ROOT)/depend.mk.bak
 
cleandepend:
	rm -f $(LIBRARY_ROOT)/depend.mk

help:
	@$(PAGER) $(SHARED_ROOT)/README.make ;\
	echo This file may be found at file://$(SHARED_ROOT)/README.make
 
#		Fire up a WWW browser to view the help file
wwwhelp:
	@$(BROWSER) file://$(SHARED_ROOT)/README.make&
 
#		Summarize compile times and sizes
showtimes:
	@$(PERL) $(SHARED_ROOT)/showtimes.pl $(PROJECT_ROOT)
 
#		List the aliaii set by aliases_pooma.csh
showalias:
	$(GREP) "^alias" $(SCRIPTS_ROOT)/aliases_$(PROJECT).csh
 
showenv::
	@echo 'PROJECT_ROOT   = $(PROJECT_ROOT)';\
	echo  'TMPDIR         = $(TMPDIR)';\
	echo  'CVSROOT        = $(CVSROOT)';\
	echo  'SUITE          = $(SUITE)';\
	echo  'CXX            = $(CXX)';\
	echo  'LD             = $(LD)';\
	echo  'LD_PARALLEL    = $(LD_PARALLEL)';\
	echo  'USER           = $(USER)';\
	echo  'USER_PREF_NAME = $(USER_PREF_NAME)';

suiteinfo::
	@echo "*** LD_LINK_CMDLINE for $(SUITE) ***"
	@echo "$(PRE_CMDLINE); $(LD_LINK_CMDLINE)" | $(PERL) $(SHARED_ROOT)/pretty.pl ld $@
	@echo "*** PURE_CMDLINE for $(SUITE) ***"
	@echo "$(PRE_CMDLINE); $(PURE_CMDLINE)" | $(PERL) $(SHARED_ROOT)/pretty.pl ld $@
	@echo "*** CXX_COMPILE_CMDLINE for $(SUITE) ***"
	@echo "$(PRE_CMDLINE); $(CXX_COMPILE_CMDLINE)" | $(PERL) $(SHARED_ROOT)/pretty.pl cc $@

#		Remove the object files for the current suite
ifeq ("$(INSTREPO)", "1") 
clean::
	@echo Removing all .o files from suite $(SUITE) beneath `pwd`
	rm -f $(INSTANTIATION_DIR)/*.o; \
	@$(foreach dir,$(shell $(FIND) . -name $(SUITE)),rm -f $(dir)/*.o;)
else
clean::
	@echo Removing all .o files from suite $(SUITE) beneath `pwd`
	@$(foreach dir,$(shell $(FIND) . -name $(SUITE)),rm -f $(dir)/*.o;)
endif
 
#		Remove the entire directory for the current suite (recursively below cwd).
cleansuite::
	@echo Removing all $(SUITE) subdirectories beneath `pwd`
	@$(foreach dir,$(shell $(FIND) . -name $(SUITE)),rm -rf $(dir);)
 
#		Remove all .o files below cwd.
realclean::
	@echo Removing all .o files beneath `pwd`
	$(FIND) . -name "*.[o]" -exec rm {} \;
 
#		Clean out the files & directories for ALL suites.
#		Suites are identified by $(CONFIG_ROOT)/*.suite.mk
#               Only suite that have a corresponding 'lib' subdirectory
#               are removed, though.
realcleansuite::
	@echo Removing all suite directories beneath `pwd`; \
	for suite in $(basename $(basename $(notdir $(wildcard $(CONFIG_ROOT)/*.suite.mk)))); do\
		if [ -d $(PROJECT_ROOT)/lib/$$suite ]; then\
			SUITE=$$suite;export SUITE;\
			echo Removing suite $$SUITE beneath `pwd`;\
			$(MAKE) --silent cleansuite;\
		fi; \
	done
 
#		Clean out the files & directories for ALL suites.
#		Suites are identified by $(CONFIG_ROOT)/*.suite.mk.  This
#               also delete the *.suite.mk files themselves.  Only suite that
#               have a corresponding 'lib' subdirectory are removed, though.
realrealcleansuite::
	@echo Removing all suite directories beneath `pwd`; \
	for suite in $(basename $(basename $(notdir $(wildcard $(CONFIG_ROOT)/*.suite.mk)))); do\
		if [ -d $(PROJECT_ROOT)/lib/$$suite ]; then \
			echo Removing suite $$suite beneath `pwd`; \
			$(MAKE) SUITE=$$suite --silent cleansuite; \
			if [ ! -d $(PROJECT_ROOT)/lib/$$suite ]; then \
				rm $(CONFIG_ROOT)/$$suite.suite.mk; \
				rm $(CONFIG_ROOT)/$$suite.variables.mk; \
			fi; \
		fi; \
	done
 
#		Install this package to the INSTALL_DIR location, using a
#		script in the bin directory.
install::
	@echo Installing files to directory $(INSTALL_DIR) ... ; \
	cd $(PROJECT_ROOT) ; \
	bin/makeinstall $(SUITE) $(INSTALL_DIR) $(INSTALL_ARCH) $(INSTALL_LIBEXT) $(INSTALL_EXT)
 
#		Create a distribution file for this project, and place it in
#		the top level of the build tree.
distrib::
	@echo Creating distribution file $(DISTRIB_FILE) ... ; \
	cd $(PROJECT_ROOT) ; \
	bin/makedistrib $(DISTRIB_BASE)
 
#               Create the suite directories, but leave them empty
dirs::
	@echo "Making directories for suite=$(SUITE)...";\
	x=`$(FIND) . -name include.mk -print`;\
	for m in $$x lib/include.mk; do \
	  d=`dirname $$m`; \
	  if [ ! -d "$$d/src" ]; then \
	    if [ ! -d "$$d/$(SUITE)" ]; then \
	      mkdir -p $$d/$(SUITE); \
	    fi; \
	    if [ ! -r "$$d/$(SUITE)/Makefile" ]; then \
	      ln -s $(SHARED_ROOT)/Makefile $$d/$(SUITE)/Makefile; \
	    fi; \
	  fi; \
	done

newproject:
	@$(PERL) $(SHARED_ROOT)/newproject.pl	

newuser:
	@if [ "x$(USER_PREF_NAME)" = "x" ]; then \
		echo "You need to permanently set the environment variable "$$"USER_PREF_NAME before this will work.";\
		exit 9;\
	fi;
	@$(PERL) $(SHARED_ROOT)/new.pl newuser "$(SHARED_ROOT)/user_$(USER_PREF_NAME).mk" $(USER_PREF_NAME)


############################################################################
# "Debugging" rules go here

mt: mt1 mt2 mt3 mt4 mt5 

mt1:
	@echo "mt1 ----------------------------------------"
	@echo "From SHARED_ROOT/rules.mk"
	@echo "PROJECT_ROOT      = *$(PROJECT_ROOT)*"
	@echo "SHARED_ROOT       = *$(SHARED_ROOT)*"
	@echo "ODIR                  = $(ODIR)"
	@echo "THISDIR               = $(THISDIR)"
	@echo "NEXTDIR               = $(NEXTDIR)"
	@echo "UNIQUE                = $(UNIQUE)"

mt2:
	@echo "mt2 ----------------------------------------"
	@echo "From SHARED_ROOT/rules.mk"
	@echo -n "LOCAL_OBJS            = "
	@for obj in "" $(LOCAL_OBJS);     do echo "   $$obj"; done;
	@echo -n "UNIQUE OBJS           = "
	@for obj in "" $($(UNIQUE)_OBJS); do echo "   $$obj"; done;
	@echo -n "TEST_OBJS             = "
	@for obj in "" $(TEST_OBJS);      do echo "   $$obj"; done;
	@echo -n "TEST1_OBJS            = "
	@for obj in "" $(TEST1_OBJS);     do echo "   $$obj"; done;

mt3:
	@echo "mt3 ----------------------------------------"
	@echo "PROJECT_INTERMEDIATES = $(PROJECT_INTERMEDIATES)"
	@echo "DIR_LIST              = $(DIR_LIST)"
	@echo "SUITE                 = $(SUITE)"

mt4:
	@echo "mt4 ----------------------------------------"
	@echo "PROJECT_ROOT          = $(PROJECT_ROOT)"
	@echo -n "SUITE_INCLUDES      = "
	@for obj in "" $(SUITE_INCLUDES); do echo "   $$obj"; done;
	@echo -n "RULE_INCLUDES      = "
	@for obj in "" $(RULE_INCLUDES); do echo "   $$obj"; done;

mt5:
	@echo "mt5 ----------------------------------------"
	@echo "SUFFIXES          = $(SUFFIXES)"

############################################################################
# Macro definitions. 

ifeq ("$(PRELINKSTEP)", "1") 
define ArchiveToSuite
	$(ToSuiteSetup)
	@echo ArchiveToSuite... See $(subst $(THISDIR)/,,$(INFO_FILE));
	@echo "$(PRE_CMDLINE) $(PRELINK_CMDLINE)" | $(PERL) $(SHARED_ROOT)/pretty.pl cc >> $(INFO_FILE);
	-@$(PRE_CMDLINE) $(PRELINK_CMDLINE) $(SUITE_REDIRECT);
	@echo "$(PRE_CMDLINE) $(AR_CMDLINE)" | $(PERL) $(SHARED_ROOT)/pretty.pl ar >> $(INFO_FILE);
	@$(PRE_CMDLINE) $(AR_CMDLINE) $(SUITE_REDIRECT)
	$(infotimestamp)
	@if [ ! -r $@ ]; then \
		echo "Error archiving $@";\
		exit 9;\
	else\
		echo "Done archiving $@";\
	fi
endef
else
define ArchiveToSuite
	$(ToSuiteSetup)
	@echo ArchiveToSuite... See $(subst $(THISDIR)/,,$(INFO_FILE));
	@echo "$(PRE_CMDLINE) $(AR_CMDLINE)" | $(PERL) $(SHARED_ROOT)/pretty.pl ar >> $(INFO_FILE);
	@$(PRE_CMDLINE) $(AR_CMDLINE) $(SUITE_REDIRECT)
	$(infotimestamp)
	@if [ ! -r $@ ]; then \
		echo "Error archiving $@";\
		exit 9;\
	else\
		echo "Done archiving $@";\
	fi
endef
endif
 
define LinkToSuite
	$(ToSuiteSetup)
	@echo Linker location: `which $(LD)`    >> $(INFO_FILE);
	@echo LinkToSuite... See $(subst $(THISDIR)/,,$(INFO_FILE));\
	echo "$(PRE_CMDLINE) $(LD_LINK_CMDLINE)" | $(PERL) $(SHARED_ROOT)/pretty.pl ld >> $(INFO_FILE);
	@$(PRE_CMDLINE) $(LD_LINK_CMDLINE) $(SUITE_REDIRECT)
	@-ln -f $@ $@_$(PASS)
	$(infotimestamp)
	@if [ ! -r $@ ]; then \
		echo "Error linking $@";\
		exit 9;\
	else\
		echo "Done linking $@";\
	fi;
endef

define ToSuiteSetup
	$(removeinfofile)
	-@$(maketargetdir)
	$(infotimestamp)
	$(maketempdir)
endef

define ToSuiteDebug
	@echo
	@echo "PRE_CMDLINE         = $(PRE_CMDLINE)"
	@echo "TOUCH_CMDLINE       = $(TOUCH_CMDLINE)"
	@echo "PREPROCESS_CMDLINE  = $(PREPROCESS_CMDLINE)"
	@echo "LD_LINK_CMDLINE     = $(LD_LINK_CMDLINE)"
	@echo "AR_CMDLINE          = $(AR_CMDLINE)"
	@echo "CXX_COMPILE_CMDLINE = $(CXX_COMPILE_CMDLINE)"
	@echo "C_COMPILE_CMDLINE   = $(C_COMPILE_CMDLINE)"
	@echo "INFO_FILE           = $(INFO_FILE)"
	@echo "SUITE_REDIRECT      = $(SUITE_REDIRECT)"
	@echo
endef
#	$(ToSuiteDebug)

define CXXToSuite
	$(ToSuiteSetup)
	@echo Compiler location: `which $(CXX)`    >> $(INFO_FILE)
	@echo CXXToSuite... See $(subst $(THISDIR)/,,$(INFO_FILE))
	@echo "$(PRE_CMDLINE) $(CXX_COMPILE_CMDLINE)" | $(PERL) $(SHARED_ROOT)/pretty.pl cc >> $(INFO_FILE)
	@$(PRE_CMDLINE) $(CXX_COMPILE_CMDLINE) $(SUITE_REDIRECT)
	$(infotimestamp)
endef
#	@if [ ! -r $@ ]; then exit 9; fi;

define CXXProfileToSuite
	$(ToSuiteSetup)
	@echo Compiler location: `which $(CXX)`    >> $(INFO_FILE)
	@echo CXXProfileToSuite... See $(subst $(THISDIR)/,,$(INFO_FILE))
	@echo "$(PRE_CMDLINE) $(CXX_PROFILE_COMPILE_CMDLINE)" | $(PERL) $(SHARED_ROOT)/pretty.pl cc >> $(INFO_FILE)
	@$(PRE_CMDLINE) $(CXX_PROFILE_COMPILE_CMDLINE) $(SUITE_REDIRECT)
	$(infotimestamp)
endef

define CXXInstrumentToSuite
	$(ToSuiteSetup)
	@echo Instrumentor location: $(TAUINSTR)    >> $(INFO_FILE)
	@echo CXXInstrumentToSuite... See $(subst $(THISDIR)/,,$(INFO_FILE))
	@echo "$(PRE_CMDLINE) $(INSTRUMENT_CMDLINE)" | $(PERL) $(SHARED_ROOT)/pretty.pl cc >> $(INFO_FILE)
	@$(PRE_CMDLINE) $(INSTRUMENT_CMDLINE) $(SUITE_REDIRECT)
	$(infotimestamp)
endef

define CXXToPDB
	$(ToSuiteSetup)
	@echo cxxparse location: $(TAUPARSE)    >> $(INFO_FILE)
	@echo CXXToPDB... See $(subst $(THISDIR)/,,$(INFO_FILE))
	@echo "$(PDB_PRE_CMDLINE) $(PDB_CMDLINE)" | $(PERL) $(SHARED_ROOT)/pretty.pl cc >> $(INFO_FILE)
	@$(PDB_PRE_CMDLINE) $(PDB_CMDLINE) $(SUITE_REDIRECT)
	$(infotimestamp)
endef

define CCToSuite
	$(ToSuiteSetup)
	@echo Compiler location: `which $(CC)`    >> $(INFO_FILE)
	@echo CCToSuite... See $(subst $(THISDIR)/,,$(INFO_FILE))
	@echo "$(PRE_CMDLINE) $(C_COMPILE_CMDLINE)" | $(PERL) $(SHARED_ROOT)/pretty.pl cc >> $(INFO_FILE)
	@$(PRE_CMDLINE) $(C_COMPILE_CMDLINE) $(SUITE_REDIRECT)
	$(infotimestamp)
endef

define F77ToSuite
        $(ToSuiteSetup)
        @echo Compiler location: `which $(F77)`    >> $(INFO_FILE)
        @echo F77ToSuite... See $(subst $(THISDIR)/,,$(INFO_FILE))
        @echo "$(PRE_CMDLINE) $(F77_COMPILE_CMDLINE)" | $(PERL) $(SHARED_ROOT)/pretty.pl cc >> $(INFO_FILE)
        @$(PRE_CMDLINE) $(F77_COMPILE_CMDLINE) $(SUITE_REDIRECT)
        $(infotimestamp)
endef

define TouchToSuite
	$(ToSuiteSetup)
	@echo TouchToSuite... See $(subst $(THISDIR)/,,$(INFO_FILE));
	@echo "$(PRE_CMDLINE) $(TOUCH_CMDLINE)" | $(PERL) $(SHARED_ROOT)/pretty.pl >> $(INFO_FILE)
	@$(PRE_CMDLINE) $(TOUCH_CMDLINE) $(SUITE_REDIRECT)
	$(infotimestamp)
endef

define PreprocessToSuite
	$(ToSuiteSetup)
	@echo PreprocessToSuite... See $(subst $(THISDIR)/,,$(INFO_FILE));
	@$(PRE_CMDLINE) $(PREPROCESS_CMDLINE) $(SUITE_REDIRECT);
	$(infotimestamp)
endef
 
define maketargetdir
	if [ ! -d "$(dir $@)" ]; then mkdir $(dir $@); fi;\
	if [ ! -h "$(dir $@)Makefile" ]; then ln -s $(SHARED_ROOT)/Makefile $(dir $@)Makefile; fi
endef
 
define maketempdir
	@if [ ! -d "$(TMPDIR)/$(SUITE)" ]; then mkdir -p $(TMPDIR)/$(SUITE); fi;
endef
 
define removeinfofile
	@if [ -f "$(INFO_FILE)" ]; then rm $(INFO_FILE); fi
endef

define infotimestamp
	@echo `date`           >>  $(INFO_FILE)
endef
 
define infohoststamp
	@echo `hostname`:`pwd` >>  $(INFO_FILE)
endef


