# Build up the commands used to execute compilers, linkers, etc.

# Do this here rather than in rules.mk, because multiple macros need access to them.

# Strip PROJECT_ROOT from include paths, since all compiles will be relative to it.
#RULE_INCLUDES       := $(subst $(PROJECT_ROOT)/,,$(SUITE_INCLUDES))
#RULE_INCLUDES       := $(subst $(PROJECT_ROOT),.,$(RULE_INCLUDES))
RULE_INCLUDES        = $(SUITE_INCLUDES)

# Select first- (or 'other-pass') flags with C++ compiler
RULE_CXXOPTS         = $(SUITE_CXXOPTS_$(PASS))

# Select first- (or 'other-pass') flags with C compiler
RULE_COPTS           = $(SUITE_COPTS_$(PASS))

# Select first- (or 'other-pass') flags with F77 compiler
RULE_F77OPTS         = $(SUITE_F77OPTS_$(PASS))

# Select first- (or 'other-pass') flags with archiver
RULE_AR_OPTS         = $(SUITE_AROPTS_$(PASS))

# Select first- (or 'other-pass') flags with prelinker
RULE_PRELINK_OPTS    = $(SUITE_PRELINKOPTS_$(PASS))

# Select first- (or 'other-pass') flags with linker
RULE_LD_OPTS         = $(SUITE_LDOPTS_$(PASS))



# Name of file to contain stderr & stdout
INFO_FILE            = $@_$(PASS).info

# This is prepended to compile, link, archive, preprocess, etc rules.
PRE_CMDLINE          = TMPDIR=$(TMPDIR)/$(SUITE); $(TIME)

# This is prepended to compile, link, archive, preprocess, etc rules.
PDB_PRE_CMDLINE      = cd $(@D); TMPDIR=$(TMPDIR)/$(SUITE); $(TIME)

# Build command line for preprocessor
PREPROCESS_CMDLINE   = $(CXX) $< -E $(SUITE_DEFINES) $(RULE_CXXOPTS) $(RULE_INCLUDES) 

# Build command line for C++ compiler
CXX_COMPILE_CMDLINE  = $(CXX) -c $< -o $@ $(SUITE_DEFINES) $(RULE_CXXOPTS) $(RULE_INCLUDES) 

# Build command line for C++ compiler while profiling
CXX_PROFILE_COMPILE_CMDLINE  = $(CXX) -c $< -o $@ $(SUITE_DEFINES) $(RULE_CXXOPTS) $(RULE_INCLUDES) -I$(@D)/..

# Build command line for C compiler
C_COMPILE_CMDLINE  = $(CC) -c $< -o $@ $(SUITE_DEFINES) $(RULE_COPTS) $(RULE_INCLUDES)

# TAU instrumentation command line
INSTRUMENT_CMDLINE = $(TAUINSTR) $? -o $@

# Command line to generate .pdb file
PDB_CMDLINE = $(TAUPARSE) $< $(SUITE_INCLUDES) -I$(@D)/..

# Build command line for F77 compiler
F77_COMPILE_CMDLINE  = $(F77) -c $< -o $@ $(SUITE_DEFINES) $(RULE_F77OPTS) $(RULE_INCLUDES)

# touch command line 
TOUCH_CMDLINE        = $(TOUCH) $@

# Build command line for prelink step
PRELINK_CMDLINE = $(PRELINK) $(RULE_PRELINK_OPTS) $(filter %.o,$+)

# Build command line for archiver
ifeq ("$(INSTREPO)", "1") 
	AR_CMDLINE = $(AR) $(RULE_AR_OPTS) $@ $(filter %.o,$+) $(INSTANTIATION_DIR)/*.o
else
	AR_CMDLINE = $(AR) $(RULE_AR_OPTS) $@ $(filter %.o,$+)
endif

# Build command line for loader

ifeq ("$(LD)", "purify")
# Build Purify command line
	LD_LINK_CMDLINE = $(PURIFY) $(SUITE_PURIFY_OPTS) $(CXX) -o $@ $+ $(RULE_LD_OPTS)
else
# Build normal link command line.
	LD_LINK_CMDLINE = $(LD) -o $@ $+ $(RULE_LD_OPTS) 
endif

# rules and macros
include $(SHARED_ROOT)/rules.mk

# Include (if it exists) the dependency file.
-include $(LIBRARY_ROOT)/depend.mk


# ACL:rcsinfo
#  ----------------------------------------------------------------------
#  $RCSfile: tail.mk,v $   $Author: richard $
#  $Revision: 1.21 $   $Date: 2004/11/01 18:15:22 $
#  ----------------------------------------------------------------------
# ACL:rcsinfo
