// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//
//-----------------------------------------------------------------------------
// Contents:
//   Laplacian implemented as a stencil
//-----------------------------------------------------------------------------

#include <iostream>
#include "Pooma/Arrays.h"
#include "LaplaceStencil.h"

static const int DefaultWorldSize = 100;
static const int DefaultNumIter   =  10;

//-----------------------------------------------------------------------------
// Main program
//-----------------------------------------------------------------------------

int main(int argc, char* argv[])
{
  Pooma::initialize(argc,argv);

  // get problem size, number of iterations, and RNG seed
  if (argc != 3){
    std::cerr << "usage: Laplace worldSize numIter" << std::endl;
    exit(1);
  }
  int worldSize = atoi(argv[1]);
  int numIter   = atoi(argv[2]);

  // create the world array, and the stencil used to update it
  Array<2> world(worldSize, worldSize);
  Stencil<LaplaceStencil> stencil;

  // describe the interior of the world
  Interval<1> interior_1(1, worldSize-2);
  Interval<2> interior_2(interior_1, interior_1);

  // initialize array element values
  world = 0.0;
  Pooma::blockAndEvaluate();
  world(worldSize/2, worldSize/2) = 2.0 * numIter;
  std::cout << "start" << std::endl << world << std::endl << std::endl;

  // update elements
  for (int i=0; i<numIter; ++i) {
    world(interior_2) = stencil(world);
    Pooma::blockAndEvaluate();
    std::cout << i << std::endl << world << std::endl << std::endl;
  }
  
  Pooma::finalize();
  return 0;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Laplace.cpp,v $
// $Revision: 1.8 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
