// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//

#ifndef POOMA_POOMA_ARRAYS_H
#define POOMA_POOMA_ARRAYS_H


/** @file
 * @ingroup Pooma
 * @brief
 * A one-stop-shopping header file that sets up everything one needs to use
 * all Pooma II arrays with Tiny things and complex numbers.
 */

// Include files

#include "Pooma/UMPArrays.h"
#include "Pooma/GMPArrays.h"
#include "Pooma/Indices.h"
#include "Engine/UserFunction.h"
#include "Engine/Stencil.h"
#include "Engine/ConstantFunctionEngine.h"
#include "Engine/IndexFunctionEngine.h"
#include "Engine/RemoteEngine.h"

#include "Pooma/Tiny.h"

#include "Evaluator/ScalarCode.h"

#include "Functions/PackUnpack.h"

#include <complex>

#endif

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Arrays.h,v $   $Author: richard $
// $Revision: 1.19 $   $Date: 2004/11/01 18:17:03 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
