;;; color.scm: adds color to  messages from buddies
;;; author: Anand Babu <ab@zresearch.com>
;;; Based on freehoo's color.scm by Nirranjan.K <nirranjan@yahoo.com>
;;; copyright 2005 FreeTalk Core Team

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or (at
;;; your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
;;; 
;;; color.scm should be automatically loaded thru init.scm
;;; /eval (ft-set-buddy-color! <buddy name> <color>)
;;; /eval (set! ft-default-color <color>)
;;;
;;; example:
;;; /color-buddy balugi yellow
;;; /color-disable
;;; /color-enable

(use-modules (ice-9 regex))

(define enable-colors-flag "yes")

(define color-list 
  '(("yellow" . "33")
    ("magenta" . "35")
    ("cyan" . "36")
    ("white" . "37")
    ("red" . "31")
    ("green" . "32")
    ("blue" . "34")))


(if (defined? 'auto-color-list)
    '()
    (define auto-color-list '()))


(if (defined? 'default-color)
    '()
    (begin
      (define default-color "cyan")))

(define (set-buddy-color! buddy color)
  "specify color for buddies"
  (if (assoc buddy auto-color-list)
      (set! auto-color-list
	    (delete (cons 
		     buddy 
		     (cdr (assoc buddy auto-color-list)))
		    auto-color-list)))
  (set! auto-color-list 
	(append auto-color-list 
		(list (cons buddy color)))))

(define (get-buddy-color buddy)
  (if (assoc buddy auto-color-list)
      '()
      (begin
	(set! auto-color-list
	      (append 
	       auto-color-list 
	       (list (cons 
		      buddy 
		      (car (list-ref color-list 
				     (modulo 
				      (length auto-color-list) 
				      (length color-list))))))))))
  (cdr (assoc buddy auto-color-list)))

(define (color-message msg color)
  "adds color to message"
  (define col-no (cdr (assoc default-color color-list))) 
  (and (assoc color color-list)
       (set! col-no (cdr (assoc color color-list  ))))
  (string-append "[1;" col-no ";40m" msg "[0m"))

(define (append-color timestamp from msg)
  "append color"
  (if (equal? enable-colors-flag "yes")
      (begin
	(if (get-buddy-color from)
	    (begin
	      (ft-display 
	       (string-append
                (if (> (string-length timestamp) 0)
                    (color-message (string-append "[" timestamp "] ")
                                   (get-buddy-color from))
                    "")
		(color-message from (get-buddy-color from))
		(color-message " -> " (get-buddy-color from))
		(color-message msg (get-buddy-color from))))
	      (ft-hook-return))))))

(add-hook! ft-message-receive-hook append-color)

(define (enable-colors)
  (set! enable-colors-flag "yes"))

(define (disable-colors)
  (set! enable-colors-flag "no"))

