;;; init.scm: startup extension
;;; author: Anand Babu <ab@gnu.org.in>
;;; copyright 2005 FreeTalk Core Team

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or (at
;;; your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA

(use-modules (ice-9 debugger))
(debug-enable 'backtrace)

(catch #t
       (lambda ()
	 ;; IMPORTANT: ORDER OF LOADING EXETNSIONS IS DEPENDENT ON THE
         ;;            EXTENSIONS THEMSELVES.

	 ; (ft-load "pre-login-extensions-here.scm")
	 (ft-load "dyn-commands.scm")

	 (if (= (system "dict gnu >> /dev/null 2>&1") 0)
	     (ft-load "dict-buddy.scm"))
	 (if (= (system "beep -f 1 -l 0 >> /dev/null 2>&1") 0)
	     (ft-load "beep.scm"))

	 (ft-load "utils.scm")
	 (ft-load "mr-oxford.scm") 
	 (ft-load "shell.scm")
	 (ft-load "pipe.scm")
	 (ft-load "state.scm")
	 (ft-load "connection.scm")
	 (ft-load "roster.scm")
	 (ft-load "color.scm")
     (ft-load "history.scm")
 ;; FIXME: login.scm should not be loaded when run in script mode.
;	 (ft-load "login.scm")
       ; (ft-load "post-login-extensions-here.scm")
	 )
       (lambda (k args . opts)
	 (display "\n~qp~ ~qp~ ~qp~ ~qp~ ~qp~ ~qp~")
	 (display "\n~qp  FreeTalk Exception! ~qp~")
	 (display "\n~qp~ ~qp~ ~qp~ ~qp~ ~qp~ ~qp~")
	 (display "\n(SCM exception handler)")
	 (display "\nkey        : ")
	 (display k)
	 (display "\nthrow args : ")
	 (display args)
	 (display "\nopts       : ")
	 (display opts)
	 (newline)
	 (backtrace)
	 (newline)))
