/*******************************************************************
 *
 *  grx11.h  graphics driver for X11 (header)
 *
 *  This is the driver for displaying inside a window under X11,
 *  used by the graphics utility of the FreeType test suite.
 *
 *  Copyright (C) 1999-2023 by
 *  Antoine Leca, David Turner, Robert Wilhelm, and Werner Lemberg.
 *
 *  This file is part of the FreeType project, and may only be used
 *  modified and distributed under the terms of the FreeType project
 *  license, LICENSE.TXT. By continuing to use, modify or distribute
 *  this file you indicate that you have read the license and
 *  understand and accept it fully.
 *
 ******************************************************************/

#ifndef GRX11_H_
#define GRX11_H_

#define visualClass(x)  ( x->Class == StaticGray  ? "StaticGray"  : \
                          x->Class == GrayScale   ? "GrayScale"   : \
                          x->Class == StaticColor ? "StaticColor" : \
                          x->Class == PseudoColor ? "PseudoColor" : \
                          x->Class == TrueColor   ? "TrueColor"   : \
                          x->Class == DirectColor ? "DirectColor" : "unknown" )

#if defined( __cplusplus ) || defined( c_plusplus )
#define Class  c_class
#else
#define Class  class
#endif

#include "grdevice.h"

  extern
  grDevice  gr_x11_device;

#ifdef GR_INIT_BUILD
  static
  grDeviceChain  gr_x11_device_chain =
  {
    "x11",
    &gr_x11_device,
    GR_INIT_DEVICE_CHAIN
  };

#undef GR_INIT_DEVICE_CHAIN
#define GR_INIT_DEVICE_CHAIN  &gr_x11_device_chain

#endif  /* GR_INIT_BUILD */

#endif /* GRX11_H_ */
