/* This file has been generated by the Perl script `afblue.pl', */
/* using data from file `./tablue.dat'.                         */

/* tablue.h */

/*
 * Copyright (C) 2013-2015 by Werner Lemberg.
 *
 * This file is part of the ttfautohint library, and may only be used,
 * modified, and distributed under the terms given in `COPYING'.  By
 * continuing to use, modify, or distribute this file you indicate that you
 * have read `COPYING' and understand and accept it fully.
 *
 * The file `COPYING' mentioned in the previous paragraph is distributed
 * with the ttfautohint library.
 */


/* originally file `afblue.h' (2013-Sep-11) from FreeType */


#ifndef __TABLUE_H__
#define __TABLUE_H__


  /* an auxiliary macro to decode a UTF-8 character -- since we only use */
  /* hard-coded, self-converted data, no error checking is performed */
#define GET_UTF8_CHAR(ch, p) \
  ch = (unsigned char)*p++; \
  if (ch >= 0x80) \
  { \
    FT_UInt len; \
\
\
    if (ch < 0xE0) \
    { \
      len = 1; \
      ch &= 0x1F; \
    } \
    else if (ch < 0xF0) \
    { \
      len = 2; \
      ch &= 0x0F; \
    } \
    else \
    { \
      len = 3;\
      ch &= 0x07; \
    } \
\
    for (; len > 0; len--) \
      ch = (ch << 6) | (*p++ & 0x3F); \
  }


/****************************************************************
 *
 *                        BLUE STRINGS
 *
 ****************************************************************/

/* At the bottommost level, we define strings for finding blue zones. */


#define TA_BLUE_STRING_MAX_LEN 9

/* The TA_Blue_String enumeration values are offsets into the */
/* `ta_blue_strings' array. */

typedef enum TA_Blue_String_
{
    TA_BLUE_STRING_ARABIC_TOP = 0,
    TA_BLUE_STRING_ARABIC_BOTTOM = 13,
    TA_BLUE_STRING_ARABIC_JOIN = 24,
    TA_BLUE_STRING_CYRILLIC_CAPITAL_TOP = 27,
    TA_BLUE_STRING_CYRILLIC_CAPITAL_BOTTOM = 44,
    TA_BLUE_STRING_CYRILLIC_SMALL = 61,
    TA_BLUE_STRING_CYRILLIC_SMALL_DESCENDER = 78,
    TA_BLUE_STRING_DEVANAGARI_BASE = 85,
    TA_BLUE_STRING_DEVANAGARI_TOP = 110,
    TA_BLUE_STRING_DEVANAGARI_HEAD = 135,
    TA_BLUE_STRING_DEVANAGARI_BOTTOM = 160,
    TA_BLUE_STRING_GREEK_CAPITAL_TOP = 167,
    TA_BLUE_STRING_GREEK_CAPITAL_BOTTOM = 182,
    TA_BLUE_STRING_GREEK_SMALL_BETA_TOP = 195,
    TA_BLUE_STRING_GREEK_SMALL = 208,
    TA_BLUE_STRING_GREEK_SMALL_DESCENDER = 225,
    TA_BLUE_STRING_HEBREW_TOP = 242,
    TA_BLUE_STRING_HEBREW_BOTTOM = 259,
    TA_BLUE_STRING_HEBREW_DESCENDER = 272,
    TA_BLUE_STRING_LAO_TOP = 283,
    TA_BLUE_STRING_LAO_BOTTOM = 308,
    TA_BLUE_STRING_LAO_ASCENDER = 333,
    TA_BLUE_STRING_LAO_LARGE_ASCENDER = 346,
    TA_BLUE_STRING_LAO_DESCENDER = 356,
    TA_BLUE_STRING_LATIN_CAPITAL_TOP = 375,
    TA_BLUE_STRING_LATIN_CAPITAL_BOTTOM = 384,
    TA_BLUE_STRING_LATIN_SMALL_F_TOP = 393,
    TA_BLUE_STRING_LATIN_SMALL = 401,
    TA_BLUE_STRING_LATIN_SMALL_DESCENDER = 409,
    TA_BLUE_STRING_LATIN_SUBS_CAPITAL_TOP = 415,
    TA_BLUE_STRING_LATIN_SUBS_CAPITAL_BOTTOM = 431,
    TA_BLUE_STRING_LATIN_SUBS_SMALL_F_TOP = 447,
    TA_BLUE_STRING_LATIN_SUBS_SMALL = 463,
    TA_BLUE_STRING_LATIN_SUBS_SMALL_DESCENDER = 491,
    TA_BLUE_STRING_LATIN_SUPS_CAPITAL_TOP = 507,
    TA_BLUE_STRING_LATIN_SUPS_CAPITAL_BOTTOM = 531,
    TA_BLUE_STRING_LATIN_SUPS_SMALL_F_TOP = 553,
    TA_BLUE_STRING_LATIN_SUPS_SMALL = 573,
    TA_BLUE_STRING_LATIN_SUPS_SMALL_DESCENDER = 592,
    TA_BLUE_STRING_TELUGU_TOP = 601,
    TA_BLUE_STRING_TELUGU_BOTTOM = 623,
    TA_BLUE_STRING_THAI_TOP = 645,
    TA_BLUE_STRING_THAI_BOTTOM = 664,
    TA_BLUE_STRING_THAI_ASCENDER = 686,
    TA_BLUE_STRING_THAI_LARGE_ASCENDER = 696,
    TA_BLUE_STRING_THAI_DESCENDER = 706,
    TA_BLUE_STRING_THAI_LARGE_DESCENDER = 719,
    TA_BLUE_STRING_THAI_DIGIT_TOP = 726,


  TA_BLUE_STRING_MAX   /* do not remove */
} TA_Blue_String;


extern const char ta_blue_strings[];


/****************************************************************
 *
 *                      BLUE STRINGSETS
 *
 ****************************************************************/

/* The next level is to group blue strings into style-specific sets. */


/* Properties are specific to a writing system.  We assume that a given */
/* blue string can't be used in more than a single writing system, which */
/* is a safe bet. */
#define TA_BLUE_PROPERTY_LATIN_TOP (1U << 0) /* must have value 1 */
#define TA_BLUE_PROPERTY_LATIN_NEUTRAL (1U << 1)
#define TA_BLUE_PROPERTY_LATIN_X_HEIGHT (1U << 2)
#define TA_BLUE_PROPERTY_LATIN_LONG (1U << 3)


#define TA_BLUE_STRINGSET_MAX_LEN 8

/* The TA_Blue_Stringset enumeration values are offsets into the */
/* `ta_blue_stringsets' array. */

typedef enum TA_Blue_Stringset_
{
    TA_BLUE_STRINGSET_ARAB = 0,
    TA_BLUE_STRINGSET_CYRL = 4,
    TA_BLUE_STRINGSET_DEVA = 10,
    TA_BLUE_STRINGSET_GREK = 16,
    TA_BLUE_STRINGSET_HEBR = 23,
    TA_BLUE_STRINGSET_LAO = 27,
    TA_BLUE_STRINGSET_LATN = 33,
    TA_BLUE_STRINGSET_LATB = 40,
    TA_BLUE_STRINGSET_LATP = 47,
    TA_BLUE_STRINGSET_TELU = 54,
    TA_BLUE_STRINGSET_THAI = 57,


  TA_BLUE_STRINGSET_MAX   /* do not remove */
} TA_Blue_Stringset;


typedef struct TA_Blue_StringRec_
{
  TA_Blue_String string;
  FT_UShort properties;
} TA_Blue_StringRec;


extern const TA_Blue_StringRec ta_blue_stringsets[];

#endif /* __TABLUE_H__ */

/* end of tablue.h */
