PLUGINSRCDIR = $(top_srcdir)/xmms

I_LIBS += $(top_srcdir)/freeverb/libfreeverb3.la

if BUILD_PLUGDOUBLE
I_LIBS += $(fftw3_LIBS)
else
I_LIBS += $(fftw3f_LIBS)
endif

INCLUDES = -I$(top_srcdir) -I$(top_srcdir)/libgdither -I$(top_srcdir)/xmms/ $(fftw3f_CFLAGS) $(fftw3_CFLAGS)

DSP_PLUGINS = libfreeverb3.la librevmodel.la libimpulser2.la libmbcomp.la libstenh.la \
 libstrev.la libprogenitor.la libgd_lroom.la libearlyr.la libearlyr2.la libnoise1.la libzrev1.la libzrev2.la

if BUILD_PLUGDOUBLE
INCLUDES += -DPLUGDOUBLE
endif

if ENABLE_PLUGINIT
INCLUDES += -DPLUGINIT
endif

if AUDACIOUS140
INCLUDES += -DAUDACIOUS140
endif

libfreeverb3_la_LDFLAGS = -module -avoid-version
libfreeverb3_la_LIBADD = $(I_LIBS)
libfreeverb3_la_SOURCES = $(PLUGINSRCDIR)/freeverb3.cpp

librevmodel_la_LDFLAGS = -module -avoid-version
librevmodel_la_LIBADD = $(I_LIBS)
librevmodel_la_SOURCES = $(PLUGINSRCDIR)/xmms_defs.h $(PLUGINSRCDIR)/libxmmsplugin.hpp $(PLUGINSRCDIR)/libxmmsplugin_table.hpp $(PLUGINSRCDIR)/revmodel.cpp

libimpulser2_la_LDFLAGS = -module -avoid-version
libimpulser2_la_LIBADD = $(I_LIBS) $(top_srcdir)/libgdither/libgdither.la $(sndfile_LIBS)
libimpulser2_la_SOURCES = $(PLUGINSRCDIR)/xmms_defs.h $(PLUGINSRCDIR)/CFileLoader_t.hpp $(PLUGINSRCDIR)/CFileLoader.hpp $(PLUGINSRCDIR)/impulser2.cpp \
	$(PLUGINSRCDIR)/wave.xpm

libmbcomp_la_LDFLAGS = -module -avoid-version
libmbcomp_la_LIBADD = $(I_LIBS)
libmbcomp_la_SOURCES = $(PLUGINSRCDIR)/xmms_defs.h $(PLUGINSRCDIR)/libxmmsplugin.hpp $(PLUGINSRCDIR)/libxmmsplugin_table.hpp $(PLUGINSRCDIR)/compressor.cpp

libstenh_la_LDFLAGS = -module -avoid-version
libstenh_la_LIBADD = $(I_LIBS)
libstenh_la_SOURCES = $(PLUGINSRCDIR)/xmms_defs.h $(PLUGINSRCDIR)/libxmmsplugin.hpp $(PLUGINSRCDIR)/libxmmsplugin_table.hpp $(PLUGINSRCDIR)/stenh.cpp

libstrev_la_LDFLAGS = -module -avoid-version
libstrev_la_LIBADD = $(I_LIBS)
libstrev_la_SOURCES = $(PLUGINSRCDIR)/xmms_defs.h $(PLUGINSRCDIR)/libxmmsplugin.hpp $(PLUGINSRCDIR)/libxmmsplugin_table.hpp $(PLUGINSRCDIR)/strev.cpp

libprogenitor_la_LDFLAGS = -module -avoid-version
libprogenitor_la_LIBADD = $(I_LIBS)
libprogenitor_la_SOURCES = $(PLUGINSRCDIR)/xmms_defs.h $(PLUGINSRCDIR)/libxmmsplugin.hpp $(PLUGINSRCDIR)/libxmmsplugin_table.hpp $(PLUGINSRCDIR)/progenitor.cpp

libgd_lroom_la_LDFLAGS = -module -avoid-version
libgd_lroom_la_LIBADD = $(I_LIBS)
libgd_lroom_la_SOURCES = $(PLUGINSRCDIR)/xmms_defs.h $(PLUGINSRCDIR)/libxmmsplugin.hpp $(PLUGINSRCDIR)/libxmmsplugin_table.hpp $(PLUGINSRCDIR)/gd_largeroom.cpp

libearlyr_la_LDFLAGS = -module -avoid-version
libearlyr_la_LIBADD = $(I_LIBS)
libearlyr_la_SOURCES = $(PLUGINSRCDIR)/xmms_defs.h $(PLUGINSRCDIR)/libxmmsplugin.hpp $(PLUGINSRCDIR)/libxmmsplugin_table.hpp $(PLUGINSRCDIR)/earlyr.cpp

libearlyr2_la_LDFLAGS = -module -avoid-version
libearlyr2_la_LIBADD = $(I_LIBS)
libearlyr2_la_SOURCES = $(PLUGINSRCDIR)/xmms_defs.h $(PLUGINSRCDIR)/libxmmsplugin.hpp $(PLUGINSRCDIR)/libxmmsplugin_table.hpp $(PLUGINSRCDIR)/earlyr2.cpp

libnoise1_la_LDFLAGS = -module -avoid-version
libnoise1_la_LIBADD = $(I_LIBS)
libnoise1_la_SOURCES = $(PLUGINSRCDIR)/xmms_defs.h $(PLUGINSRCDIR)/libxmmsplugin.hpp $(PLUGINSRCDIR)/libxmmsplugin_table.hpp $(PLUGINSRCDIR)/noise.cpp

libzrev1_la_LDFLAGS = -module -avoid-version
libzrev1_la_LIBADD = $(I_LIBS)
libzrev1_la_SOURCES = $(PLUGINSRCDIR)/xmms_defs.h $(PLUGINSRCDIR)/libxmmsplugin.hpp $(PLUGINSRCDIR)/libxmmsplugin_table.hpp $(PLUGINSRCDIR)/zrev1.cpp

libzrev2_la_LDFLAGS = -module -avoid-version
libzrev2_la_LIBADD = $(I_LIBS)
libzrev2_la_SOURCES = $(PLUGINSRCDIR)/xmms_defs.h $(PLUGINSRCDIR)/libxmmsplugin.hpp $(PLUGINSRCDIR)/libxmmsplugin_table.hpp $(PLUGINSRCDIR)/zrev2.cpp
