/*  copy_neuron.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int copy_neuron(struct neuron * origin, struct neuron * destiny)
{
	int k;
	
	destiny->alpha = 						origin->alpha;
	destiny->conv_rate = 		origin->conv_rate;
	destiny->bias_corr = 		origin->bias_corr;
	destiny->delta_type = 	origin->delta_type;
	destiny->momentum = 			origin->momentum;
	destiny->x_c = 								origin->x_c;
	destiny->y_c = 								origin->y_c;
	destiny->range = 						origin->range;
	destiny->num_con = 				origin->num_con;
	destiny->value =							origin->value;
	destiny->delta =							origin->delta;
	destiny->bias =								origin->bias;
		
	for (k=0; k< destiny->num_con; k++)
	{
		*(destiny->con_x+k) =				*(origin->con_x+k);
		*(destiny->con_y+k) =				*(origin->con_y+k);
		*(destiny->con_w+k) =				*(origin->con_w+k);
		*(destiny->age+k) 		=				*(origin->age+k);
		if (destiny->momentum == 1)
		{
			*(destiny->delta_con_w+k) =	*(origin->delta_con_w+k);
		}
	}
	return(1);
}
