/*  near_neuron.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* near upper = 4 */
/* near bottom = 2 */
/* near upper & near bottom = 8 */

int near_neuron(int num_neuron, struct neuron **neuron_array, int * inner_elem)
{
	int k;
	float min=1.0;
	float max=0.0;
	float x_c;
	
	for (k=0; k<num_neuron; k++)
	{
		if(*(inner_elem+k) )
		{
			x_c=neuron_array[k]->x_c;
			max = (x_c > max) ? x_c : max;
			min = (x_c < min) ? x_c : min;
		}
	}

/* Tolerance 1% */

	max -= 0.01*max;
	min += 0.01*min;

	for (k=0; k<num_neuron; k++)			
	{
		if(*(inner_elem+k) )
		{
			x_c=neuron_array[k]->x_c;
			*(inner_elem+k) = ( (max < x_c) && (min > x_c) ) ? 8 
												: (max < x_c) ? 4 : (min > x_c) ? 2 : 1;
		}				
	}
	return(1);
}
