/*  get_fitness.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int get_fitness(int poblation, float base, float boost, 
															 int * num_neuron, double * error, float * fitness)
{
	int k;
	int max_num_neuron;
	double max;
	double min;
	double range;
	
	k=0;
	while (k< poblation)
	{
		if (finite(*(error+k)))
		{
			max = *(error + k);
			min = *(error + k);
			break;
		}
		else
		{
			k++;
		}
	}
	max_num_neuron=0;

	for (k=0; k< poblation; k++)
	{
		if (finite(*(error+k)))
		{
			max = (max > *(error + k) ) ? max : *(error + k);
			min = (min > *(error + k) ) ? *(error + k) : min;
			max_num_neuron = (max_num_neuron > num_neuron[k]) ? max_num_neuron: num_neuron[k];
		}
	}
	range = (max > min) ? max - min : 1;
	
	for (k=0; k< poblation; k++)
	{
		if (finite(*(error+k)))
		{
			*(fitness + k) = base*( pow((max_num_neuron - num_neuron[k] + 1),boost)*
																			pow(base,-( (*(error + k) - min) / range) ) );
		}
		else
		{
			*(fitness + k) = 0;
		}
	}
	return(1);
}
