/*  ga_aux.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"

int clean_char_buffer(char * char_buffer)
{
	int k;
	for (k=0; k< BUFFSIZE; k++)
	{
		if ( !(strncmp("\n",char_buffer+k,1) ) )
		{
			char_buffer[k] = '\0';
			break;
		}
	}
	return(k);
}

int get_fitness(int poblation, float base, float boost, 
															 int * num_neuron, double * error, float * fitness)
{
	int k;
	int max_num_neuron;
	double max;
	double min;
	double range;
	
	k=0;
	while (k< poblation)
	{
		if (finite(*(error+k)))
		{
			max = *(error + k);
			min = *(error + k);
			break;
		}
		else
		{
			k++;
		}
	}
	max_num_neuron=0;

	for (k=0; k< poblation; k++)
	{
		if (finite(*(error+k)))
		{
			max = (max > *(error + k) ) ? max : *(error + k);
			min = (min > *(error + k) ) ? *(error + k) : min;
			max_num_neuron = (max_num_neuron > num_neuron[k]) ? max_num_neuron: num_neuron[k];
		}
	}
	range = (max > min) ? max - min : 1;
	
	for (k=0; k< poblation; k++)
	{
		if (finite(*(error+k)))
		{
			*(fitness + k) = base*( pow((max_num_neuron - num_neuron[k] + 1),boost)*
																			pow(base,-( (*(error + k) - min) / range) ) );
		}
		else
		{
			*(fitness + k) = 0;
		}
	}
	return(1);
}

int coin_toss(int seed)
{
	long int h;
	h = time(NULL);
	srand( (unsigned int) (h/2) + rand()/128 + seed);
	return((rand() > RAND_MAX/2) ? 1 : 0);
}

int toss(float prob, int seed)
{
	long double temp1;
	unsigned int temp2;
	long int h;
	h = time(NULL);

	srand( (unsigned int) (h/2) + rand()/128 + seed);

	temp1 = (long double) prob;
	temp1 *= RAND_MAX;
	temp2 = (unsigned int)temp1;

	return( (rand() < temp2) ? 1 : 0);
}

int dice_toss(int seed, int partition)
{
	int k;
	double temp;
	double value;
	long int h;
	h = time(NULL);
	srand( (unsigned int) (h/2) + rand()/128 + seed);
	
	value=(double)rand()/RAND_MAX;
	
	temp=1.0/partition;
	
	for (k=partition; k+1; k--)
	{
		if (value > k*temp)
		{
			return(k);
		}
	}
	return(partition-1);
}

float rand_gen(int seed)
{
	long int h;
	double temp;
	float ret;
	h = time(NULL);

	srand( ( (unsigned int)(h/2) )+ rand()/128 + seed);

	temp = (double) rand();
	temp /= RAND_MAX;
	ret = (float)temp;
	return(ret);
}

int roulette(int num, float *fitness)
{
	int k;
	double temp;
	float sum_fitness=0;

	for (k = 0; k < num; k++)
	{
		sum_fitness += fitness[k];
	}

	temp = (double) rand_gen(num);
	temp *= sum_fitness;

	sum_fitness = 0;

	for (k = 0; k < num; k++)
	{
		sum_fitness += *(fitness+k);
		if (sum_fitness >= temp)
		{
			return(k);
		}
	}
	return(-1);
}

int mate(int poblation, int **parents, float * fitness)
{
	int k,l;
	for (k=0; k<poblation; k++)
	{
		if ( (parents[k][0]=roulette(poblation,fitness)) < 0)
		{
			return(-1);
		}
		if ( (parents[k][1]=roulette(poblation,fitness)) < 0)
		{
			return(-1);
		}
		while (parents[k][1]==parents[k][0])
		{
			if ( (parents[k][1]=roulette(poblation,fitness)) < 0)
			{
				return(-1);
			}
		}
	}
	return(1);
}

int region_gen(float **vertice)
{
	float x1,x2,y1,y2;
	pid_t pid;
	
	pid=getpid();
		
	x1=rand_gen((int) pid);
	y1=rand_gen((int) pid);
	x2=rand_gen((int) pid+1);
	y2=rand_gen((int) pid+2);
/*
	if ( (1.0 - x1) > 0.5 )
	{
		x2 = x1 + (1.0 - pow(10000,-rand_gen((int) pid+1) ))*(1.0 - x1);
	}
	else 
	{
		x2 = x1 - (1.0 - pow(10000,-rand_gen((int) pid+1) ))*(x1);
	}

	if ( (1.0 - y1) > 0.5)
	{
		y2 = y1 + (1.0 - pow(10000,-rand_gen((int) pid+1) ))*(1.0 - y1);
	}
	else 
	{
		y2 = y1 - (1.0 - pow(10000,-rand_gen((int) pid+1) ))*(y1);
	}
*/
	vertice[0][0] = (x1 > x2) ? x2 : x1;
	vertice[0][1] = (y1 > y2) ? y2 : y1;
	vertice[1][0] = (x1 > x2) ? x1 : x2;
	vertice[1][1] = (y1 > y2) ? y1 : y2;

	return(1);
}

int inner(float ** vertice, float *coord)
{
	if((coord[0]>vertice[0][0]) &&
		(coord[0]<vertice[1][0]) &&
		(coord[1]>vertice[0][1]) &&
		(coord[1]<vertice[1][1]) )
	{
		return(1);
	}
	return(0);
}

int inner_neuron(int num_neuron, struct neuron ** neuron_array, float **vertice, 
						int *inner_elem)
{
	int k;
	float *coord;
	
	if ( !(coord = (float *)calloc(2,sizeof(float)) ))
	{
		return(-1);
	}

	for (k=num_neuron-1;k+1;k--)
	{
		coord[0]=neuron_array[k]->x_c;
		coord[1]=neuron_array[k]->y_c;
		
		inner_elem[k]=inner(vertice,coord);
	}
	return(1);	
}

/* near upper = 4 */
/* near bottom = 2 */
/* near upper & near bottom = 8 */

int near_neuron(int num_neuron, struct neuron **neuron_array, int * inner_elem)
{
	int k;
	float min=1.0;
	float max=0.0;
	float x_c;
	
	for (k=0; k<num_neuron; k++)
	{
		if(*(inner_elem+k) )
		{
			x_c=neuron_array[k]->x_c;
			max = (x_c > max) ? x_c : max;
			min = (x_c < min) ? x_c : min;
		}
	}

/* Tolerance 1% */

	max -= 0.01*max;
	min += 0.01*min;

	for (k=0; k<num_neuron; k++)			
	{
		if(*(inner_elem+k) )
		{
			x_c=neuron_array[k]->x_c;
			*(inner_elem+k) = ( (max < x_c) && (min > x_c) ) ? 8 
												: (max < x_c) ? 4 : (min > x_c) ? 2 : 1;
		}				
	}
	return(1);
}


/* remove connections comming between inner an outer regions */
int isolate_region(int num_neuron, struct neuron **neuron_array, int * inner_elem)
{
	int k,l,m;
	int num_con;
	int counter;
	int diff;
	float temp1;
	double temp2;

	int *pathfinder;
	int *age;
	float *con_x;
	float *con_y;
	double *con_w;
	double *delta_con_w;
	
	char char_temp[BUFFSIZE];
	
	if ( !(con_x = (float *)malloc(sizeof(float)) ))
	{
		return(-20);
	}
	if ( !(con_y = (float *)malloc(sizeof(float)) ))
	{
		return(-21);
	}
	if ( !(con_w = (double *)malloc(sizeof(double)) ))
	{
		return(-22);
	}
	if ( !(age = (int *)malloc(sizeof(int)) ))
	{
		return(-23);
	}

	if ( !(delta_con_w = (double *)malloc(sizeof(double)) ))
	{
		return(-24);
	}
	
	if ( !(pathfinder = (int *)malloc(sizeof(int)) ))
	{
		return(-24);
	}
	
	for (k=0; k < num_neuron; k++)
	{
		num_con=neuron_array[k]->num_con;

		if (num_con)
		{
			if ( !(pathfinder = (int *)realloc(pathfinder,num_con*sizeof(int)) ))
			{
				syslog(LOG_CRIT,"Realloc pathfinder fail %d",k);
				return(-31);
			}
			bzero(pathfinder,num_con*sizeof(int));
		}

		if ( !( *(inner_elem+k) ) ) //outter element
		{
			for (l=0; l < num_con; l++)
			{
				for (m=0; m < num_neuron; m++)
				{
					if ( 	( *(inner_elem+m) ) &&
								(neuron_array[m]->x_c == *(neuron_array[k]->con_x+l)) &&
								(neuron_array[m]->y_c == *(neuron_array[k]->con_y+l)) )
					{
//						counter -= 1;
						pathfinder[l] = 1;
						break;
					} 
				}
			}
		}
		else //inner element
		{
			for (l=0; l < num_con; l++)
			{
				for (m=0; m < num_neuron; m++)
				{
					if ( 	( !(*(inner_elem+m)) ) &&
								(neuron_array[m]->x_c == *(neuron_array[k]->con_x+l)) &&
								(neuron_array[m]->y_c == *(neuron_array[k]->con_y+l)) )
					{
//						counter-= 1;
						pathfinder[l] = 1;
						break;
					} 
				}
			}
		}

		counter=num_con;			//required for memory bug
		for (l=0; l<num_con; l++)
		{
			counter -= pathfinder[l];
		}

		diff=num_con-counter;

//Temporary record 
//num_con > 0 => hidden/output layer
//diff > 0  && counter > 0 => number of connections changed but != 0
		if ( (num_con) && (diff) && (counter) ) 
		{
			neuron_array[k]->num_con = counter;
			
			if ( !(con_x = (float *)realloc(con_x,counter*sizeof(float)) ))
			{
				return(-40);
			}
			if ( !(con_y = (float *)realloc(con_y,counter*sizeof(float)) ))
			{
				return(-41);
			}
			if ( !(con_w = (double *)realloc(con_w,counter*sizeof(double)) ))
			{
				return(-42);
			}
			if ( !(age = (int *)realloc(age,counter*sizeof(int)) ))
			{
				return(-43);
			}
			
			if (neuron_array[k]->momentum == 1)
			{
				if ( !(delta_con_w = (double *)realloc(delta_con_w,counter*sizeof(double)) ))
				{
					return(-44);
				}
			}
//			syslog(LOG_INFO,"Realloc of buffer passed");

			l=0;
			
			for (m=0; m < num_con; m++)
			{
				if (!pathfinder[m])
				{
					*(con_x+l)=*(neuron_array[k]->con_x+m);
					*(con_y+l)=*(neuron_array[k]->con_y+m);
					*(con_w+l)=*(neuron_array[k]->con_w+m);
					*(age + l)=*(neuron_array[k]->age + m);
					
					if (neuron_array[k]->momentum == 1)
					{
						*(delta_con_w+l)=*(neuron_array[k]->delta_con_w+m);
					}
//					syslog(LOG_INFO,"neuron=%d l=%d counter=%d",k,l,counter);
					l++;
				}
			}
// Resizing connections 
/************************** Passed ************************/					
//			syslog(LOG_INFO,"Realloc neuron buffers %d",k);
			
			if ( !(neuron_array[k]->con_x = (float *)realloc
						(neuron_array[k]->con_x,counter*sizeof(float)) ))
			{
				return(-50);
			}
			if ( !(neuron_array[k]->con_y = (float *)realloc
						(neuron_array[k]->con_y,counter*sizeof(float)) ))
			{
				return(-51);
			}
			if ( !(neuron_array[k]->con_w = (double *)realloc
						(neuron_array[k]->con_w,counter*sizeof(double)) ))
			{
				return(-52);
			}
			if ( !(neuron_array[k]->age = (int *)realloc
						(neuron_array[k]->age,counter*sizeof(int)) ))
			{
				return(-53);
			}

			if (neuron_array[k]->momentum == 1)
			{
				if ( !(neuron_array[k]->delta_con_w = (double *)realloc
							(neuron_array[k]->delta_con_w,counter*sizeof(double)) ))
				{
					return(-54);
				}
			}
			
//			syslog(LOG_INFO,"Realloc neuron buffers completed");
			
// Restoring values 
			for (l=0; l<counter; l++)
			{
				*(neuron_array[k]->con_x+l)=con_x[l];
				*(neuron_array[k]->con_y+l)=con_y[l];
				*(neuron_array[k]->con_w+l)=con_w[l];
				*(neuron_array[k]->age + l)=age[l];
				if (neuron_array[k]->momentum == 1)
				{
					*(neuron_array[k]->delta_con_w+l)=delta_con_w[l];
				}
			}
//			syslog(LOG_INFO,"neuron=%d counter=%d num_neuron=%d num_con=%d",
//							k,counter,num_neuron,num_con);
		}
		else if ( (num_con) && (!counter) ) //no connections remain
		{
			neuron_array[k]->num_con = 0;
			free(neuron_array[k]->con_x);
			free(neuron_array[k]->con_y);
			free(neuron_array[k]->con_w);
			free(neuron_array[k]->age);
			free(neuron_array[k]->delta_con_w);
			
			neuron_array[k]->con_x = NULL;
			neuron_array[k]->con_y = NULL;
			neuron_array[k]->con_w = NULL;
			neuron_array[k]->age = NULL;
			neuron_array[k]->delta_con_w = NULL;
		}
	}
	free(con_x);
	free(con_y);
	free(con_w);
	free(age);
	free(delta_con_w);
	free(pathfinder);
	
	return(1);
}

void * remove_neuron(int num_neuron, struct neuron **neuron_array, 
											int * inner_elem, int * new_num_neuron)
{
	int k,l;
	int counter;
	int num_con;
	struct neuron ** temp_array;
	
	counter=num_neuron;
	for (k=0; k<num_neuron; k++)
	{
		if (inner_elem[k])
		{
			counter--;
		}
	}
	
//	syslog(LOG_INFO,"num_neuron=%d remainnig_neuron=%d",num_neuron, counter);
	
	if ( !(temp_array = (struct neuron **)malloc(counter*sizeof(struct neuron *)) ))
	{
		return(NULL);
	}
	for (k=0; k< counter; k++)
	{
		if ( !(temp_array[k] = (struct neuron *)malloc(sizeof(struct neuron)) ))
		{
			return(NULL);
		}
	}

//	syslog(LOG_INFO,"malloc passed counter=%d",counter);
	
	l=0;
	for (k=0; k< num_neuron; k++)
	{
		if (!inner_elem[k])
		{
			if ( (num_con = neuron_array[k]->num_con) )
			{
	//			syslog(LOG_INFO,"elem=%d num_con=%d l=%d",k,num_con,l);
				if( !(temp_array[l]->con_x = (float *)malloc(num_con*sizeof(float)) ))
				{
					syslog(LOG_CRIT,"Error malloc con_x");
					return(NULL);
				}
				if( !(temp_array[l]->con_y = (float *)malloc(num_con*sizeof(float)) ))
				{
					syslog(LOG_CRIT,"Error malloc con_y");
					return(NULL);
				}
				if( !(temp_array[l]->con_w = (double *)malloc(num_con*sizeof(double)) ))
				{
					syslog(LOG_CRIT,"Error malloc con_w");
					return(NULL);
				}
				if( !(temp_array[l]->age = (int *)malloc(num_con*sizeof(int)) ))
				{
					syslog(LOG_CRIT,"Error malloc age");
					return(NULL);
				}

				if (neuron_array[k]->momentum == 1)
				{
					if( !(temp_array[l]->delta_con_w = (double *)malloc(num_con*sizeof(double)) ))
					{
						syslog(LOG_CRIT,"Error malloc delta_con_w");
						return(NULL);
					}
				}
			}
			else
			{
	//			syslog(LOG_INFO,"elem=%d l=%d",k,l);
				temp_array[l]->con_x=NULL;
				temp_array[l]->con_y=NULL;
				temp_array[l]->con_w=NULL;
				temp_array[l]->age=NULL;
				temp_array[l]->delta_con_w=NULL;
			}
			l++;
		}
	}

//	syslog(LOG_INFO,"malloc con passed");

	/* Copy in temporal buffer */

	l=0;	
	for (k=0; k< num_neuron; k++)
	{
		if (!inner_elem[k])
		{
			copy_neuron(neuron_array[k],temp_array[l]);
			l++;
		}
	}
	
	neuron_array = (struct neuron **)free_neuron_array(num_neuron,neuron_array);
	
//	syslog(LOG_INFO,"l=%d counter=%d",l,counter);
	
	if (!(neuron_array=(struct neuron **)copy_neuron_array(counter, temp_array, neuron_array) ))
	{
		syslog(LOG_CRIT,"Error in copy_neuron_array");
		return(NULL);
	}
	temp_array = (struct neuron **)free_neuron_array(counter,temp_array);
	*new_num_neuron=counter;

	return(neuron_array);
}

/** Append over parent1 **/
void * append_neuron(int num_neuron1, int num_neuron2, struct neuron ** parent1, 
										struct neuron ** parent2, int * inner_elem2, int * new_num_neuron)
{
	int k,l,m;
	int counter;
	int num_neuron;
	int * inner_elem;
	int * age;
	
	float range;
	float dist;
	
	float * con_x;
	float * con_y;
	
	double * con_w;
	double * delta_con_w;
	
	struct neuron ** temp_neuron;
	
	counter=0; //number of elements to append
	for (k=0; k < num_neuron2; k++)
	{
		if (inner_elem2[k])
		{
			counter++;
		}
	} 
	
	//syslog(LOG_INFO,"Number of elements to append = %d",counter);
	
	//Just in case realloc fails
	temp_neuron = NULL;
	if (counter)
	{
		num_neuron = (num_neuron1 + counter);
		
		if( !(temp_neuron = (struct neuron **)copy_neuron_array(num_neuron1,
										parent1, temp_neuron)) )
		{
			syslog(LOG_CRIT,"Error in copy parent1 to temp_neuron");
			return(NULL);
		}
		if ( (parent1 = (struct neuron **)free_neuron_array(num_neuron1,parent1) ))
		{
			syslog(LOG_CRIT,"Error in free_neuron_array parent1",k);
			return(NULL);
		}

//		syslog(LOG_INFO,"Resizing parent1 num_neuron1=%d num_neuron=%d",num_neuron1,num_neuron);
		/** Resize of parent1 **/
		if (!(parent1 = (struct neuron **)calloc(num_neuron,sizeof(struct neuron *)) ))
		{
			syslog(LOG_CRIT,"Error calloc parent1 in append_neuron()");
			return(NULL);
		}
		for (k=0; k< num_neuron; k++)
		{
			if(!(parent1[k] = (struct neuron *)calloc(1,sizeof(struct neuron)) ))
			{
				syslog(LOG_CRIT,"Error calloc parent1[%d] in append_neuron()",k);
				return(NULL);
			}
		}
		
		for (k=0; k<num_neuron1; k++)
		{
			if (temp_neuron[k]->num_con)
			{
				if (!(parent1[k]->con_x = (float *)malloc(temp_neuron[k]->num_con*sizeof(float)) ))
				{
					syslog(LOG_CRIT,"Error malloc parent1[%d]->con_x in append_neuron()",k);
					return(NULL);
				}
				if (!(parent1[k]->con_y = (float *)malloc(temp_neuron[k]->num_con*sizeof(float)) ))
				{
					syslog(LOG_CRIT,"Error malloc parent1[%d]->con_y in append_neuron()",k);
					return(NULL);
				}
				if (!(parent1[k]->con_w = (double *)malloc(temp_neuron[k]->num_con*sizeof(double)) ))
				{
					syslog(LOG_CRIT,"Error malloc parent1[%d]->con_w in append_neuron()",k);
					return(NULL);
				}
				if (!(parent1[k]->age = (int *)malloc(temp_neuron[k]->num_con*sizeof(int)) ))
				{
					syslog(LOG_CRIT,"Error malloc parent1[%d]->age in append_neuron()",k);
					return(NULL);
				}

				if (temp_neuron[k]->momentum == 1)
				{
					if (!(parent1[k]->delta_con_w = (double *)malloc
																					(temp_neuron[k]->num_con*sizeof(double)) ))
					{
						syslog(LOG_CRIT,"Error malloc parent1[%d]->delta_con_w in append_neuron()",k);
						return(NULL);
					}
				}
			}
			else
			{
				parent1[k]->con_x=NULL;
				parent1[k]->con_y=NULL;
				parent1[k]->con_w=NULL;
				parent1[k]->age=NULL;
				parent1[k]->delta_con_w=NULL;
			}
		}
		
		l=num_neuron1;
		for (k=0; k< num_neuron2; k++)
		{
			if (inner_elem2[k])
			{
				if (parent2[k]->num_con)
				{
//					syslog(LOG_INFO,"num_con[%d]=%d",l,parent2[k]->num_con);
					if (!(parent1[l]->con_x = (float *)malloc(parent2[k]->num_con*sizeof(float)) ))
					{
						syslog(LOG_CRIT,"Error malloc parent1[%d]->con_x in append_neuron()",l);
						return(NULL);
					}
					if (!(parent1[l]->con_y = (float *)malloc(parent2[k]->num_con*sizeof(float)) ))
					{
						syslog(LOG_CRIT,"Error malloc parent1[%d]->con_y in append_neuron()",l);
						return(NULL);
					}
					if (!(parent1[l]->con_w = (double *)malloc(parent2[k]->num_con*sizeof(double)) ))
					{
						syslog(LOG_CRIT,"Error malloc parent1[%d]->con_w in append_neuron()",l);
						return(NULL);
					}
					if (!(parent1[l]->age = (int *)malloc(parent2[k]->num_con*sizeof(int)) ))
					{
						syslog(LOG_CRIT,"Error malloc parent1[%d]->age in append_neuron()",l);
						return(NULL);
					}

					if (parent2[k]->momentum == 1)
					{
						if (!(parent1[l]->delta_con_w = (double *)malloc
																					(parent2[k]->num_con*sizeof(double)) ))
						{
							syslog(LOG_CRIT,"Error malloc parent1[%d]->delta_con_w in append_neuron()",l);
							return(NULL);
						}
					}
				}
				else
				{
					parent1[l]->con_x=NULL;
					parent1[l]->con_y=NULL;
					parent1[l]->con_w=NULL;
					parent1[l]->age=NULL;
					parent1[l]->delta_con_w=NULL;
				}
				l++;	
			}
		}
		
/** Copy from temp buffer to parent1 **/
		for (k=0; k< num_neuron1; k++)
		{
			copy_neuron(temp_neuron[k], parent1[k]);
		}

/** Append extra neurons **/		
		if (!( inner_elem = (int *)calloc(num_neuron,sizeof(int)) ))
		{
			syslog(LOG_CRIT,"Error calloc inner_elem in append_neuron");
			return(NULL);
		}

		l=num_neuron1;
		for (k=0; k< num_neuron2; k++)
		{
			if (inner_elem2[k])
			{
				copy_neuron(parent2[k], parent1[l]);
				inner_elem[l] = inner_elem2[k];
				l++;
			}
		}
		
		
/** Make connections **/
/* range with 1% of tolerance */
/** out - in connections **/
		for (k=0; k< num_neuron1; k++)
		{ 
			for (l=num_neuron1; l<num_neuron; l++)
			{
				if (parent1[k]->x_c > parent1[l]->x_c)
				{
					dist = parent1[k]->x_c - parent1[l]->x_c;
					if ( (inner_elem[l] == 1) || (inner_elem[l] == 2) )
					{
						range = (parent1[k]->range > parent1[l]->range) ? 
											parent1[l]->range : parent1[k]->range;
					}
					else if ( (inner_elem[l] == 4) || (inner_elem[l] == 8) )
					{
						range = (parent1[k]->range > parent1[l]->range) ? 
											parent1[k]->range : parent1[l]->range;
					}
					range += range*0.01;
					if (range > dist)
					{
						parent1[k]->num_con++;
						if ( parent1[k]->con_x == NULL)  //con_x
						{
							if ( !(parent1[k]->con_x = malloc(sizeof(float)) ))
							{
								syslog(LOG_CRIT,"Error malloc parent1[%d]->con_x",k);
								return(NULL);
							}
							if ( !(parent1[k]->con_y = malloc(sizeof(float)) ))
							{
								syslog(LOG_CRIT,"Error malloc parent1[%d]->con_y",k);
								return(NULL);
							}
							if ( !(parent1[k]->con_w = malloc(sizeof(double)) ))
							{
								syslog(LOG_CRIT,"Error malloc parent1[%d]->con_w",k);
								return(NULL);
							}
							if ( !(parent1[k]->age = malloc(sizeof(int)) ))
							{
								syslog(LOG_CRIT,"Error malloc parent1[%d]->age",k);
								return(NULL);
							}

							if (parent1[k]->momentum == 1);
							{
								if ( !(parent1[k]->delta_con_w = malloc(sizeof(double)) ))
								{
									syslog(LOG_CRIT,"Error malloc parent1[%d]->delta_con_w",k);
									return(NULL);
								}
							}
						}
						else 
						{
							if ( !(parent1[k]->con_x = realloc(parent1[k]->con_x,
									parent1[k]->num_con*sizeof(float)) ))
							{
								syslog(LOG_CRIT,"Error realloc parent1[%d]->con_x",k);
								return(NULL);
							}
							if ( !(parent1[k]->con_y = realloc(parent1[k]->con_y,
										parent1[k]->num_con*sizeof(float)) ))
							{
								syslog(LOG_CRIT,"Error realloc parent1[%d]->con_y",k);
								return(NULL);
							}
							if ( !(parent1[k]->con_w = realloc(parent1[k]->con_w,
									parent1[k]->num_con*sizeof(double)) ))
							{
								syslog(LOG_CRIT,"Error realloc parent1[%d]->con_w",k);
								return(NULL);
							}
							if ( !(parent1[k]->age = realloc(parent1[k]->age,
									parent1[k]->num_con*sizeof(int)) ))
							{
								syslog(LOG_CRIT,"Error realloc parent1[%d]->age",k);
								return(NULL);
							}

							if ( parent1[k]->momentum == 1)		//delta_con_w;
							{
								if ( !(parent1[k]->delta_con_w = realloc(parent1[k]->delta_con_w,
										parent1[k]->num_con*sizeof(double)) ))
								{
									syslog(LOG_CRIT,"Error realloc parent1[%d]->delta_con_w",k);
									return(NULL);
								}
							}
						}
						*(parent1[k]->con_x + parent1[k]->num_con - 1) = parent1[l]->x_c;
						*(parent1[k]->con_y + parent1[k]->num_con - 1) = parent1[l]->y_c;
						*(parent1[k]->con_w + parent1[k]->num_con - 1) = rand_gen(l);
						*(parent1[k]->age + parent1[k]->num_con - 1) = 0;
						if (parent1[k]->momentum == 1)
						{
							*(parent1[k]->delta_con_w + parent1[k]->num_con - 1) = 0;
						}
					}
				}
			}
		}
		
		/** in - out connections **/
		for (k=num_neuron1; k< num_neuron; k++)
		{ 
			for (l=0; l<num_neuron1; l++)
			{
				if (parent1[k]->x_c > parent1[l]->x_c)
				{
					dist = parent1[k]->x_c - parent1[l]->x_c;
					if ( (inner_elem[l] == 1) || (inner_elem[l] == 4) )
					{
						range = (parent1[k]->range > parent1[l]->range) ? 
											parent1[l]->range : parent1[k]->range;
					}
					else if ( (inner_elem[l] == 2) || (inner_elem[l] == 8) )
					{
						range = (parent1[k]->range > parent1[l]->range) ? 
											parent1[k]->range : parent1[l]->range;
						parent1[k]->range = range;
					}
					range += range*0.01;
					if (range > dist)
					{
						parent1[k]->num_con++;
						if ( parent1[k]->con_x == NULL)  //con_x
						{
							if ( !(parent1[k]->con_x = malloc(sizeof(float)) ))
							{
								syslog(LOG_CRIT,"Error malloc parent1[%d]->con_x",k);
								return(NULL);
							}
							if ( !(parent1[k]->con_y = malloc(sizeof(float)) ))
							{
								syslog(LOG_CRIT,"Error malloc parent1[%d]->con_y",k);
								return(NULL);
							}
							if ( !(parent1[k]->con_w = malloc(sizeof(double)) ))
							{
								syslog(LOG_CRIT,"Error malloc parent1[%d]->con_w",k);
								return(NULL);
							}
							if ( !(parent1[k]->age = malloc(sizeof(int)) ))
							{
								syslog(LOG_CRIT,"Error malloc parent1[%d]->age",k);
								return(NULL);
							}

							if (parent1[k]->momentum == 1);
							{
								if ( !(parent1[k]->delta_con_w = malloc(sizeof(double)) ))
								{
									syslog(LOG_CRIT,"Error malloc parent1[%d]->delta_con_w",k);
									return(NULL);
								}
							}
						}
						else 
						{
							if ( !(parent1[k]->con_x = realloc(parent1[k]->con_x,
									parent1[k]->num_con*sizeof(float)) ))
							{
								syslog(LOG_CRIT,"Error realloc parent1[%d]->con_x",k);
								return(NULL);
							}
							if ( !(parent1[k]->con_y = realloc(parent1[k]->con_y,
										parent1[k]->num_con*sizeof(float)) ))
							{
								syslog(LOG_CRIT,"Error realloc parent1[%d]->con_y",k);
								return(NULL);
							}
							if ( !(parent1[k]->con_w = realloc(parent1[k]->con_w,
									parent1[k]->num_con*sizeof(double)) ))
							{
								syslog(LOG_CRIT,"Error realloc parent1[%d]->con_w",k);
								return(NULL);
							}
							if ( !(parent1[k]->age = realloc(parent1[k]->age,
									parent1[k]->num_con*sizeof(int)) ))
							{
								syslog(LOG_CRIT,"Error realloc parent1[%d]->age",k);
								return(NULL);
							}
							if ( parent1[k]->momentum == 1)		//delta_con_w;
							{
								if ( !(parent1[k]->delta_con_w = realloc(parent1[k]->delta_con_w,
										parent1[k]->num_con*sizeof(double)) ))
								{
									syslog(LOG_CRIT,"Error realloc parent1[%d]->delta_con_w",k);
									return(NULL);
								}
							}
						}
						*(parent1[k]->con_x + parent1[k]->num_con - 1) = parent1[l]->x_c;
						*(parent1[k]->con_y + parent1[k]->num_con - 1) = parent1[l]->y_c;
						*(parent1[k]->con_w + parent1[k]->num_con - 1) = rand_gen(l);
						*(parent1[k]->age + parent1[k]->num_con - 1) = 0;
						if (parent1[k]->momentum == 1)
						{
							*(parent1[k]->delta_con_w + parent1[k]->num_con - 1) = 0;
						}
					}
				}
			}
		}
		*(new_num_neuron) = num_neuron;
		sort_neuron_array(num_neuron, parent1);
	}
	else
	{
		*(new_num_neuron) = num_neuron1;
	}
	
	for (k=0; k< *new_num_neuron; k++)
	{
		sort_neuron_connections(parent1[k]);
	}
	
	return(parent1);
}

void * mutate_neuron(struct neuron * neuron_unit, struct ga_server_config * mut)
{
	float * fitness;
	float * con_x;
	float * con_y;
	
	double * con_w;
	double * delta_con_w;
	
	int * age;
	
	double temp;
	
	int result;
	int k,l,m;
	int size;

	size=7;

	if( !(fitness = malloc(size*sizeof(float)) ))
	{
		syslog(LOG_CRIT,"Error malloc fitness in mutate_neuron()");
		return(NULL);
	}
	
	fitness[0] = (neuron_unit->momentum > 0) ? mut->prob_alpha : 0.0 ;
	fitness[1] = mut->prob_conv_rate;
	fitness[2] = mut->prob_bias_corr;
	fitness[3] = mut->prob_delta_type;
	fitness[4] = mut->prob_momentum;
	fitness[5] = (neuron_unit->num_con > 0) ? mut->prob_num_con : 0.0 ;
	fitness[6] = mut->prob_bias;
	
	sprintf(char_buffer,"Probability: %f %f %f %f %f %f %f",fitness[0],fitness[1],
													fitness[2],fitness[3],fitness[4],fitness[5],fitness[6]);
	syslog(LOG_INFO,char_buffer);
	
	result = roulette(size,fitness);
	
	switch (result)
	{
		case 0:
		{
			if (neuron_unit->alpha > 0.0)
			{
				temp = pow(100,-(rand_gen(neuron_unit->num_con)));
				temp = (coin_toss(neuron_unit->num_con + 1) == 1) ? temp : -temp;
				temp *= neuron_unit->alpha;
			}
			else
			{
				rand_gen(neuron_unit->num_con);
			}
			syslog(LOG_INFO,"Current alpha = %3.9f",neuron_unit->alpha);
			neuron_unit->alpha += temp;
			syslog(LOG_INFO,"New alpha = %3.9f",neuron_unit->alpha);
			break;
		}
		case 1:
		{
			if (neuron_unit->conv_rate > 0.0)
			{
				temp = pow(100,-(rand_gen(neuron_unit->num_con + 2)));
				temp = (coin_toss(neuron_unit->num_con + 3) == 1) ? temp : -temp;
				temp *= neuron_unit->conv_rate;
			}
			else
			{
				temp = rand_gen(neuron_unit->num_con + 2);
			}
			syslog(LOG_INFO,"Current conv_rate = %3.9f",neuron_unit->conv_rate);
			neuron_unit->conv_rate += temp;
			syslog(LOG_INFO,"New conv_rate = %3.9f",neuron_unit->conv_rate);
			break;
		}
		case 2:
		{
			neuron_unit->bias_corr = (neuron_unit->bias_corr == 1) ? 0 : 1;
			syslog(LOG_INFO,"New bias_corr = %d",neuron_unit->bias_corr);
			break;
		}
		case 3:
		{
			neuron_unit->delta_type = (neuron_unit->delta_type == 1) ? 0 : 1;
			syslog(LOG_INFO,"New delta_type = %d",neuron_unit->delta_type);
			break;
		}
		case 4:
		{
			if (neuron_unit->momentum == 1)
			{
				neuron_unit->momentum = 0;
				if (neuron_unit->num_con)
				{
					free(neuron_unit->delta_con_w);
				}
				neuron_unit->delta_con_w = NULL;
			}
			else
			{
				neuron_unit->momentum = 1;
				if (neuron_unit->num_con)
				{
					if (!(neuron_unit->delta_con_w = (double *)calloc(
													neuron_unit->num_con,sizeof(float)) ))
					{
						syslog(LOG_CRIT,"Error in calloc delta_con_w in mutate_neuron()");
						return(NULL);
					}
				}
			}
			syslog(LOG_INFO,"New momentum = %d",neuron_unit->momentum);
			break;
		}
		case 5:
		{
			k = dice_toss(neuron_unit->num_con + 4, neuron_unit->num_con);
			if ( coin_toss(neuron_unit->num_con + 5) )
			{
				if (*(neuron_unit->con_w+k) > 0.0)
				{
					temp = pow(100,-(rand_gen(neuron_unit->num_con + 6)));
					temp = (coin_toss(neuron_unit->num_con + 3) == 1) ? temp : -temp;
					temp *= *(neuron_unit->con_w + k);
				}
				else
				{
					temp = rand_gen(neuron_unit->num_con + 6);
				}
				syslog(LOG_INFO,"Current weight[%d]: %3.9f",k,*(neuron_unit->con_w+k));
				*(neuron_unit->con_w + k) += temp;
				syslog(LOG_INFO,"New weight[%d]: %3.9f",k,*(neuron_unit->con_w+k));
				break;
			}

			syslog(LOG_INFO,"Erasing connection num_con=%d connection=%d",neuron_unit->num_con,k);
			neuron_unit->num_con -= 1;
			
			if (neuron_unit->num_con)
			{
				if (!(con_x = (float *)calloc(neuron_unit->num_con,sizeof(float)) ))
				{
					syslog(LOG_CRIT,"Error calloc con_x in mutate_neuron()");
					return(NULL);
				}
				if (!(con_y = (float *)calloc(neuron_unit->num_con,sizeof(float)) ))
				{
					syslog(LOG_CRIT,"Error calloc con_y in mutate_neuron()");
					return(NULL);
				}
				if (!(con_w = (double *)calloc(neuron_unit->num_con,sizeof(double)) ))
				{
					syslog(LOG_CRIT,"Error calloc con_w in mutate_neuron()");
					return(NULL);
				}
				if (!(age = (int *)calloc(neuron_unit->num_con,sizeof(int)) ))
				{
					syslog(LOG_CRIT,"Error calloc age in mutate_neuron()");
					return(NULL);
				}

				if (neuron_unit->momentum == 1)
				{
					if (!(delta_con_w = (double *)calloc(neuron_unit->num_con,sizeof(double)) ))
					{
						syslog(LOG_CRIT,"Error calloc delta_con_w in mutate_neuron()");
						return(NULL);
					}
				}
				
				m=0;
				for (l=0; l< neuron_unit->num_con + 1; l++)
				{
					if (k != l)
					{
						*(con_x+m) = *(neuron_unit->con_x+l);
						*(con_y+m) = *(neuron_unit->con_y+l);
						*(con_w+m) = *(neuron_unit->con_w+l);
						*(age + m) = *(neuron_unit->age + l);
						if (neuron_unit->momentum == 1)
						{
							*(delta_con_w+m) = *(neuron_unit->delta_con_w+l);
						}
						m++;
					}
				}
				if (!(neuron_unit->con_x = (float *)realloc(neuron_unit->con_x,
																					neuron_unit->num_con*sizeof(float)) ))
				{
					syslog(LOG_CRIT,"Error realloc neuron_unit->con_x in mutate_neuron()");
					return(NULL);
				}			
				if (!(neuron_unit->con_y = (float *)realloc(neuron_unit->con_y,
																					neuron_unit->num_con*sizeof(float)) ))
				{
					syslog(LOG_CRIT,"Error realloc neuron_unit->con_y in mutate_neuron()");
					return(NULL);
				}			
				if (!(neuron_unit->con_w = (double *)realloc(neuron_unit->con_w,
																				neuron_unit->num_con*sizeof(double)) ))
				{
					syslog(LOG_CRIT,"Error realloc neuron_unit->con_w in mutate_neuron()");
					return(NULL);
				}			
				if (!(neuron_unit->age = (int *)realloc(neuron_unit->age,
																				neuron_unit->num_con*sizeof(int)) ))
				{
					syslog(LOG_CRIT,"Error realloc neuron_unit->age in mutate_neuron()");
					return(NULL);
				}			

				if (neuron_unit->momentum == 1)
				{
					if (!(neuron_unit->delta_con_w = (double *)realloc(neuron_unit->delta_con_w,
																								neuron_unit->num_con*sizeof(double)) ))
					{
						syslog(LOG_CRIT,"Error realloc neuron_unit->delta_con_w in mutate_neuron()");
						return(NULL);
					}			
				}
				for (l=0; l< neuron_unit->num_con; l++)
				{
					*(neuron_unit->con_x + l) = *(con_x + l);
					*(neuron_unit->con_y + l) = *(con_y + l);
					*(neuron_unit->con_w + l) = *(con_w + l);
					*(neuron_unit->age + l) = *(age + l);
					if (neuron_unit->momentum == 1)
					{
						*(neuron_unit->delta_con_w + l) = *(delta_con_w + l);
					}
				}
			}
			else
			{
				free(neuron_unit->con_x);
				free(neuron_unit->con_y);
				free(neuron_unit->con_w);
				free(neuron_unit->age);
				if (neuron_unit->momentum == 1)
				{
					free(neuron_unit->delta_con_w);
					neuron_unit->delta_con_w=NULL;
				}
				neuron_unit->con_x=NULL;
				neuron_unit->con_y=NULL;
				neuron_unit->con_w=NULL;
				neuron_unit->age=NULL;
			}
			syslog(LOG_INFO,"Connection erased, new num_con=%d",neuron_unit->num_con);
			break; 
		}
		case 6:
		{
			if (neuron_unit->bias > 0.0)
			{
				temp = pow(100,-(rand_gen(neuron_unit->num_con + 7)));
				temp = (coin_toss(neuron_unit->num_con + 1) == 6) ? temp : -temp;
				temp *= neuron_unit->bias;
			}
			else
			{
				temp=rand_gen(rand_gen(neuron_unit->num_con + 7));
			}
			syslog(LOG_INFO,"Current bias = %3.9f",neuron_unit->bias);
			neuron_unit->bias += temp;
			syslog(LOG_INFO,"New bias = %3.9f",neuron_unit->bias);
			break;
		}
	}
	return(neuron_unit);
}

void * mutate_neuron_array(int num_neuron, int num_add_neuron, struct neuron ** neuron_array,
														int * new_num_neuron)
{
	int k,l,m,n;
	float temp1;
	float temp2;

	int * inner_elem;
	float ** coord;
	
	struct neuron ** temp_array;
	
	if ( num_add_neuron == 0 )
	{
//		syslog(LOG_INFO,"No neurons to add/del in mutate_neuron_array");
		return(neuron_array);
	}
	
	m = ( num_add_neuron > 0 ) ? num_add_neuron : num_neuron;
	
	if (!( inner_elem = (int *)calloc(m,sizeof(int)) ))
	{
		syslog(LOG_CRIT,"Error calloc inner_elem in mutate_neuron_array()");
		return(NULL);
	}

	if ( num_add_neuron > 0 )
	{
		if (!( temp_array = (struct neuron **)calloc(m,sizeof(struct neuron *)) ))
		{
			syslog(LOG_CRIT,"Error calloc temp_array in mutate_neuron_array()");
			return(NULL);
		}
		if (!( coord = (float **)calloc(m,sizeof(float *)) ))
		{
			syslog(LOG_CRIT,"Error calloc coord in mutate_neuron_array()");
			return(NULL);
		}
		for (k=0; k< m; k++)
		{
			if (!( temp_array[k] = (struct neuron *)calloc(1,sizeof(struct neuron)) ))
			{
				syslog(LOG_CRIT,"Error calloc temp_array[%d] in mutate_neuron_array()",k);
				return(NULL);
			}
			if (!( coord[k] = (float *)calloc(2,sizeof(float )) ))
			{
				syslog(LOG_CRIT,"Error calloc coord[k] in mutate_neuron_array()",k);
				return(NULL);
			}
		}
		
		coord[0][0]=rand_gen(m);
		coord[0][1]=rand_gen(m+1);
		for (k=0; k< m ; k++)
		{
			while(1)
			{
				n=0;
				temp1=rand_gen(k);
				temp2=rand_gen(k+1);
				for (l=0; l< k; l++)
				{
					if ( (coord[l][0] == temp1) && (coord[l][1] == temp2) )
					{
						n++;
						break;
					}
				}
				if ( !n )
				{
					coord[k][0] = temp1;
					coord[k][1] = temp2;
					break;
				}
			}
		}
		for (k=0; k< m; k++)
		{
			inner_elem[k] = 8;
			
			temp_array[k]->range = 				0.0;
			temp_array[k]->num_con = 			0;
			temp_array[k]->con_x = 				NULL;
			temp_array[k]->con_y = 				NULL;
			temp_array[k]->con_w = 				NULL;
			temp_array[k]->age =							NULL;
			temp_array[k]->delta_con_w = 	NULL;
	
			temp_array[k]->x_c = 					coord[k][0];
			temp_array[k]->y_c =					coord[k][1];
			temp_array[k]->momentum = 		coin_toss(k);
			temp_array[k]->bias_corr = 		coin_toss(k+1);

			temp_array[k]->delta_type = 	dice_toss(k+2,2);
		
			temp_array[k]->alpha =				rand_gen(k+3);
			temp_array[k]->conv_rate = 		rand_gen(k+4);
			temp_array[k]->bias =					rand_gen(k+5);
		}
	
		if ( !(neuron_array = (struct neuron **)append_neuron(num_neuron, num_add_neuron, 
														neuron_array, temp_array, inner_elem, new_num_neuron) ))
		{
			syslog(LOG_CRIT,"Error in append_neuron() in mutate_neuron_array()");
			return(NULL);
		}
	}
	else 
	{
		for (k=0; k < -num_add_neuron; k++)
		{
			m=dice_toss(k, num_neuron);
			if ( (neuron_array[m]->x_c != 0.0) && (neuron_array[m]->x_c != 1.0) )
			{
				inner_elem[m] = 1;
			}
		}
		neuron_array = (struct neuron **)remove_neuron(num_neuron,neuron_array,
																					inner_elem,new_num_neuron);
	}
	return(neuron_array);
}

int read_neuron_array(int num_neuron, struct neuron ** neuron_array,	int fd)
{
	int k,l,m,n,o,p;
	double temp[4];
	char char_temp[BUFFSIZE];

//	syslog(LOG_INFO,"Inside read_neuron_array()");
	for (k=0; k< num_neuron;k ++)
	{
		readn(fd,char_buffer,BUFFSIZE);				//neuron number
		readn(fd,char_buffer,BUFFSIZE);
		neuron_array[k]->alpha=atof(char_buffer+6);		 	//alpha
		readn(fd,char_buffer,BUFFSIZE);
		neuron_array[k]->conv_rate=atof(char_buffer+10);		//conv_rate
		readn(fd,char_buffer,BUFFSIZE);
		neuron_array[k]->bias_corr=atoi(char_buffer+10);		//bias_correction
		readn(fd,char_buffer,BUFFSIZE);
		neuron_array[k]->delta_type=atoi(char_buffer+11);	//delta_type
		readn(fd,char_buffer,BUFFSIZE);
		neuron_array[k]->momentum=atoi(char_buffer+9);		//momentum

//		syslog(LOG_INFO,"neuron_array[%d]->momentum = %d",k,neuron_array[k]->momentum);
				
		readn(fd,char_buffer,BUFFSIZE);
		neuron_array[k]->x_c=atof(char_buffer+4);				//x_c
		readn(fd,char_buffer,BUFFSIZE);
		neuron_array[k]->y_c=atof(char_buffer+4);				//y_c
		readn(fd,char_buffer,BUFFSIZE);
		neuron_array[k]->range=atof(char_buffer+6);			//range
		readn(fd,char_buffer,BUFFSIZE);
		l=atoi(char_buffer+8); 
		neuron_array[k]->num_con=l;								//num_con

		if (l)
		{
			if ( !(neuron_array[k]->con_x = (float *)calloc(l,sizeof(float)) ))
			{
				syslog(LOG_CRIT,"Error calloc neuron_array[%d]->con_x\n",k);
				return(-1);
			}
			if ( !(neuron_array[k]->con_y = (float *)calloc(l,sizeof(float)) ))
			{
				syslog(LOG_CRIT,"Error calloc neuron_array[%d]->con_y\n",k);
				return(-1);
			}
			if( !(neuron_array[k]->con_w = (double *)calloc(l,sizeof(double)) ))
			{
				syslog(LOG_CRIT,"Error calloc neuron_array[%d]->con_w\n",k);
				return(-1);
			}
			if( !(neuron_array[k]->age = (int *)calloc(l,sizeof(int)) ))
			{
				syslog(LOG_CRIT,"Error calloc neuron_array[%d]->age\n",k);
				return(-1);
			}

			if (neuron_array[k]->momentum == 1)
			{
				if ( !(neuron_array[k]->delta_con_w = (double *)calloc(l,sizeof(double)) ))
				{
					syslog(LOG_CRIT,"Error calloc neuron_array[%d]->delta_con_w\n",k);
					return(-1);
				}
			}
		}
		else		
		{
			neuron_array[k]->con_x = NULL;
			neuron_array[k]->con_y = NULL;
			neuron_array[k]->con_w = NULL;
			neuron_array[k]->age = NULL;
			neuron_array[k]->delta_con_w = NULL;
		}
				
		readn(fd,char_buffer,BUFFSIZE);
		neuron_array[k]->bias=atof(char_buffer+5);			//bias
				
		for (m=0; m<l; m++)
		{
			readn(fd,char_buffer,BUFFSIZE);
			o=0;
			p=0;
			for (n=0;n<BUFFSIZE;n++)
			{
				char_temp[n-o]=char_buffer[n];
				if ( (char_buffer[n] == ':') || (char_buffer[n] == '\0') )
				{
					char_temp[n-o]='\0';
					o=n+1;
					temp[p]=atof(char_temp);
					p++;
					if ((char_buffer[n] == '\0'))
					{
	 					break;
					}
				}
			}
						
			*(neuron_array[k]->con_x+m)=temp[0];
			*(neuron_array[k]->con_y+m)=temp[1];
			*(neuron_array[k]->con_w+m)=temp[2];
			*(neuron_array[k]->age + m)=(int)temp[3];
		}
	}
	return(1);
}


int load_ga_server_config(struct ga_server_config *conf, const char * filename)
{
	FILE * file_pointer;
	if ((file_pointer=fopen(filename,"r")) == NULL)
	{
		return(-1);
	}
	while(!feof(file_pointer))
	{
		fgets(char_buffer,BUFFSIZE,file_pointer);

		if (!strcmp(char_buffer,"poblation\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->poblation=atoi(char_buffer);
			syslog(LOG_INFO,"poblation = %d",conf->poblation);
		}
		else if (!strcmp(char_buffer,"generations\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->generations=atoi(char_buffer);
			syslog(LOG_INFO,"generations = %d",conf->generations);
		}
		else if (!strcmp(char_buffer,"max_neuron_mut\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->max_neuron_mut=atoi(char_buffer);
			syslog(LOG_INFO,"max_neuron_mut = %d",conf->max_neuron_mut);
		}
		else if (!strcmp(char_buffer,"max_num_layer\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->max_num_layer=atoi(char_buffer);
			syslog(LOG_INFO,"max_num_layer = %d",conf->max_num_layer);
		}		
		else if (!strcmp(char_buffer,"max_num_neuron\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->max_num_neuron=atoi(char_buffer);
			syslog(LOG_INFO,"max_num_neuron = %d",conf->max_num_neuron);
		}
		else if (!strcmp(char_buffer,"agregation\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->agr=atoi(char_buffer);
			syslog(LOG_INFO,"agregation = %d",conf->agr);
		}
		else if (!strcmp(char_buffer,"lifespan\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->lifespan=atoi(char_buffer);
			syslog(LOG_INFO,"lifespan = %d",conf->lifespan);
		}
		else if (!strcmp(char_buffer,"mut_new_prob\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->mut_new_prob=atof(char_buffer);
			syslog(LOG_INFO,"mut_new_prob = %f",conf->mut_new_prob);
		}
		else if (!strcmp(char_buffer,"mut_neuron_prob\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->mut_neuron_prob=atof(char_buffer);
			syslog(LOG_INFO,"mut_neuron_prob = %f",conf->mut_neuron_prob);
		}
		else if (!strcmp(char_buffer,"mut_net_prob\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->mut_net_prob=atof(char_buffer);
			syslog(LOG_INFO,"mut_net_prob = %f",conf->mut_net_prob);
		}
		else if (!strcmp(char_buffer,"base\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->base=atof(char_buffer);
			syslog(LOG_INFO,"base = %f",conf->base);
		}
		else if (!strcmp(char_buffer,"boost\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->boost=atof(char_buffer);
			syslog(LOG_INFO,"boost = %f",conf->boost);
		}
		else if (!strcmp(char_buffer,"level\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->level=atof(char_buffer);
			syslog(LOG_INFO,"level = %f",conf->level);
		}
		else if (!strcmp(char_buffer,"prob_alpha\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->prob_alpha=atof(char_buffer);
			syslog(LOG_INFO,"prob_alpha = %f",conf->prob_alpha);
		}		
		else if (!strcmp(char_buffer,"prob_conv_rate\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->prob_conv_rate=atof(char_buffer);
			syslog(LOG_INFO,"prob_conv_rate = %f",conf->prob_conv_rate);
		}		
		else if (!strcmp(char_buffer,"prob_bias_corr\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->prob_bias_corr=atof(char_buffer);
			syslog(LOG_INFO,"prob_bias_corr = %f",conf->prob_bias_corr);
		}		
		else if (!strcmp(char_buffer,"prob_delta_type\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->prob_delta_type=atof(char_buffer);
			syslog(LOG_INFO,"prob_delta_type = %f",conf->prob_delta_type);
		}		
		else if (!strcmp(char_buffer,"prob_momentum\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->prob_momentum=atof(char_buffer);
			syslog(LOG_INFO,"prob_momentum = %f",conf->prob_momentum);
		}		
		else if (!strcmp(char_buffer,"prob_num_con\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->prob_num_con=atof(char_buffer);
			syslog(LOG_INFO,"prob_num_con = %f",conf->prob_num_con);
		}		
		else if (!strcmp(char_buffer,"prob_bias\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->prob_bias=atof(char_buffer);
			syslog(LOG_INFO,"prob_bias = %f",conf->prob_bias);
		}		
	}
	fclose(file_pointer);
	return(1);
}

