/*  ga_client.c */
/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "nn_aux_prot.h"
#include "ga_aux_prot.h"

jmp_buf jump_num;

/* argv[1] = client number */
/* argv[2] = max_num_layer */
/* argv[3] = max_num_neuron */

int main(int argc, char * argv[])
{

if (argc < 5 )
{
	printf("Wrong number of parameters\n");
	return(1);
}

pid_t pid;
int k,l,m,n;
int connfd;
int client_number;
int status;
int max_fd;
int ready_fd;
int max_num_layer;
int max_num_neuron;
int num_neuron;
int generations;
int gen;
int agr;
int exit_flag;

char char_temp[BUFFSIZE];
char ** char_vector;

float error;
float temp;

struct nn_config nn_conf;
struct sockaddr_un cliaddr;
struct neuron ** neuron_array;

fd_set read_set,write_set,ex_set;


exit_flag=0;
client_number=atoi(argv[1]);
max_num_layer=atoi(argv[2]);
max_num_neuron=atoi(argv[3]);
generations=atoi(argv[4]);
if (argc == 6)
{
	agr=atoi(argv[5]);
}
else
{
	agr=0;
}

load_nn_config(&nn_conf, "nn_train_config");

openlog("ga_client",LOG_PID,LOG_LOCAL1);

syslog(LOG_INFO,"client_number=%d max_num_layer=%d max_num_neuron=%d generations=%d agr=%d"
							,client_number,max_num_layer,max_num_neuron,generations,agr);

if (agr == 0)
{
	k=dice_toss(client_number,(max_num_layer - 2));
	k+=3;

	if ( (pid=fork()) <0)
	{
		syslog(LOG_CRIT,"fork error nn_init");
		return(1);
	}
	else if (pid == 0)		//Child -> Child 
	{
		if (!(	char_vector = (char **)malloc((9+k)*sizeof(char *)) ))
		{
			syslog(LOG_CRIT,"malloc error");
			return(1);
		}
		for (l=0; l< (8+k); l++)
		{
			if( !( *(char_vector+l) = (char *)malloc(BUFFSIZE*sizeof(char)) ))
			{
				syslog(LOG_CRIT,"malloc error %d",l);
				return(1);
			}
		}
			
		sprintf(char_vector[0], "./nn_init\0");
		sprintf(char_vector[1],"init%d\0");
		for (l=2; l<8; l++)
		{
			sprintf(char_vector[l],"rr\0");
		}
		sprintf(char_vector[8],"%d\0",nn_conf.num_input);
		for (l=9; l< (k+7); l++)
		{
			while(1)
			{
				m=dice_toss(client_number,max_num_neuron);
				if (m > 1)
				{
					break;
				}
			}
			sprintf(char_vector[l],"%d\0",m);
		}
		sprintf(char_vector[k+7],"%d\0",nn_conf.num_output);
		*(char_vector+8+k) = NULL;
	
		execvp("./nn_init",char_vector);
	}

	if(waitpid(pid,&status,0) < 0)
	{
		syslog(LOG_CRIT,"Wait error nn_init %s",strerror(errno));
		return(1);	
	}
//syslog(LOG_INFO,"nn_init ended");
}
else
{
	if ( (pid=fork()) <0)
	{
		syslog(LOG_CRIT,"fork error nn_init");
		return(1);
	}
	else if (pid == 0)		//Child -> Child 
	{
		if (!(	char_vector = (char **)malloc((11)*sizeof(char *)) ))
		{
			syslog(LOG_CRIT,"malloc error");
			return(1);
		}
		for (l=0; l< 10; l++)
		{
			if( !( *(char_vector+l) = (char *)malloc(BUFFSIZE*sizeof(char)) ))
			{
				syslog(LOG_CRIT,"malloc error %d",l);
				return(1);
			}
		}

		sprintf(char_vector[0],"./nn_agr\0");
		sprintf(char_vector[1],"result%d\0",client_number);
		sprintf(char_vector[2],"init%d\0",client_number);
		for (l=3; l<9; l++)
		{
			sprintf(char_vector[l],"rr\0");
		}
		sprintf(char_vector[9],"%d\0",agr);
		char_vector[10] = NULL;
	
		syslog(LOG_INFO,"char_vecto[9]=%s",char_vector[9]);		
			
		execvp("./nn_agr",char_vector);
	}

	if(waitpid(pid,&status,0) < 0)
	{
		syslog(LOG_CRIT,"Wait error nn_agr %s",strerror(errno));
		return(1);	
	}
}

if ( (connfd = socket(PF_LOCAL, SOCK_STREAM, 0)) < 0)
{
	syslog(LOG_CRIT,"Error creating socket: %d %s",client_number,strerror(errno));
	return(1);
}
			
sprintf(char_buffer,"unix%d.str",client_number);
					
bzero(&cliaddr, sizeof(cliaddr));
cliaddr.sun_family = PF_LOCAL;
strcpy(cliaddr.sun_path,char_buffer);
					
if( (connect(connfd, (struct sockaddr *) &cliaddr, sizeof(cliaddr))) <0)
{
	syslog(LOG_CRIT,"Couldn't connect to parent: %d %s",client_number,strerror(errno));
	return(1);
}

sprintf(char_temp,"fifo%d",client_number); 
unlink(char_temp);

if ( mkfifo(char_temp,FILE_MODE) <0)
{
	syslog(LOG_CRIT,"Error creating fifo: %d %s",client_number,strerror(errno));
	return(1);
}


/****************** LOOP FOR GENERATIONS ****************/
for (gen=0; gen< generations; gen++)
{

//while(1)
//{
	if (	(pid=fork()) <0)
	{	
		syslog(LOG_CRIT,"fork error nn_exec gen=%d",gen);
		return(1);
	}
	else if (pid == 0) //Child -> Child 
	{
		sprintf(char_temp,"result%d",client_number);
		sprintf(char_buffer,"init%d",client_number);
		execlp("./nn_exec","./nn_exec","nn_train_config",char_buffer,char_temp,(char *) 0);
	}

	if (waitpid(pid,&status,0) < 0)
	{
		syslog(LOG_CRIT,"Wait error nn_exec gen=%d status=%d",gen,status);
		return(1);
	}
/*
	if (WIFEXITED(status))
	{
		if ((k=WEXITSTATUS(status)) != 0)	//In case of error WEXITSTATUS > 0
		{
			syslog(LOG_INFO,"Error in nn_exec %d, retrying",k);
		}
		else
		{
			break;
		}
	}
		
}
syslog(LOG_INFO,"nn_exec ended status=%d",k);

*/
if (setjmp(jump_num) != 0)
{

}

if ( (pid = fork()) <0)
{
	syslog(LOG_CRIT,"Error fork() in test mode");
	return(1);
}
else if (pid==0)
{
	sprintf(char_temp,"fifo%d",client_number);
	sprintf(char_buffer,"result%d",client_number); 	//now result from trainning = init
	execlp("./nn_exec","./nn_exec","nn_test_config",char_buffer,char_temp,(char *) 0);
}

if( (m=open(char_temp,O_RDONLY, 0)) <0)
{
	syslog(LOG_CRIT,"Error openning %s: %s",char_temp,strerror(errno));
	return(1);
}
//unlink(char_temp);

if (load_nn_config(&nn_conf, "nn_test_config")< 0)
{
	syslog(LOG_CRIT,"Could open nn_test_config");
	return(1);
}

max_fd = (connfd > m) ? connfd+1 : m+1;
FD_ZERO(&read_set);
FD_ZERO(&write_set);
FD_ZERO(&ex_set);
FD_SET(m,&read_set);

			
//syslog(LOG_INFO,"num_pat %d",nn_conf.num_pat);
k=0;
error = 0;
if ( (ready_fd=pselect(max_fd, &read_set, &write_set, &ex_set, NULL, NULL)) <0 )
{
	syslog(LOG_CRIT,"Error in pselect: %s",strerror(errno));
	return(1);
}
if (FD_ISSET(m, &read_set) )
{
	while(1)
	{
		if( (l=readn(m,char_buffer,BUFFSIZE)) < 0)
		{
			syslog(LOG_CRIT,"Error in read: %s",strerror(errno));
			return(1);
		}
		else if (l == 0)
		{
			syslog(LOG_INFO,"nn_exec in test mode died, retrying");
			close(m);
			longjmp(jump_num,1);
		}
		else if ( !strncmp(char_buffer,"Error",5) )
		{
//			sprintf(char_temp,"num_pat=%d Client=%d Pattern=%d ",nn_conf.num_pat,client_number,k);
			error += atof(char_buffer+6);
//			temp = atof(char_buffer+6);
//			error = (error > temp) ? error : temp;
//			strcat(char_temp,char_buffer);
//			syslog(LOG_INFO,char_temp);
			k++;

		}
		else if ( !strncmp(char_buffer,"neuron_array",12) )
		{
//			syslog(LOG_INFO,"Reading neuron_array: %s",char_buffer);
			writen(connfd,char_buffer,BUFFSIZE);
			while (1)
			{
				if( (l=readn(m,char_buffer,BUFFSIZE)) < 0)
				{
					syslog(LOG_CRIT,"Error in read: %s",strerror(errno));
					return(1);
				}
				else if (l == 0)
				{
					syslog(LOG_INFO,"nn in test mode died, retrying");
					close(m);
					longjmp(jump_num,2);
				}
				if ( strncmp("END",char_buffer,3) )  //Different of END
				{
					writen(connfd,char_buffer,BUFFSIZE);
//					syslog(LOG_INFO,char_buffer);
				}
				else 
				{
					sprintf(char_buffer,"END=%d",client_number);
					writen(connfd,char_buffer,BUFFSIZE);
					close(m);
					if (waitpid(pid,&status,0) < 0)
					{
						syslog(LOG_CRIT,"Wait error nn_exec gen=%d status=%d",gen,status);
						return(1);
					}
					break;
				}
			}
			break;
		}
	}
}

//error /= (float) nn_conf.num_pat;
			
sprintf(char_buffer,"Error=%f client_number=%d",error,client_number);
writen(connfd,char_buffer,BUFFSIZE);

sprintf(char_buffer,"All work done child %d",client_number);
writen(connfd,char_buffer,BUFFSIZE);

//syslog(LOG_INFO,"connfd=%d",connfd);

FD_ZERO(&read_set);
FD_ZERO(&write_set);
FD_ZERO(&ex_set);
FD_SET(connfd,&read_set);

if ( (ready_fd=pselect(max_fd, &read_set, &write_set, &ex_set, NULL, NULL)) <0 )
{
	syslog(LOG_CRIT,"Error in pselect: %s",strerror(errno));
	return(1);
}
if (FD_ISSET(connfd, &read_set) )
{
	while(1)
	{
		if( (readn(connfd,char_buffer,BUFFSIZE)) < 0)
		{
			syslog(LOG_CRIT,"Error in connection %d",client_number);
			return(1);
		}
/** Order **/
/* num neuron */
/* neuron[k] */
/* END */
					
		if ( !(strncmp("neuron_array",char_buffer,12) ) )
		{
			readn(connfd,char_buffer,BUFFSIZE);
			num_neuron = atoi(char_buffer+11);
			syslog(LOG_INFO,"num_neuron = %d",num_neuron);
			if ( !(neuron_array = (struct neuron **)calloc(num_neuron,sizeof(struct neuron *)) ))
			{
				syslog(LOG_CRIT,"Error calloc neuron_array: %s",strerror(errno));
				return(1);
			}
			for (l=0; l< num_neuron; l++)
			{
				if ( !(neuron_array[l] = (struct neuron *)calloc(1,sizeof(struct neuron)) ))
				{
					syslog(LOG_CRIT,"Error calloc neuron_array[%d]: %s",l,strerror(errno));
					return(1);
				}
			}
			read_neuron_array(num_neuron, neuron_array, connfd);
			
			syslog(LOG_INFO,"End of reading client=%d num_neuron=%d",client_number,num_neuron);
			sprintf(char_buffer,"init%d",client_number);
			fwrite_neuron_array(num_neuron, neuron_array, char_buffer);
			if ( (neuron_array = (struct neuron **)free_neuron_array(num_neuron,neuron_array) ))
			{
				syslog(LOG_CRIT,"Error in free_neuron_array client %d",client_number);
				return(1);
			}
		}
		else if (!strncmp("All work done",char_buffer,13) ) //end of iteraction
		{
			syslog(LOG_INFO,char_buffer);
			break;
		}
		else if (!strncmp("Exiting",char_buffer,7) ) //end of client
		{
			syslog(LOG_INFO,"**** Exiting client %d in generation %d ****",client_number,gen);
			exit_flag=1;
			break;
		}
		else if (!strncmp("Randomize",char_buffer,9) )
		{
			syslog(LOG_INFO,"Generating new neuron_array client %d",client_number);
			n=dice_toss(client_number,(max_num_layer - 3));
			n+=3;

			if ( (pid=fork()) <0)
			{
				syslog(LOG_CRIT,"fork error nn_init");
				return(1);
			}
			else if (pid == 0)		//Child -> Child 
			{
				if (!(	char_vector = (char **)malloc((9+k)*sizeof(char *)) ))
				{
					syslog(LOG_CRIT,"malloc error");
					return(1);
				}
				for (l=0; l< (8+n); l++)
				{
					if( !( *(char_vector+l) = (char *)malloc(BUFFSIZE*sizeof(char)) ))
					{
						syslog(LOG_CRIT,"malloc error %d",l);
						return(1);
					}
				}
		
				strcpy( *char_vector, "./nn_init\0");
				sprintf(char_buffer,"init%d\0",client_number);
				strcpy( *(char_vector+1), char_buffer);
				sprintf(char_buffer,"rr\0");
				for (l=2; l<8; l++)
				{
					strcpy(*(char_vector+l),char_buffer);
				}
				sprintf(char_buffer,"%d\0",nn_conf.num_input);
				strcpy(*(char_vector+8),char_buffer);
				for (l=9; l< (n+7); l++)
				{
					while(1)
					{
						m=dice_toss(client_number,max_num_neuron);
						if (m > 1)
						{
							break;
						}
					}
					sprintf(char_buffer,"%d\0",m);
					strcpy(*(char_vector+l),char_buffer);
				}
				sprintf(char_buffer,"%d\0",nn_conf.num_output);
				strcpy(*(char_vector+n+7),char_buffer);
				*(char_vector+8+n) = NULL;
	
				sprintf(char_temp,"%d",5+client_number*5);
	
				execvp("./nn_init",char_vector);
			}
			if(waitpid(pid,&status,0) < 0)
			{
				syslog(LOG_CRIT,"Wait error nn_init %s",strerror(errno));
				return(1);	
			}
		}
	}
}
if (exit_flag)
{
	break;
}

}
/******************** END LOOP GENERATIONS ***************/

sprintf(char_temp,"fifo%d",client_number);
unlink(char_temp);

sprintf(char_temp,"result%d",client_number);
if ( (num_neuron=load_num_neuron(char_temp)) < 1 )
{
	syslog(LOG_CRIT,"Couldn't get number of neurons");
	return(1);
}

if(!( neuron_array=(struct neuron **)calloc(num_neuron,sizeof(struct neuron *)) ))
{
	syslog(LOG_CRIT,"Error calloc neuron_array: %s",strerror(errno));
	return(2);
}
for (k=0; k<num_neuron ;k++)
{
	if(!( neuron_array[k]=(struct neuron *)calloc(1,sizeof(struct neuron)) ))
	{
		syslog(LOG_CRIT,"Error calloc neuron_array[%d]\n: %s",k,strerror(errno));
		return(2);
	}
}

if ((k=load_neuron_array(num_neuron,neuron_array,char_temp)) != 1)
{
	syslog(LOG_CRIT,"Error load_neuron_array() %d %s",k,errno);
	return(2);
}

for (k=0; k< num_neuron; k++)
{
	for (l=0; l< neuron_array[k]->num_con; l++)
	{
		*(neuron_array[k]->age+l) += 1;
	}
} 
fwrite_neuron_array(num_neuron,neuron_array,char_temp);

syslog(LOG_INFO,"**** Exiting client %d ****",client_number);
close(connfd);
exit(0);
}
