/*  nn_agr.c */
/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "nn_aux_prot.h"
#include "ga_aux_prot.h"
#include "gen_aux_prot.h"

/* 
argc =
argv = name old_init new_init alpha conv_rat bias_corr delta_type momentum bias diff_num_output
*/

int main(int argc, char * argv[])
{
int k,l,m,n,o,p;
int old_num_neuron, new_num_neuron, temp_num_neuron;
int old_num_output, new_num_output, diff_num_output;
int in_neuron;
int num_add;
int num_input;
int num_hidden;

float f1,f2,f3;
float x_c,y_c;
	
float alpha;
float conv_rate;
int bias_corr;
int delta_type;
int momentum;
float bias;
int num_con;
float range;

struct neuron ** temp_neuron;
struct neuron ** neuron_array;

if (argc != 10)
{
	printf("Wrong number of arguments\nUsage: %s old_init ",argv[0]);
	printf("new_init alpha conv_rat bias_corr delta_type momentum bias add_num_output\n");
	exit(1);
}

if(!strncmp("r",argv[3],1))
{
	alpha=rand_gen(argc);
}
else if (strncmp("rr",argv[3],2))
{
	alpha=atof(argv[3]);
}
	
if(!strncmp("r",argv[4],1))
{
	conv_rate=rand_gen(argc+1);
}
else if (strncmp("rr",argv[4],2))
{
	conv_rate=atof(argv[4]);
}

if(!strncmp("r",argv[5],1))
{
	bias_corr=coin_toss(argc+2);
}
else if (strncmp("rr",argv[5],2))
{
	bias_corr=atoi(argv[5]);
}
	
if(!strncmp("r",argv[6],1))
{
	delta_type=dice_toss(bias_corr+argc,2);
}
else if (strncmp("rr",argv[6],2))
{
	delta_type=atoi(argv[6]);
}
	
if(!strncmp("r",argv[7],1))
{
	momentum=coin_toss(bias_corr+delta_type+argc);
}
else if (strncmp("rr",argv[7],2))
{
	momentum=atoi(argv[7]);
}
	
if(!strncmp("r",argv[8],1))
{
	bias=rand_gen(delta_type+momentum+bias_corr+argc);
}
else if (strncmp("rr",argv[8],2))
{
	bias=atof(argv[8]);
}


diff_num_output = atoi(argv[9]);

openlog("nn_agr",LOG_PID,LOG_LOCAL3);

if ( (old_num_neuron=load_num_neuron(argv[1])) < 1)
{
	syslog(LOG_CRIT,"Error load_num_neuron() %s",strerror(errno));
	exit(1);
}

if ( !(neuron_array = (struct neuron **)calloc(old_num_neuron,sizeof(struct neuron *)) ))
{
	syslog(LOG_CRIT,"Error calloc neuron_array");
	exit(1);
}
for (k=0; k< old_num_neuron; k++)
{
	if ( !(neuron_array[k] = (struct neuron *)calloc(1,sizeof(struct neuron)) ))
	{
		syslog(LOG_CRIT,"Error calloc neuron_array[%d]",k);
		exit(1);
	}
}

if (load_neuron_array(old_num_neuron, neuron_array,	argv[1]) != 1)
{
	syslog(LOG_CRIT,"Error in load_neuron_array()");
	exit(1);
}


if ( !(temp_neuron = (struct neuron **)calloc(1,sizeof(struct neuron *)) ))
{
	syslog(LOG_CRIT,"Error calloc temp_neuron");
	exit(1);
}
if ( !(*temp_neuron = (struct neuron *)calloc(1,sizeof(struct neuron)) ))
{
	syslog(LOG_CRIT,"Error calloc temp_neuron[0]");
	exit(1);
}

old_num_output=0;
for (k=old_num_neuron-1; k+1; k--)
{
	if (neuron_array[k]->x_c >= 0.999)  //1 mili of tolerance
	{
		old_num_output += 1;
	}
}
num_input=0;
for (k=0; k< old_num_neuron; k++)
{
	if (neuron_array[k]->x_c <= 0.001) // 1 mili of tolerance
	{
		num_input +=1;
	}
}

syslog(LOG_INFO,"old_num_output=%d",old_num_output);

in_neuron=1;
new_num_neuron = old_num_neuron;
new_num_output = old_num_output;
for (k=0; k< diff_num_output; k++)
{
	if (!strncmp("rr",argv[3],2))
	{
		temp_neuron[0]->alpha=rand_gen(k);
	}
	else 
	{
		temp_neuron[0]->alpha=alpha;
	}
			
	if (!strncmp("rr",argv[4],2))
	{
		temp_neuron[0]->conv_rate=rand_gen(k);
	}
	else 
	{
		temp_neuron[0]->conv_rate=conv_rate;
	}

	if (!strncmp("rr",argv[5],2))
	{
		temp_neuron[0]->bias_corr=coin_toss(k);
	}
	else 
	{
		temp_neuron[0]->bias_corr=bias_corr;
	}

	if (!strncmp("rr",argv[6],2))
	{
		temp_neuron[0]->delta_type=dice_toss(k,2);
	}
	else 
	{
		temp_neuron[0]->delta_type=delta_type;
	}

	if (!strncmp("rr",argv[7],2))
	{
		temp_neuron[0]->momentum=coin_toss(k);
	}
	else 
	{
		temp_neuron[0]->momentum=momentum;
	}

	if (!strncmp("rr",argv[8],2))
	{
		temp_neuron[0]->bias=rand_gen(k);
	}
	else 
	{
		temp_neuron[0]->bias=bias;
	}

	temp_neuron[0]->range = neuron_array[new_num_neuron - 1]->range;
	temp_neuron[0]->x_c = 1.0;
	l=dice_toss(new_num_output, new_num_output-1);
	temp_neuron[0]->y_c = (neuron_array[new_num_neuron - new_num_output + l]->y_c +
													neuron_array[new_num_neuron - new_num_output + l+1]->y_c) / 2.0;
	new_num_output += 1;

	if (!(neuron_array =	(struct neuron **)append_neuron(new_num_neuron,1,
											neuron_array,temp_neuron,&in_neuron, &temp_num_neuron ) ))
	{
		syslog(LOG_CRIT,"Error in append_neuron() neuron_array");
		exit(1);
	}	
	new_num_neuron = temp_num_neuron;
}	

syslog(LOG_INFO,"new_num_output=%d",new_num_output);

num_hidden = new_num_neuron - num_input - new_num_output;
f1 = (float)num_hidden;
f1 /= (float)old_num_output;
f1 *= (float)diff_num_output;

k = (int)f1;
num_add = dice_toss(k,k);

syslog(LOG_INFO,"num_add=%d",num_add);

for (k=0; k< num_add; k++)
{
	if (!strncmp("rr",argv[3],2))
	{
		temp_neuron[0]->alpha=rand_gen(k);
	}
	else 
	{
		temp_neuron[0]->alpha=alpha;
	}
			
	if (!strncmp("rr",argv[4],2))
	{
		temp_neuron[0]->conv_rate=rand_gen(k);
	}
	else 
	{
		temp_neuron[0]->conv_rate=conv_rate;
	}

	if (!strncmp("rr",argv[5],2))
	{
		temp_neuron[0]->bias_corr=coin_toss(k);
	}
	else 
	{
		temp_neuron[0]->bias_corr=bias_corr;
	}

	if (!strncmp("rr",argv[6],2))
	{
		temp_neuron[0]->delta_type=dice_toss(k,2);
	}
	else 
	{
		temp_neuron[0]->delta_type=delta_type;
	}

	if (!strncmp("rr",argv[7],2))
	{
		temp_neuron[0]->momentum=coin_toss(k);
	}
	else 
	{
		temp_neuron[0]->momentum=momentum;
	}

	if (!strncmp("rr",argv[8],2))
	{
		temp_neuron[0]->bias=rand_gen(k);
	}
	else 
	{
		temp_neuron[0]->bias=bias;
	}

	l=dice_toss(k,num_hidden);
	f1 = neuron_array[num_input + l]->x_c;
	f3 = neuron_array[num_input + l]->range;
	
	while(1)
	{
		f2 = rand_gen(l);
		for (m=0; m< new_num_neuron; m++)
		{
			if ( (f1 >= (neuron_array[m]->x_c - 0.001)) && (f1 <= (neuron_array[m]->x_c + 0.001)) )
			{
				if ( (f2 >= (neuron_array[m]->y_c - 0.003)) && (f2 <= (neuron_array[m]->y_c + 0.003)) )
				{

					break;
				}
			}
		}
		if (m >= (new_num_neuron-1))
		{
			break;
		}
	}
	temp_neuron[0]->x_c=f1;
	temp_neuron[0]->y_c=f2;
	temp_neuron[0]->range=f3;
	
	if (!(neuron_array =	(struct neuron **)append_neuron(new_num_neuron,1,
											neuron_array,temp_neuron,&in_neuron, &temp_num_neuron ) ))
	{
		syslog(LOG_CRIT,"Error in append_neuron() neuron_array");
		exit(1);
	}	
	new_num_neuron = temp_num_neuron;
	num_hidden += 1;
}

syslog(LOG_INFO,"new_num_neuron=%d",new_num_neuron);

if(	fwrite_neuron_array(new_num_neuron,neuron_array,argv[2])< 0)
{
	syslog(LOG_CRIT,"Error fwrite_neuron_array() %s: %s",argv[2],strerror(errno));
	exit(1);
}
exit(0);
}
