/*  nn_aux_prot.h */
/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

extern double threshold(int threshold_type, float net);
extern float der(int delta_type, float net);
extern int load_input(float *input_buffer, int num_elem_input, const char * filename);
extern int load_output(float *output_buffer, int num_elem_output, const char * filename);
extern int load_nn_config(struct nn_config *conf, const char * filename);
extern int load_num_neuron(const char *filename);
extern int load_neuron_array(int num_neuron, struct neuron ** neuron_array,	const char * filename);
extern int sort_neuron_array(int num_neuron, struct neuron ** neuron_array);
extern int sort_neuron_connections(struct neuron * neuron_unit);
extern int verify_connections(int num_neuron, struct neuron ** neuron_array);
extern int forward_propagation(int num_neuron, struct neuron ** neuron_array, int num_elem_input);
extern float output_layer_error(int num_neuron, struct neuron ** neuron_array,
													int num_elem_output, float *output_buffer);
extern int back_propagation(int num_neuron, struct neuron ** neuron_array, int num_elem_input);
extern int weight_update(int num_neuron, struct neuron ** neuron_array, int num_elem_input);
extern int fwrite_neuron_array(int num_neuron, struct neuron ** neuron_array, 
												const char *filename);
extern int dwrite_neuron_array(int num_neuron, struct neuron ** neuron_array, int file_ptr);
extern int copy_neuron(struct neuron * origin, struct neuron * destiny);
extern void * copy_neuron_array(int num_neuron, struct neuron ** origin, struct neuron ** destiny);
extern void * free_neuron_array(int num_neuron, struct neuron ** neuron_array);
