/*  nn_init_generator.c */
/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "nn_aux_prot.h"
#include "ga_aux_prot.h"
#include "gen_aux_prot.h"


/*argc=variable
argv=name init_file alpha conv_rat bias_corr delta_type momentum bias num1 num2 ...*/

int main(int argc, char * argv[])
{
	FILE * file_ptr;
	int k,l,m;
	int * num_elem_layer;
	int num_neuron=0,num_layer;
	int counter;
	
	float con_x,con_y,con_w;
	
	float alpha;
	float conv_rat;
	int bias_corr;
	int delta_type;
	int momentum;
	float bias;
	
	int num_con;
	float range;
	
	if (argc < 9)
	{
		printf("Too few arguments\nUsage: %s ",argv[0]);
		printf("init_file alpha conv_rat bias_corr delta_type momentum bias num1 ...\n");
		return(1);
	}
	
	openlog("nn_init_gen",LOG_PID,LOG_LOCAL3);
	
	strncpy(char_buffer,argv[1],BUFFSIZE);
	
	if(!strncmp("r",argv[2],1))
	{
		alpha=rand_gen(argc);
	}
	else if (strncmp("rr",argv[2],2))
	{
		alpha=atof(argv[2]);
	}
	
	if(!strncmp("r",argv[3],1))
	{
		conv_rat=rand_gen(argc+1);
	}
	else if (strncmp("rr",argv[3],2))
	{
		conv_rat=atof(argv[3]);
	}

	if(!strncmp("r",argv[4],1))
	{
		bias_corr=coin_toss(argc+2);
	}
	else if (strncmp("rr",argv[4],2))
	{
		bias_corr=atoi(argv[4]);
	}
	
	if(!strncmp("r",argv[5],1))
	{
		delta_type=dice_toss(bias_corr+argc,2);
	}
	else if (strncmp("rr",argv[5],2))
	{
		delta_type=atoi(argv[5]);
	}
	
	if(!strncmp("r",argv[6],1))
	{
		momentum=coin_toss(bias_corr+delta_type+argc);
	}
	else if (strncmp("rr",argv[6],2))
	{
		momentum=atoi(argv[6]);
	}
	
	if(!strncmp("r",argv[7],1))
	{
		bias=rand_gen(delta_type+momentum+bias_corr+argc);
	}
	else if (strncmp("rr",argv[7],2))
	{
		bias=atof(argv[7]);
	}

	num_elem_layer = (int *)calloc(argc-8,sizeof(int));
	
	num_layer=argc-8;
	range=1.0/(num_layer-1);
	
	for(k=8;k<argc;k++)
	{
		*(num_elem_layer+k-8)=atoi(argv[k]);
		num_neuron += *(num_elem_layer+k-8);
	}

	syslog(LOG_INFO,"num_layer: %d num_neuron: %d",num_layer,num_neuron);
	
	unlink(char_buffer);
	file_ptr=fopen(char_buffer,"w");
	sprintf(char_buffer,"neuron_array\n");
	fputs(char_buffer,file_ptr);
	sprintf(char_buffer,"num_neuron=%d\n",num_neuron);
	fputs(char_buffer,file_ptr);

	for (k=0;k<num_elem_layer[0]; k++)
	{
		sprintf(char_buffer,"neuron %d\n",k);
		fputs(char_buffer,file_ptr);
				
		sprintf(char_buffer,"alpha=%f\n",0.0);	
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"conv_rate=%f\n",0.0);	
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"bias_corr=%d\n",0);	
		fputs(char_buffer,file_ptr);
		
		sprintf(char_buffer,"delta_type=%d\n",0);	
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"momentum=%d\n",0);	
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"x_c=%1.15f\n",0.0);	
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"y_c=%1.15f\n",(k+0.5)*(1.0)/( *num_elem_layer ));	
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"range=%1.15f\n",range);	
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"num_con=%d\n",0);	
		fputs(char_buffer,file_ptr);
		
		sprintf(char_buffer,"bias=%f\n",0.0);	
		fputs(char_buffer,file_ptr);
		
		fputc('\n',file_ptr);
	}
	
	counter=k;
	
	for (k=1;k<num_layer;k++)
	{
		for (l=0;l < *(num_elem_layer+k); l++)
		{
			sprintf(char_buffer,"neuron %d\n",counter);
			fputs(char_buffer,file_ptr);
			counter ++;

			if (!strncmp("rr",argv[2],2))
			{
				sprintf(char_buffer,"alpha=%f\n",rand_gen(counter));	
			}
			else 
			{
				sprintf(char_buffer,"alpha=%f\n",alpha);	
			}
			fputs(char_buffer,file_ptr);
			
			if (!strncmp("rr",argv[3],2))
			{
				sprintf(char_buffer,"conv_rate=%f\n",rand_gen(counter+1));	
			}
			else
			{
				sprintf(char_buffer,"conv_rate=%f\n",conv_rat);	
			}
			fputs(char_buffer,file_ptr);

			if (!strncmp("rr",argv[4],2))
			{
				sprintf(char_buffer,"bias_corr=%d\n",coin_toss(counter+2));	
			}
			else
			{
				sprintf(char_buffer,"bias_corr=%d\n",bias_corr);	
			}
			fputs(char_buffer,file_ptr);
		
			if (!strncmp("rr",argv[5],2))
			{
				sprintf(char_buffer,"delta_type=%d\n",dice_toss(counter+3,2));	
			}
			else
			{
				sprintf(char_buffer,"delta_type=%d\n",delta_type);	
			}
			fputs(char_buffer,file_ptr);

			if (!strncmp("rr",argv[6],2))
			{
				sprintf(char_buffer,"momentum=%d\n",coin_toss(counter+4));	
			}
			else
			{
				sprintf(char_buffer,"momentum=%d\n",momentum);	
			}
			fputs(char_buffer,file_ptr);

			sprintf(char_buffer,"x_c=%1.15f\n",k*(1.0)/(num_layer-1));	
			fputs(char_buffer,file_ptr);

			sprintf(char_buffer,"y_c=%1.15f\n",(l+0.5)*(1.0)/( num_elem_layer[k] ));	
			fputs(char_buffer,file_ptr);

			sprintf(char_buffer,"range=%1.15f\n",range);	
			fputs(char_buffer,file_ptr);

			num_con=num_elem_layer[k-1];
			sprintf(char_buffer,"num_con=%d\n",num_elem_layer[k-1]);	
			fputs(char_buffer,file_ptr);
		
			if (!strncmp("rr",argv[7],2))
			{
				sprintf(char_buffer,"bias=%f\n",rand_gen(counter+5));	
			}
			else 
			{
				sprintf(char_buffer,"bias=%f\n",bias);	
			}
			fputs(char_buffer,file_ptr);
			
			for(m=0;m<num_con;m++)
			{
				sprintf(char_buffer,"%1.15f:%1.15f:%f:%d\n",(k-1)*1.0/(num_layer-1),
								(m+0.5)*1.0/(num_elem_layer[k-1]),rand_gen(counter+m),0);
				fputs(char_buffer,file_ptr);
			}
			fputc('\n',file_ptr);
		}
	}
	fclose(file_ptr);
	exit(0);
}
