/*  remove_neuron.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

void * remove_neuron(int num_neuron, struct neuron **neuron_array, 
											int * inner_elem, int * new_num_neuron)
{
	int k,l;
	int counter;
	int num_con;
	struct neuron ** temp_array;
	
	counter=num_neuron;
	for (k=0; k<num_neuron; k++)
	{
		if (inner_elem[k])
		{
			counter--;
		}
	}
	
//	syslog(LOG_INFO,"num_neuron=%d remainnig_neuron=%d",num_neuron, counter);
	
	if ( !(temp_array = (struct neuron **)malloc(counter*sizeof(struct neuron *)) ))
	{
		return(NULL);
	}
	for (k=0; k< counter; k++)
	{
		if ( !(temp_array[k] = (struct neuron *)malloc(sizeof(struct neuron)) ))
		{
			return(NULL);
		}
	}

//	syslog(LOG_INFO,"malloc passed counter=%d",counter);
	
	l=0;
	for (k=0; k< num_neuron; k++)
	{
		if (!inner_elem[k])
		{
			if ( (num_con = neuron_array[k]->num_con) )
			{
	//			syslog(LOG_INFO,"elem=%d num_con=%d l=%d",k,num_con,l);
				if( !(temp_array[l]->con_x = (float *)malloc(num_con*sizeof(float)) ))
				{
					syslog(LOG_CRIT,"Error malloc con_x");
					return(NULL);
				}
				if( !(temp_array[l]->con_y = (float *)malloc(num_con*sizeof(float)) ))
				{
					syslog(LOG_CRIT,"Error malloc con_y");
					return(NULL);
				}
				if( !(temp_array[l]->con_w = (double *)malloc(num_con*sizeof(double)) ))
				{
					syslog(LOG_CRIT,"Error malloc con_w");
					return(NULL);
				}
				if( !(temp_array[l]->age = (int *)malloc(num_con*sizeof(int)) ))
				{
					syslog(LOG_CRIT,"Error malloc age");
					return(NULL);
				}

				if (neuron_array[k]->momentum == 1)
				{
					if( !(temp_array[l]->delta_con_w = (double *)malloc(num_con*sizeof(double)) ))
					{
						syslog(LOG_CRIT,"Error malloc delta_con_w");
						return(NULL);
					}
				}
			}
			else
			{
	//			syslog(LOG_INFO,"elem=%d l=%d",k,l);
				temp_array[l]->con_x=NULL;
				temp_array[l]->con_y=NULL;
				temp_array[l]->con_w=NULL;
				temp_array[l]->age=NULL;
				temp_array[l]->delta_con_w=NULL;
			}
			l++;
		}
	}

//	syslog(LOG_INFO,"malloc con passed");

	/* Copy in temporal buffer */

	l=0;	
	for (k=0; k< num_neuron; k++)
	{
		if (!inner_elem[k])
		{
			copy_neuron(neuron_array[k],temp_array[l]);
			l++;
		}
	}
	
	neuron_array = (struct neuron **)free_neuron_array(num_neuron,neuron_array);
	
//	syslog(LOG_INFO,"l=%d counter=%d",l,counter);
	
	if (!(neuron_array=(struct neuron **)copy_neuron_array(counter, temp_array, neuron_array) ))
	{
		syslog(LOG_CRIT,"Error in copy_neuron_array");
		return(NULL);
	}
	temp_array = (struct neuron **)free_neuron_array(counter,temp_array);
	*new_num_neuron=counter;

	return(neuron_array);
}
