/*  ga_calloc_client_index.c */
/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* index should be a NULL pointer */

void * ga_calloc_client_index(int num_client, int num_addr, 
															struct ga_service_client_index * index)
{
	int k,l;
	ga_errno = 0;
	if (index != NULL)
	{
		syslog(LOG_ERR,"index already allocated, freeing");
		index = ga_free_client_index(index);
	}
	
	/* calloc the base structure */
	if (!(index = (struct ga_service_client_index *)calloc
																(1,sizeof(struct ga_service_client_index)) ))
	{
		syslog(LOG_CRIT,"Error calloc index in ga_service_client_index()");
		return(NULL);
	}
	
	/* calloc structure members */
	/* Allocate offsets, addr */
	if (num_addr > 0)
	{
		if (!(index->offsets = (int *)calloc(num_addr,sizeof(int)) ))
		{
			syslog(LOG_CRIT,"Error calloc index->offsets in ga_service_client_index()");
			free(index);
			return(NULL);
		}

		if (!(index->addr = (struct sockaddr_in **)calloc(num_addr,sizeof(struct sockaddr_in *)) ))
		{
			syslog(LOG_CRIT,"Error calloc index->addr in ga_service_client_index()");
			free(index->offsets);
			free(index);
			return(NULL);
		}
		
		for (k = 0; k< num_addr; k ++)
		{
			if (!(index->addr[k] = (struct sockaddr_in *)calloc(1,sizeof(struct sockaddr_in)) ))
			{
				syslog(LOG_CRIT,"Error calloc index->addr in ga_service_client_index()");
				for (l = 0; l< k; l++)
				{
					free(index->addr[l]);
				}
				free(index->offsets);
				free(index->addr);
				free(index);
				return(NULL);
			}
		}
	}
	else
	{
		index->offsets = NULL;
		index->addr = NULL;
	}

	/* calloc clients */
	if (num_client > 0)
	{
		if (!(index->clients = (struct ga_service_client_info **)calloc(
																num_client,sizeof(struct ga_service_client_info *)) ))
		{
			syslog(LOG_CRIT,"Error calloc index->clients in ga_service_client_index()");
			if (num_addr > 0)
			{
				for (k = 0; k< num_addr; k++)
				{
					free(index->addr[k]);
				}
				free(index->offsets);
				free(index->addr);
			}
			free(index);
			return(NULL);
		}
	
		for (k = 0; k< num_client; k ++)
		{
			if (!(index->clients[k] = (struct ga_service_client_info *)calloc(
																			1,sizeof(struct ga_service_client_info)) ))
			{
				syslog(LOG_CRIT,"Error calloc index->clients in ga_service_client_index()");
				if (num_addr > 0)
				{
					for (l = 0; l< num_addr; l++)
					{
						free(index->addr[l]);
					}
					free(index->offsets);
					free(index->addr);
				}
				for (l = 0; l< k; l++)
				{
					free(index->clients[l]);
				}
				free(index->clients);
				free(index);
				return(NULL);
			}
		}
	}
	
	index->num_addr = num_addr;
	index->num_client = num_client;
	return(index);
}
