/*  ga_free_client_index.c */
/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* index should be a NULL pointer */

void * ga_free_client_index(struct ga_service_client_index * index)
{
	int k;
	if (index == NULL)
	{
		syslog(LOG_INFO,"index already free");
		return(NULL);
	}
	
	for (k = 0; k< index->num_addr; k++)
	{
		free(index->addr[k]);
	}
	for (k = 0; k< index->num_client; k++)
	{
		free(index->clients[k]);
	}
	
	if ( index->num_addr > 0)
	{
		free(index->addr);
		free(index->offsets);
	}
	if ( index->num_client > 0)
	{
		free(index->clients);
	}
	free(index);
	index = NULL;
	
	return(NULL);
}
