/*  ga_server_load_config.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int ga_server_load_config(struct ga_server_config *conf, const char * filename)
{
	int k,l,m;
	int host_counter;
	int niche_counter;
	char char_temp[BUFFSIZE];
	FILE * file_pointer;
	if ((file_pointer=fopen(filename,"r")) == NULL)
	{
		return(-1);
	}

	/* Copy filename */	
	strcpy(conf->config_filename,filename);

	/* Search for host/niche entries */	
	host_counter=0;
	niche_counter=0;
	while(!feof(file_pointer))
	{
		fgets(char_buffer,BUFFSIZE,file_pointer);
		if (!strncmp(char_buffer,"host",4))
		{
			host_counter += 1;
		}
		else if(!strncmp(char_buffer,"niche",5) )
		{
			niche_counter += 1;
		}
	}

	/* Memory reserve for hosts / hosts_config */	
	if (host_counter)
	{
		if (!(conf->hosts = (char **)calloc(host_counter,sizeof(char *)) ))
		{
			syslog(LOG_CRIT,"Error malloc conf->hosts");
			return(-1);
		}
		if (!(conf->hosts_config = (char **)calloc(host_counter,sizeof(char *)) ))
		{
			syslog(LOG_CRIT,"Error malloc conf->hosts_config");
			return(-1);
		}

		for (k = 0; k< host_counter; k++)
		{
			if (!(conf->hosts[k] = (char *)calloc(BUFFSIZE,sizeof(char)) ))
			{
				syslog(LOG_CRIT,"Error malloc conf->hosts[%d]",k);
				return(-1);
			}
			if (!(conf->hosts_config[k] = (char *)calloc(BUFFSIZE,sizeof(char)) ))
			{
				syslog(LOG_CRIT,"Error malloc conf->hosts_config[%d]",k);
				return(-1);
			}
		}
	}
	
	conf->num_hosts = host_counter;
	
	syslog(LOG_INFO,"num_hosts = %d",conf->num_hosts);

	/* Now get the values for hosts / hosts_config */	
	for (k = 0; k< host_counter; k++)
	{
		rewind(file_pointer);
		sprintf(char_temp,"host%d=\0",k);
		l = strlen(char_temp);
		while(!feof(file_pointer))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			if (!(strncmp(char_buffer,char_temp,l)))
			{
				clean_char_buffer(char_buffer);			
				strcpy(conf->hosts[k],char_buffer+l);
				for (m=0; m< BUFFSIZE; m++)
				{
					if (conf->hosts[k][m] == ':')
					{
						conf->hosts[k][m] = '\0';
						strcpy(conf->hosts_config[k],conf->hosts[k]+m+1);
					}
				}
				syslog(LOG_INFO,"hosts[%d]=%s, hosts_config[%d]=%s",
								k,conf->hosts[k],k,conf->hosts_config[k]);
				break;
			}
		}
	}

	/* Memory reserve for niches / niches_config */	
	if (niche_counter)
	{
		if (!(conf->niches = (char **)calloc(niche_counter,sizeof(char *)) ))
		{
			syslog(LOG_CRIT,"Error malloc conf->niches");
			return(-1);
		}
		if (!(conf->niches_config = (char **)calloc(niche_counter,sizeof(char *)) ))
		{
			syslog(LOG_CRIT,"Error malloc conf->niches_config");
			return(-1);
		}

		for (k = 0; k< niche_counter; k++)
		{
			if (!(conf->niches[k] = (char *)calloc(BUFFSIZE,sizeof(char)) ))
			{
				syslog(LOG_CRIT,"Error malloc conf->niches[%d]",k);
				return(-1);
			}
			if (!(conf->niches_config[k] = (char *)calloc(BUFFSIZE,sizeof(char)) ))
			{
				syslog(LOG_CRIT,"Error malloc conf->niches_config[%d]",k);
				return(-1);
			}
		}
	}
	
	conf->num_niches = niche_counter;
	
	syslog(LOG_INFO,"num_niches = %d",conf->num_niches);

	/* Now get the values for hosts / hosts_config */	
	for (k = 0; k< niche_counter; k++)
	{
		rewind(file_pointer);
		sprintf(char_temp,"niche%d=\0",k);
		l = strlen(char_temp);
		while(!feof(file_pointer))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			if (!(strncmp(char_buffer,char_temp,l)))
			{
				clean_char_buffer(char_buffer);			
				strcpy(conf->niches[k],char_buffer+l);
				for (m=0; m< BUFFSIZE; m++)
				{
					if (conf->niches[k][m] == ':')
					{
						conf->niches[k][m] = '\0';
						strcpy(conf->niches_config[k],conf->niches[k]+m+1);
					}
				}
				syslog(LOG_INFO,"niches[%d]=%s, niches_config[%d]=%s",
								k,conf->niches[k],k,conf->niches_config[k]);
				break;
			}
		}
	}
		
	
	rewind(file_pointer);

	while(!feof(file_pointer))
	{
		fgets(char_buffer,BUFFSIZE,file_pointer);
		
		if (!strncmp(char_buffer,"run",3))  //run flag, if zero, system in wait state
		{
			conf->run = atoi(char_buffer+4);
			syslog(LOG_INFO,"run = %d",conf->run);
		}
		else if (!strncmp(char_buffer,"command_ip",10))
		{
			clean_char_buffer(char_buffer);
			strcpy(conf->command_ip,char_buffer+11);
			syslog(LOG_INFO,"command_ip = %s",conf->command_ip);
		}
		else if (!strncmp(char_buffer,"service_ip",10))
		{
			clean_char_buffer(char_buffer);
			strcpy(conf->service_ip,char_buffer+11);
			syslog(LOG_INFO,"service_ip = %s",conf->service_ip);
		}
		else if (!strncmp(char_buffer,"master",6))
		{
			conf->master = atoi(char_buffer+7);
			syslog(LOG_INFO,"master = %d",conf->master);
		}
		else if (!strncmp(char_buffer,"clean_start",11))
		{
			conf->clean_start = atoi(char_buffer+12);
			syslog(LOG_INFO,"clean_start = %d",conf->clean_start);
		}
		else if (!strncmp(char_buffer,"init_preffix",12))
		{
			clean_char_buffer(char_buffer);
			strcpy(conf->init_preffix,char_buffer+13);
			syslog(LOG_INFO,"init_preffix = %s",conf->init_preffix);
		}
		else if (!strncmp(char_buffer,"result_preffix",14))
		{
			clean_char_buffer(char_buffer);
			strcpy(conf->result_preffix,char_buffer+15);
			syslog(LOG_INFO,"result_preffix = %s",conf->result_preffix);
		}
		else if (!strncmp(char_buffer,"time_wait",9))
		{
			conf->time_wait=atoi(char_buffer+10);
			syslog(LOG_INFO,"time_wait = %d",conf->time_wait);
		}
		else if (!strncmp(char_buffer,"num_local",9))
		{
			conf->num_local=atoi(char_buffer+10);
			syslog(LOG_INFO,"num_local = %d",conf->max_local);
		}
		else if (!strncmp(char_buffer,"command_port",12))
		{
			conf->command_port=(unsigned int)atoi(char_buffer+13);
			syslog(LOG_INFO,"command_port = %d",conf->command_port);
		}
		else if (!strncmp(char_buffer,"service_port",12))
		{
			conf->service_port=(unsigned int)atoi(char_buffer+13);
			syslog(LOG_INFO,"service_port = %d",conf->service_port);
		}
		else if (!strncmp(char_buffer,"niche_port",10))
		{
			conf->niche_port=(unsigned int)atoi(char_buffer+11);
			syslog(LOG_INFO,"niche_port = %d",conf->niche_port);
		}
		else if (!strncmp(char_buffer,"population",10))
		{
			conf->population=atoi(char_buffer+11);
			syslog(LOG_INFO,"population = %d",conf->population);
		}
		else if (!strncmp(char_buffer,"generations",11))
		{
			conf->generations=atoi(char_buffer+12);
			syslog(LOG_INFO,"generations = %d",conf->generations);
		}
		else if (!strncmp(char_buffer,"max_neuron_mut",14))
		{
			conf->max_neuron_mut=atoi(char_buffer+15);
			syslog(LOG_INFO,"max_neuron_mut = %d",conf->max_neuron_mut);
		}
		else if (!strncmp(char_buffer,"max_num_layer",13))
		{
			conf->max_num_layer=atoi(char_buffer+14);
			syslog(LOG_INFO,"max_num_layer = %d",conf->max_num_layer);
		}		
		else if (!strncmp(char_buffer,"max_num_neuron",14))
		{
			conf->max_num_neuron=atoi(char_buffer+15);
			syslog(LOG_INFO,"max_num_neuron = %d",conf->max_num_neuron);
		}
		
/***************** REVISION IN AGGREGATION *****************/		
		else if (!strncmp(char_buffer,"agr",3)) //aggregation mode: 1=more inputs, 2 more outpus, 3 full network
		{
			conf->agr=atoi(char_buffer+4);
			syslog(LOG_INFO,"agr = %d",conf->agr);
		}
		else if (!strncmp(char_buffer,"agr_io_add",10)) //number of inputs / outputs to add 
		{
			conf->agr_io_add=atoi(char_buffer+11);
			syslog(LOG_INFO,"agr_io_add = %d",conf->agr_io_add);
		}
		else if (!strncmp(char_buffer,"agr_add_preffix",15)) //network to add
		{
			clean_char_buffer(char_buffer);		
			strcpy(conf->agr_add_preffix,char_buffer+16);
			syslog(LOG_INFO,"agr_add_preffix = %s",conf->agr_add_preffix);
		}
		
/**********************************************************/		
		else if (!strncmp(char_buffer,"lifespan",8))
		{
			conf->lifespan=atoi(char_buffer+9);
			syslog(LOG_INFO,"lifespan = %d",conf->lifespan);
		}
		else if (!strncmp(char_buffer,"mut_new_prob",12))
		{
			conf->mut_new_prob=atof(char_buffer+13);
			syslog(LOG_INFO,"mut_new_prob = %f",conf->mut_new_prob);
		}
		else if (!strncmp(char_buffer,"inm_prob",8))
		{
			conf->inm_prob=atof(char_buffer+9);
			syslog(LOG_INFO,"inm_prob = %f",conf->inm_prob);
		}
		else if (!strncmp(char_buffer,"mut_neuron_prob",15))
		{
			conf->mut_neuron_prob=atof(char_buffer+16);
			syslog(LOG_INFO,"mut_neuron_prob = %f",conf->mut_neuron_prob);
		}
		else if (!strncmp(char_buffer,"mut_net_prob",12))
		{
			conf->mut_net_prob=atof(char_buffer+13);
			syslog(LOG_INFO,"mut_net_prob = %f",conf->mut_net_prob);
		}
		else if (!strncmp(char_buffer,"base",4))
		{
			conf->base=atof(char_buffer+5);
			syslog(LOG_INFO,"base = %f",conf->base);
		}
		else if (!strncmp(char_buffer,"boost",5))
		{
			conf->boost=atof(char_buffer+6);
			syslog(LOG_INFO,"boost = %f",conf->boost);
		}
		else if (!strncmp(char_buffer,"level",5))
		{
			conf->level=atof(char_buffer+6);
			syslog(LOG_INFO,"level = %f",conf->level);
		}
		else if (!strncmp(char_buffer,"prob_alpha",10))
		{
			conf->prob_alpha=atof(char_buffer+11);
			syslog(LOG_INFO,"prob_alpha = %f",conf->prob_alpha);
		}		
		else if (!strncmp(char_buffer,"prob_conv_rate",14))
		{
			conf->prob_conv_rate=atof(char_buffer+15);
			syslog(LOG_INFO,"prob_conv_rate = %f",conf->prob_conv_rate);
		}		
		else if (!strncmp(char_buffer,"prob_bias_corr",14))
		{
			conf->prob_bias_corr=atof(char_buffer+15);
			syslog(LOG_INFO,"prob_bias_corr = %f",conf->prob_bias_corr);
		}		
		else if (!strncmp(char_buffer,"prob_delta_type",15))
		{
			conf->prob_delta_type=atof(char_buffer+16);
			syslog(LOG_INFO,"prob_delta_type = %f",conf->prob_delta_type);
		}		
		else if (!strncmp(char_buffer,"prob_momentum",13))
		{
			conf->prob_momentum=atof(char_buffer+14);
			syslog(LOG_INFO,"prob_momentum = %f",conf->prob_momentum);
		}		
		else if (!strncmp(char_buffer,"prob_num_con",12))
		{
			conf->prob_num_con=atof(char_buffer+13);
			syslog(LOG_INFO,"prob_num_con = %f",conf->prob_num_con);
		}		
		else if (!strncmp(char_buffer,"prob_bias",9))
		{
			conf->prob_bias=atof(char_buffer+10);
			syslog(LOG_INFO,"prob_bias = %f",conf->prob_bias);
		}		
	}
	fclose(file_pointer);
	return(conf->run);
}
