/*  n_calloc_connection.c */
/* 	Copyright 2004 Oswaldo Morizaki Hirakata */
/* 	This file is part of ga-nn-ag 

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "my_header.h"
#include "aux_prot.h"


/*
	Allocate one connection
*/
void * n_calloc_connection(int dimension, int momentum)
{
	struct connection *con;

	if (!(con = (struct connection *)calloc(1,sizeof(struct connection)) ))
	{
		syslog(LOG_CRIT,"Error calloc con in calloc_connection()");
		return(NULL);
	}
	
	if (!(con->con_x = (float *)calloc(dimension,sizeof(float)) ))
	{
		syslog(LOG_CRIT,"Error calloc con in calloc_connection()");
		free(con);
		return(NULL);
	}
	if (momentum >0)
	{
		if (!(con->delta_weight = (double *)calloc(momentum,sizeof(double)) ))
		{
			syslog(LOG_CRIT,"Error calloc con in calloc_connection()");
			free(con->con_x);
			free(con);
			return(NULL);
		}
	}
	return(con);
}
