/*  n_is_connected.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
connection are from neuron2 to neuron 1

0 = not connection
1 = neuron->neuron connection
11 = neuron->neuron inside block connection
21 = neuron->block connection
31 = block->neuron connection
41 = block->block connection
100 = connection collision (connection from a block to an element in a different block)
*/

int n_is_connected(struct neuron * neuron1, struct neuron * neuron2, int *con_match)
{
	int k,l;
	int flag;
	int dimension;
	int connection;
		
	dimension = neuron1->dimension;

	/*** Type of connection ***/
	for (k=0; k< neuron2->num_con; k++)
	{	
		connection = 0;
		for (l=0; l< dimension; l++)
		{
			if (neuron1->x_c[l] == neuron2->con[k]->con_x[l])
			{
				connection += 1;
			}
		}
		if (connection == dimension)
		{
			if (con_match != NULL)
			{
				*con_match = k;
			}
			if ((neuron1->inner < 10) && (neuron2->inner < 10))
			{
				return(1); // neuron->neuron
			}
			else if ((neuron1->inner < 10) && (neuron2->inner > 10))
			{
				return(31); // block->neuron
			}
			else if ((neuron1->inner > 10) && (neuron2->inner < 10))
			{
				return(21); // neuron->block
			}
			else if ((neuron1->inner > 10) && (neuron2->inner > 10))
			{
				if ( 
						((neuron1->inner == 11) || (neuron1->inner == 12)) && 
						((neuron2->inner == 11) || (neuron2->inner == 13)) 
					 ) 
				{
					return(11); // neuron->neuron inside a block
				}
				else if ( 
							((neuron1->inner == 14) || (neuron1->inner == 13)) && 
							((neuron2->inner == 12) || (neuron2->inner == 14)) 
								) 
				{
					return(41); // block->block
				}
				else
				{
					return(100); // connection collision;
				}	
			}
		}
	}
	
return(0); // none
}
