/*  nn_read_neural_net.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

void * nn_read_neural_net(struct neural_net * net, struct io_connection * con )
{
	int mode;
	mode = va_io_connect(con);
	
	switch(mode)
	{
		case 10:
		{
			if (!(net = (struct neural_net *)nn_dread_neural_net(net,con->connfd) ))
			{
				syslog(LOG_CRIT,"Error nn_dread_neural_net() in nn_read_neural_net()");
				return(NULL);
			}
			break;
		}
		case 20:
		{
			if (!(net = (struct neural_net *)nn_dread_neural_net(net,con->connfd) ))
			{
				syslog(LOG_CRIT,"Error nn_dread_neural_net() in nn_read_neural_net()");
				return(NULL);
			}
			break;
		}
		case 30:
		{
			if (!(net = (struct neural_net *)nn_dread_neural_net(net,con->connfd) ))
			{
				syslog(LOG_CRIT,"Error nn_dread_neural_net() in nn_read_neural_net()");
				return(NULL);
			}
			break;
		}
		case 40:
		{
			if (!(net = (struct neural_net *)nn_fread_neural_net(net,con->filename) ))
			{
				syslog(LOG_CRIT,"Error nn_fread_neural_net() in nn_read_neural_net()");
				return(NULL);
			}
			break;
		}
		case 42:
		{
			if (!(net = (struct neural_net *)nn_fread_neural_net(net,con->filename) ))
			{
				syslog(LOG_CRIT,"Error nn_fread_neural_net() in nn_read_neural_net()");
				return(NULL);
			}
			break;
		}
		default:
		{
			syslog(LOG_INFO,"Couldn't read, FILE/descriptor isn't open for reading");
			return(NULL);
		}
	}
	return(net);
}
