/*  nn_write_neural_net.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int nn_write_neural_net(struct neural_net * net, struct io_connection * con )
{
	int mode;
	mode = va_io_connect(con);
	
	switch(mode)
	{
		case 10:
		{
			if (nn_dwrite_neural_net(net,con->connfd) <0)
			{
				return(-1);
			}
			break;
		}
		case 20:
		{
			if (nn_dwrite_neural_net(net,con->connfd) < 0)
			{
				return(-1);
			}
			break;
		}
		case 31:
		{
			if (nn_dwrite_neural_net(net,con->connfd) <0)
			{
				return(-1);
			}
			break;
		}
		case 41:
		{
			if (nn_fwrite_neural_net(net,con->filename) <0)
			{
				return(-1);
			}
			break;
		}
		case 42:
		{
			if (nn_fwrite_neural_net(net,con->filename) < 0)
			{
				return(-1);
			}
			break;
		}
		default :
		{
			syslog(LOG_INFO,"Couldn't write, FILE/descriptor isn't open for writting");
			return(-1);
		}
	}
	return(0);
}
