/*  va_insert_io_block.c */
/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
if pos > 0 then insert char_buffer in position "pos", else append
if pos > block->num, then allocate memory up to (pos+1), and insert in that position.
*/

void * va_insert_io_block(int pos, char char_buffer[BUFFSIZE], struct io_block * block)
{
	int k;
	struct io_block * temp_block = NULL;
	
	ga_errno = 0;
	
	if (pos > block->num) //expand and insert
	{
		if (!(temp_block = (struct io_block *)va_calloc_io_block(pos+1,temp_block) ))
		{
			syslog(LOG_CRIT,"Error va_calloc_io_block() in va_insert_io_block()");
			ga_errno = 10;
			return(block);
		}
		
		temp_block->num = pos+1;
		temp_block->connfd = block->connfd;
		
		for (k = 0; k< block->num ; k ++)
		{
			strcpy(temp_block->char_vector[k],block->char_vector[k]);
		}
		strcpy(temp_block->char_vector[pos],char_buffer);
		block = (struct io_block *)va_free_io_block(block);
		return(temp_block);
	}
	else if ( (pos >= 0) && (pos < block->num) )//insert
	{
		if (!(temp_block = (struct io_block *)va_calloc_io_block(block->num+1,temp_block) ))
		{
			syslog(LOG_CRIT,"Error va_calloc_io_block() in va_insert_io_block()");
			return(block);
		}
		temp_block->num = block->num + 1;
		temp_block->connfd = block->connfd;
		
		for (k = 0; k< block->num ; k ++)
		{
			if (k < pos)
			{
				strcpy(temp_block->char_vector[k],block->char_vector[k]);
			}
			else
			{
				strcpy(temp_block->char_vector[k+1],block->char_vector[k]);
			}
		}
		strcpy(temp_block->char_vector[pos],char_buffer);
		block = (struct io_block *)va_free_io_block(block);
		return(temp_block);
	}
	else if (pos < 0) // append
	{
		if (!(temp_block = (struct io_block *)va_calloc_io_block(block->num+1,temp_block) ))
		{
			syslog(LOG_CRIT,"Error va_calloc_io_block() in va_insert_io_block()");
			ga_errno = 10;
			return(block);
		}
		temp_block->num = block->num + 1;
		temp_block->connfd = block->connfd;
		
		for (k = 0; k< block->num ; k ++)
		{
			strcpy(temp_block->char_vector[k],block->char_vector[k]);
		}
		strcpy(temp_block->char_vector[temp_block->num-1],char_buffer);
		block = (struct io_block *)va_free_io_block(block);
		return(temp_block);
	}
}
