/*  aux_prot.h */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* 
preffix convention 

n_ = neuron
nn_ = neural network
ga_ = genetic algorithm
va_ = various

*/
#ifndef AUX_PROT_H
#define AUX_PROT_H

extern int n_copy_neuron(struct neuron * origin, struct neuron * destiny);
extern int n_is_connected(struct neuron * neuron1, struct neuron * neuron2, int * con_match);
extern int n_is_above(struct neuron * neuron1, struct neuron * neuron2, int *not_equal);
extern int n_load_vector(int size, float * vector, char * char_buffer);
extern int n_load_int_vector(int size, int * vector, char * char_buffer);
extern int n_load_num_values_vector(char * char_buffer);
extern int n_load_connection(int dimension, struct connection * con, char * char_buffer);
extern int n_sort_neuron_connections(struct neuron * neuron1);

extern int nn_back_propagation(struct neural_net * net, int num_elem_input, float threshold_level);
extern int nn_dwrite_neural_net(struct neural_net * net, int descriptor);
extern int nn_fwrite_neural_net(struct neural_net * net,	const char *filename);
extern int nn_forward_propagation(struct neural_net * net, int num_elem_input, float threshold_level);
extern int nn_load_nn_config(struct nn_config *conf, int argc, char ** argv);
extern int nn_load_nn_init_config(int action, char * char_buffer,struct nn_init_config *conf);
extern int nn_sort_neuron_array(struct neural_net * net);
extern int nn_weight_update(struct neural_net * net, int num_elem_input, struct nn_config * conf);
extern int nn_write_neural_net(struct neural_net * net, struct io_connection * con );

extern int ga_client_command_parser(char char_buffer[BUFFSIZE]);
extern int ga_client_load_config(int argc, char * argv[], struct ga_client_config * conf);
extern int ga_command_server(struct ga_server_config * conf);
extern int ga_get_num_file(DIR * in_dir, char preffix[NAME_MAX]);
extern int ga_is_in_client_index(struct ga_service_client_info * client, struct ga_service_client_index * index);
extern int ga_pat_get_fitness(struct ga_server_config * conf, 	struct ga_service_client_index * index);
extern int ga_prov_get_fitness(struct ga_server_config * conf, struct ga_service_client_index * index);
extern int ga_prov_inmigrate(struct ga_server_config * conf, struct ga_service_client_index * index);
extern int ga_prov_inner_neuron(struct neural_net *net, float *origin, float *radius);
extern int ga_prov_isolate_region(struct neural_net * net);
extern int ga_prov_mate(int parents[2], struct ga_service_client_index * index);
extern int ga_prov_region_gen(int dimension, float *origin, float * radius);
extern int ga_server_load_config(struct ga_server_config *conf, const char * filename);
extern int ga_service_server(struct ga_server_config * conf);

extern int va_clean_char_buffer(char * char_buffer);
extern int va_coin_toss(int seed);
extern int va_dice_toss(int seed, int partition);
extern int va_dwrite_io_block(struct io_block * block);
extern int va_fwrite_io_block(struct io_block * block, const char * filename);
extern int va_io_connect(struct io_connection * con);
extern int va_io_close(struct io_connection * con);
extern int va_load_max_len_vector(char * char_buffer, char sep);
extern int va_load_num_values_vector(char * char_buffer, char sep);

extern float n_derive(int delta_type, float net, float threshold_level);

extern float nn_output_layer_error(struct neural_net * net,	int num_elem_output, float *output_buffer, float threshold_level, float * error);

extern float va_rand_gauss(int seed);
extern float va_rand_gen(int seed);

extern double n_threshold(int threshold_type, float net, float threshold_level);

extern void ga_client_sig_chld_jump(int signo, siginfo_t * siginfo, void * ucontext);
extern void ga_client_sig_term(int signo);
extern void ga_command_sig_chld(int signo, siginfo_t * siginfo, void * ucontext);
extern void ga_service_sig_chld(int signo, siginfo_t * siginfo, void * ucontext);
extern void ga_service_sig_term(int signo);

extern void * ga_calloc_client_index(int mode, int num_client, int num_addr, struct ga_service_client_index * index);
extern void * ga_delete_client_index(struct ga_service_client_info * client, struct ga_service_client_index * index);
extern void * ga_free_client_index(int mode, struct ga_service_client_index * index);
extern void * ga_free_pat_index(struct ga_pat_index *index);
extern void * ga_free_pattern(struct ga_pattern *pat);
extern void * ga_insert_client_index(struct ga_service_client_info * client, struct ga_service_client_index * index);
extern void * ga_load_pattern(struct ga_server_config * conf, struct ga_pat_index * index);
extern void * ga_pack_error(struct nn_return_f * ret, struct io_block * block);
extern void * ga_pack_patterns(struct nn_pattern * ret, struct io_block * block);
extern void * ga_pat_copy_pattern(struct ga_pattern * origin, struct ga_pattern * destiny);
extern void * ga_pat_index2nn_pat(struct ga_pat_index * pat, struct nn_pattern * ret[2]);
extern void * ga_pat_ga_cat_t(void * arg);
extern void * ga_prov_cross(struct ga_server_config * conf, struct ga_service_client_index * local_index, struct ga_service_client_index * return_index);
extern void * ga_prov_extract_zone(struct neural_net * net);
extern void * ga_prov_mut_net(struct ga_server_config * conf, struct ga_service_client_index * index);
extern void * ga_prov_set_clean_start_block(struct io_block * block, struct ga_server_config * conf);
extern void * ga_prov_set_command_block(struct io_block * block, int command, int num_nn);
extern void * ga_service_ga_pattern(struct ga_service_client_index * index, struct ga_server_config * conf, struct ga_pat_index * pat_index, struct ga_pat_index * result_index);
extern void * ga_service_get_client_info(int *fd, struct ga_service_client_info * info);
extern void * ga_service_accept_client_t(void * arg);
extern void * ga_service_listen_t(void * arg);
extern void * ga_service_provider_t(void * arg);
extern void * ga_unpack_error(struct nn_return_f * ret, struct io_block * block);
extern void * ga_unpack_patterns(struct nn_pattern * pat, struct io_block * block);

extern void * n_calloc_connection(int dimension, int momentum);
extern void * n_calloc_neuron(int dimension, int momentum, int num_con);
extern void * n_free_neuron(struct neuron * neuron1);

extern void * nn_agr_f(struct neural_net * net, struct neural_net * agr_net, struct nn_init_config * init_config);
extern void * nn_append_neuron(struct neural_net * parent1, struct neural_net * parent2);
extern void * nn_copy_neural_net(struct neural_net * origin, struct neural_net * destiny);
extern void * nn_dread_neural_net(struct neural_net * net,	int descriptor);
extern void * nn_f(struct nn_config conf, struct nn_pattern * in_pat, struct nn_pattern * out_pat, struct neural_net *net, struct nn_return_f * ret);
extern void * nn_fread_neural_net(struct neural_net * net,	const char * filename);
extern void * nn_free_neural_net(struct neural_net * target);
extern void * nn_free_io_vector(int num_elem,float ** io_vector);
extern void * nn_free_pattern(struct nn_pattern * pat);
extern void * nn_free_return_f(struct nn_return_f * ret);
extern void * nn_init_generator_f(struct neural_net * result_net, struct nn_init_config * init_config);
extern void * nn_load_output(float **output_buffer, int num_elem_output, struct io_connection * con, int size, int * output_len);
extern void * nn_load_input(float **input_buffer, int num_elem_input, struct io_connection * con, int size, int *input_len);
extern void * nn_read_neural_net(struct neural_net * net,	struct io_connection * con);

extern void * va_calloc_io_block(int num, int buffsize, int packsize, struct io_block * block);
extern void * va_copy_io_block(struct io_block *origin, struct io_block *destiny);
extern void * va_delete_io_block(int pos, struct io_block * block);
extern void * va_dread_io_block(struct io_block * block);
extern void * va_free_io_block(struct io_block * block);
extern void * va_insert_io_block(int pos, char char_buffer[BUFFSIZE], struct io_block * block);
extern void * va_load_char_vector(char ** vector, char * char_buffer, char sep, int * buffsize);
extern void * va_pack_io_block(struct io_block * block, char sep);
extern void * va_unorder_vector(int len, int * vector);
extern void * va_unpack_io_block(struct io_block * block, char sep);

extern ssize_t va_readn(int fd, void *vptr, size_t n);
extern ssize_t va_read_fd(int fd, void * ptr, size_t n_bytes, int * recvfd);
extern ssize_t va_writen(int fd, const void *vptr, size_t n);
extern ssize_t va_write_fd(int fd, void *ptr, size_t nbytes, int sendfd);

#endif
