/*  ga_client_load_config.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int ga_client_load_config(int argc, char * argv[], struct ga_client_config * conf)
{
	int k;
	/* Setting defaults */
	
	conf->client_id = 0;
	strcpy(conf->server_ip,"127.0.0.1\0");
	strcpy(conf->server_port,"32001\0");
	
	
	for (k=1; k< argc; k++)
	{
		if (!strncmp(argv[k],"client_id",9))
		{
			conf->client_id = atoi(argv[k]+10);
		}
		else if (!strncmp(argv[k],"server_ip",9))
		{
			strcpy(conf->server_ip,argv[k]+10);
		}
		else if (!strncmp(argv[k],"server_port",11))
		{
			strcpy(conf->server_port,argv[k]+12);
		}
	}
	return(0);
}
