/*  ga_free_pattern.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

void * ga_free_pattern(struct ga_pattern *pat)
{
	int k,l;
	for (k=0; k< pat->num_fitness; k++)
	{
		if (pat->pat_fitness[k] != NULL)
		{
			free(pat->pat_fitness[k]);
		}
	}
	for (k=0; k< pat->num_input; k++)
	{
		if (pat->in_pattern[k] != NULL)
		{
			free(pat->in_pattern[k]);
		}
	}
	for (k=0; k< pat->num_fitness; k++)
	{
		if (pat->pat_fitness[k] != NULL)
		{
			free(pat->pat_fitness[k]);
		}
	}
	for (k=0; k< pat->num_output; k++)
	{
		if (pat->out_pattern[k] != NULL)
		{
			free(pat->out_pattern[k]);
		}
	}
	free(pat->pat_fitness);
	free(pat->in_pattern);
	free(pat->out_pattern);
	free(pat);
	pat = NULL;
	return(pat);
}
