/*  ga_insert_client_index.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
Insert client into index if not in there, 
else update client data, decrease nurse_time and preserve pat_curr_gen
*/

/*
Since this function employs memcpy, client and index->clients share the same
data.
*/

extern int ga_errno;

void * ga_insert_client_index(struct ga_service_client_info * client,
															struct ga_service_client_index * index)
{

	int k,l;
	int is_addr;
	int temp_num_client;
	int temp_num_addr;
	int temp_pat_curr_gen;
	int temp_nurse_time;
	int addr_disp;
	
	struct ga_service_client_index * temp_index = NULL;

	ga_errno = 0;
	
	if ((is_addr = ga_is_in_client_index(client, index)) > 9)	// client is in index
	{
		/* Check state */
		if (client->state == 0) //REQ
		{
			/* Just update the REQ changed values */
			index->clients[is_addr-10]->state = client->state;
			index->clients[is_addr-10]->command = client->command;
			index->clients[is_addr-10]->connptr = client->connptr;
			memcpy(&(index->clients[is_addr-10]->addr), &(client->addr), MAXSOCKADDR);			
			return(index);
		}
		else //UPD
		{
			/* Check if client->ret require to be free */
			if (client->ret != NULL)
			{
				client->ret = (struct nn_return_f *)nn_free_return_f(client->ret);
			}
			
			/* Preserve some local data data */
			client->pat_curr_gen = index->clients[is_addr-10]->pat_curr_gen;
			client->nursetime = index->clients[is_addr-10]->nursetime - 1;
			client->pat_index = index->clients[is_addr-10]->pat_index;
		
			/* update client values */
			index->clients[is_addr-10] = memcpy(index->clients[is_addr-10], client, 
														sizeof(struct ga_service_client_info));	
														
			/* Return index */														
			return(index);
		}
	}
	else if (is_addr < -9)	// client is not in index, but address is
	{
		temp_num_addr = index->num_addr;
		addr_disp = -is_addr-10;		
	}
	else if (is_addr == 0) // client nor address are in index
	{
		temp_num_addr = index->num_addr+1;
		addr_disp = index->num_addr;		//New element is appended at end of whole list
	}

	temp_num_client = index->num_client + 1;

	/* calloc temp_index */
	if (!(temp_index = (struct ga_service_client_index *)ga_calloc_client_index(
															10,	temp_num_client, temp_num_addr, temp_index) ))
	{
		ga_errno = 2;
		syslog(LOG_CRIT,"Error ga_calloc_client_index() for temp_index in ga_insert_client_index()");
		return(NULL);
	}

	/* Set nums */
	temp_index->num_client = temp_num_client;
	temp_index->num_addr = temp_num_addr;
	
	/* Set / Copy / Redirect addr elements from index to temp_index */
	for (k = 0; k< index->num_addr; k++)
	{
		temp_index->offsets[k] = (k > addr_disp) ? (index->offsets[k] + 1) : (index->offsets[k]);
		temp_index->addr[k] = index->addr[k];
	}


	/* calloc for the new addr if necesary */
	if (is_addr == 0)
	{
		if (!(temp_index->addr[index->num_addr] = (struct sockaddr_in *)calloc(1,sizeof(struct sockaddr_in)) ))
		{
			ga_errno = 2;
			syslog(LOG_CRIT,"Error calloc temp_index->addr[%d]",index->num_addr);
			temp_index = ga_free_client_index(0,temp_index);
			return(index);
		}
	}

		
	/* calloc for the new client */
	if(!(temp_index->clients[temp_index->offsets[addr_disp]] = (struct ga_service_client_info *)
																			calloc(1,sizeof(struct ga_service_client_info)) ))
	{
		ga_errno = 2;
		syslog(LOG_CRIT,"Error calloc temp_index->clients[%d]",temp_index->offsets[addr_disp]);
		temp_index = ga_free_client_index(0,temp_index);
		return(index);
	}


	/* Add new offset and addr if required */
	if (is_addr == 0)
	{
		temp_index->offsets[index->num_addr] = index->num_client;
		temp_index->addr[index->num_addr] = (struct sockaddr_in *)memcpy(
																				temp_index->addr[index->num_addr], 
																				&(client->addr),
																				sizeof(struct sockaddr_in));

	}

	/* Redirect client elements below offsets[addr_disp] from index to temp_index */
	for (k = 0; k< temp_index->offsets[addr_disp]; k++)
	{
		temp_index->clients[k] = index->clients[k];
	}
		
	/* Insert new client */
	temp_index->clients[temp_index->offsets[addr_disp]] = memcpy(
																			temp_index->clients[temp_index->offsets[addr_disp]],
																			client, 
																			sizeof(struct ga_service_client_info));
	
	/* Redirect client elements above offsets[addr_disp] from index to temp_index */
	for (k = temp_index->offsets[addr_disp] + 1; k< temp_num_client; k++)
	{
		temp_index->clients[k] = index->clients[k-1];
	}
	
	/* free index */
	index = ga_free_client_index(10, index);
	
	/* Set new value of index */
	index = temp_index;
	
	return(index);
}
