/*  ga_pack_patterns.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */
/* 	This file is part of ga-nn-ag-2 

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
Input separators are ';'
Element separators are ':'

block->pack_vector is: PATTERN!a1:a2:a3;b1:b2:b3!c1:c2:c3;d1:d2:d3!END_PATTERN\0

So block->char_vector is:

char_vector[0] = PATTERN\0
char_vector[1] = a1:a2:a3;b1:b2:b3\0
char_vector[2] = c1:c2:c3;d1:d2:d3\0
char_vector[3] = END_PATTERN\0

pattern0 =	a1:a2:a3
						b1:b2:b3
				
pattern1 = 	c1:c2:c3
						d1:d2:d3
				
num_input is constant for all patterns
num_elem could be different for different patterns

*/

void * ga_pack_patterns(struct nn_pattern * pat, struct io_block * block)
{
	int k,l,m;
	struct io_block * temp_block1 = NULL;
	struct io_block * temp_block2 = NULL;
	
	char char_buffer[BUFFSIZE];
	
	/* Calloc temp_block1, temp_block2, block */
	if (!(temp_block1 = (struct io_block *)va_calloc_io_block(0, 0, 0, temp_block1)))
	{
		syslog(LOG_CRIT,"Error va_calloc_io_block(temp_block1) in ga_pack_patterns [%d]: %s",k,strerror(errno));
		return(NULL);
	}
	if (!(block = (struct io_block *)va_calloc_io_block(0,0,0, block)))
	{
		syslog(LOG_CRIT,"Error va_calloc_io_block(block) in ga_pack_patterns: %s",strerror(errno));
		temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
		return(NULL);
	}
	
	/* Insert PATTERN\0 */
	sprintf(char_buffer,"PATTERN\0");
	if (!(block = (struct io_block *)va_insert_io_block(-1,char_buffer,block)))
	{
		syslog(LOG_CRIT,"Error va_insert_io_block(block) in ga_pack_patterns: %s",strerror(errno));
		temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
		return(NULL);
	}
	
	/* Insert patterns */
	for (k = 0; k< pat->num_pat; k++)
	{
		for (l = 0; l< pat->num_input; l++)
		{
			/* Memory reserve for output error elements */
			if (!(temp_block2 = (struct io_block *)va_calloc_io_block(
										pat->num_elem[k], BUFFSIZE,0, temp_block2)))
			{
				syslog(LOG_CRIT,"Error va_calloc_io_block(temp_block2) in ga_pack_patterns [%d][%d]: %s",k,l,strerror(errno));
				temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
				block = (struct io_block *)va_free_io_block(block);
				return(NULL);
			}
		
			/* Insert pattern elements */
			for (m = 0; m< pat->num_elem[k]; m++)
			{
				snprintf(temp_block2->char_vector[m], BUFFSIZE, "%1.5f\0", pat->pattern[k][l][m]);
				temp_block2->char_vector[m][BUFFSIZE-1] = '\0';
			}
			
			/* Pack elements to form packet pattern */			
			if (!(temp_block2 = (struct io_block *)va_pack_io_block(temp_block2, ELEM_SEP)))
			{
				syslog(LOG_CRIT,"Error va_pack_io_block(temp_block2) in ga_pack_patterns [%d][%d]: %s",k,l,strerror(errno));
				temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
				block = (struct io_block *)va_free_io_block(block);
				return(NULL);
			}
			
			/* Insert temp_block2->pack_vector in  temp_block1->char_vector */
			if (!(temp_block1 = (struct io_block *)va_insert_io_block(
												-1, temp_block2->pack_vector, temp_block1)))
			{
				syslog(LOG_CRIT,"Error va_insert_io_block(temp_block2) in ga_pack_patterns [%d][%d]: %s",k,l,strerror(errno));
				block = (struct io_block *)va_free_io_block(block);
				temp_block2 = (struct io_block *)va_free_io_block(temp_block2);
				return(NULL);
			}
			
			/* Free elements in temp_block2 */
			if (!(temp_block2 = (struct io_block *)va_delete_io_block(-1, temp_block2)))
			{
				syslog(LOG_CRIT,"Error va_delete_io_block(temp_block2) in ga_pack_patterns [%d][%d]: %s",k,l,strerror(errno));
				block = (struct io_block *)va_free_io_block(block);
				temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
				return(NULL);
			}
		}
		
		/* Pack temp_block1 to form patterns */
		if (!(temp_block1 = (struct io_block *)va_pack_io_block(temp_block1, BLOCK_SEP)))
		{
			syslog(LOG_CRIT,"Error va_pack_io_block(temp_block1) in ga_pack_patterns [%d]: %s",k,strerror(errno));
			temp_block2 = (struct io_block *)va_free_io_block(temp_block2);
			block = (struct io_block *)va_free_io_block(block);
			return(NULL);
		}
		
		/* Insert temp_block1->pack_vector in block->char_vector */
		if (!(block = (struct io_block *)va_insert_io_block(
											-1, temp_block1->pack_vector, block)))
		{
			syslog(LOG_CRIT,"Error va_insert_io_block(temp_block1) in ga_pack_patterns [%d]: %s",k,strerror(errno));
			temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
			temp_block2 = (struct io_block *)va_free_io_block(temp_block2);
			return(NULL);
		}
		
		/* Free elements in temp_block2 */
		if (!(temp_block1 = (struct io_block *)va_delete_io_block(-1, temp_block1)))
		{
			syslog(LOG_CRIT,"Error va_delete_io_block(temp_block1) in ga_pack_patterns [%d]: %s",k,strerror(errno));
			temp_block2 = (struct io_block *)va_free_io_block(temp_block2);
			temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
			return(NULL);
		}		
	}
	
	/* Insert END_PATTERN\0 */
	sprintf(char_buffer,"END_PATTERN\0");
	if (!(block = (struct io_block *)va_insert_io_block(-1,char_buffer,block)))
	{
		syslog(LOG_CRIT,"Error va_insert_io_block(block) in ga_pack_patterns: %s",strerror(errno));
		temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
		temp_block2 = (struct io_block *)va_free_io_block(temp_block2);
		return(NULL);
	}	

	temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
	temp_block2 = (struct io_block *)va_free_io_block(temp_block2);
	
	return(block);
}

