/*  ga_pat_copy_pattern.c */
/*  Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/*  This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

void * ga_pat_copy_pattern(struct ga_pattern * origin, struct ga_pattern * destiny)
{
	int k,l;
	/* Check if destiny is NULL */
	if (destiny != NULL)
	{
		syslog(LOG_ERR,"Warning, posible memory leak, destiny not NULL in ga_pat_copy_pattern");
	}
	
	/* Memory reserve for destiny */
	if (!(destiny = (struct ga_pattern *)malloc(sizeof(struct ga_pattern))))
	{
		syslog(LOG_CRIT,"Error malloc destiny in ga_pat_copy_pattern");
		return(NULL);
	}
	/* Memory reserve for destiny elements */
	if (!(destiny->in_pattern = (float **)malloc(origin->num_input*sizeof(float *))))
	{
		syslog(LOG_CRIT,"Error malloc destiny->in_pattern in ga_pat_copy_pattern: %s",strerror(errno));
		free(destiny);
		return(NULL);
	}
	if (!(destiny->out_pattern = (float **)malloc(origin->num_output*sizeof(float *))))
	{
		syslog(LOG_CRIT,"Error malloc destiny->out_pattern in ga_pat_copy_pattern: %s",strerror(errno));
		free(destiny->in_pattern);
		free(destiny);
		return(NULL);
	}
	if (!(destiny->pat_fitness = (float **)malloc(origin->num_fitness*sizeof(float *))))
	{
		syslog(LOG_CRIT,"Error malloc destiny->pat_fitness in ga_pat_copy_pattern: %s",strerror(errno));
		free(destiny->out_pattern);
		free(destiny->in_pattern);
		free(destiny);
		return(NULL);
	}
	for (k=0; k< origin->num_input; k++)
	{
		if (!(destiny->in_pattern[k] = (float *)malloc(origin->num_elem_input*sizeof(float))))
		{
			syslog(LOG_CRIT,"Error malloc destiny->in_pattern[%d] in ga_pat_copy_pattern: %s",
								k,strerror(errno));
			for (l=0; l< k; l++)
			{
				free(destiny->in_pattern[l]);
			}
			free(destiny->out_pattern);
			free(destiny->in_pattern);
			free(destiny->pat_fitness);
			free(destiny);
			return(NULL);
		}
		for (l=0; l< origin->num_elem_input; l++)
		{
			destiny->in_pattern[k][l] = origin->in_pattern[k][l];
		}
	}
	for (k=0; k< origin->num_output; k++)
	{
		if (!(destiny->out_pattern[k] = (float *)malloc(origin->num_elem_output*sizeof(float))))
		{
			syslog(LOG_CRIT,"Error malloc destiny->out_pattern[%d] in ga_pat_copy_pattern: %s",
								k,strerror(errno));
			for (l=0; l< origin->num_input; l++)
			{
				free(destiny->in_pattern[l]);
			}
			for (l=0; l< k; l++)
			{
				free(destiny->out_pattern[l]);
			}
			free(destiny->out_pattern);
			free(destiny->in_pattern);
			free(destiny->pat_fitness);
			free(destiny);
			return(NULL);
		}
		for (l=0; l< origin->num_elem_output; l++)
		{
			destiny->out_pattern[k][l] = origin->out_pattern[k][l];
		}
	}
	for (k=0; k< origin->num_fitness; k++)
	{
		if (!(destiny->pat_fitness[k] = (float *)malloc(origin->num_elem_fitness*sizeof(float))))
		{
			syslog(LOG_CRIT,"Error malloc destiny->pat_fitness[%d] in ga_pat_copy_pattern: %s",
								k,strerror(errno));
			for (l=0; l< origin->num_input; l++)
			{
				free(destiny->in_pattern[l]);
			}
			for (l=0; l< origin->num_output; l++)
			{
				free(destiny->out_pattern[l]);
			}
			for (l=0; l< k; l++)
			{
				free(destiny->pat_fitness[l]);
			}
			free(destiny->out_pattern);
			free(destiny->in_pattern);
			free(destiny->pat_fitness);
			free(destiny);
			return(NULL);
		}
		for (l=0; l< origin->num_elem_fitness; l++)
		{
			destiny->pat_fitness[k][l] = origin->pat_fitness[k][l];
		}
	}
	
	/* Copy automatic var values */
	destiny->pat_cat = origin->pat_cat;
	destiny->stable = origin->stable;
	destiny->num_input = origin->num_input;
	destiny->num_elem_input = origin->num_elem_input;
	destiny->num_output = origin->num_output;
	destiny->num_elem_output = origin->num_elem_output;
	destiny->num_fitness = origin->num_fitness;
	destiny->num_elem_fitness = origin->num_elem_fitness;
	destiny->fitness = origin->fitness;
	
	return(destiny);
}
