/*  ga_prov_cross.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* Return the offspring index: return_index the contains a sigle client */

void * ga_prov_cross(struct ga_server_config * conf, 
							struct ga_service_client_index * local_index,
							struct ga_service_client_index * return_index)
{
int k,l;

int parents[2];

float * origin = NULL;
float * radius = NULL;

struct neural_net * parent1 = NULL;
struct neural_net * parent2 = NULL;

/* Mate parents */
if (ga_prov_mate(parents, local_index))
{
	syslog(LOG_CRIT,"Error ga_prov_mate() in ga_prov_cross(): %s", strerror(errno));
	return(NULL);
}

/* Memory reserve return_index */
if (return_index != NULL)
{
	syslog(LOG_ERR,"return_index allocated, should be NULL");
	
	free(return_index);
}

if (!(return_index = (struct ga_service_client_index *)calloc(1, 
								sizeof(struct ga_service_client_index))))
{
	syslog(LOG_CRIT,"Error calloc return_index in ga_prov_cross(): %s",strerror(errno));
	return(NULL);
}

/* Insert parent1 into return_index */
return_index = (struct ga_service_client_index *)ga_insert_client_index(
							local_index->clients[parents[0]], return_index);

/* Crossing */
/* Make copies of neural_net for parent1 */
parent1 = (struct neural_net *)nn_copy_neural_net(return_index->clients[0]->ret->net,
																parent1);

/* Inserting into set pointers to values, not copies the values, so redirecting to the copy */
return_index->clients[0]->ret->net = parent1;

/* Get a copy of parent2 */
parent2 = (struct neural_net *)nn_copy_neural_net(local_index->clients[parents[1]]->ret->net,
																parent2);
	
/* Generate region */
if (ga_prov_region_gen(local_index->clients[0]->ret->net->dimension, origin, radius))
{
	syslog(LOG_CRIT,"Error ga_prov_region_gen() in ga_prov_cross() %d: %s",k, strerror(errno));
	return(NULL);
}

/* Mark neurons */
if (ga_prov_inner_neuron(return_index->clients[k]->ret->net, origin, radius))
{
	syslog(LOG_CRIT,"Error ga_prov_inner_neuron() in ga_prov_cross() %d: %s",k ,strerror(errno));
	return(NULL);
}
if (ga_prov_inner_neuron(parent2, origin, radius))
{
	syslog(LOG_CRIT,"Error ga_prov_inner_neuron() in ga_prov_cross() %d: %s",k ,strerror(errno));
	return(NULL);
}
for (l=0; l< parent2->num_neuron; l++)
{
	parent2->neuron_array[l]->inner = (parent2->neuron_array[l]->inner == 0) ? 1 : 0;
}

/* Extract zones */
if (!(return_index->clients[0]->ret->net = (struct neural_net *)
					ga_prov_extract_zone(return_index->clients[0]->ret->net) ))
{
	syslog(LOG_CRIT,"Error ga_prov_extract_zone(parent1) in ga_prov_cross(): %s",strerror(errno));
	return(NULL);
}

if (!(parent2 = (struct neural_net *)ga_prov_extract_zone(parent2) ))
{
	syslog(LOG_CRIT,"Error ga_prov_extract_zone(parent2) in ga_prov_cross(): %s",strerror(errno));
	return(NULL);
}
	
	
/* Set inner value for append */
for (l=0; l< parent2->num_neuron; l++)
{
	parent2->neuron_array[l]->inner = 4;
}
	
for (l=0; l< return_index->clients[k]->ret->net->num_neuron; l++)
{
	return_index->clients[k]->ret->net->neuron_array[l]->inner = 4;
}
	
/* Append neural net */
if(!(return_index->clients[k]->ret->net = (struct neural_net *)nn_append_neuron(
				return_index->clients[k]->ret->net, parent2) ))
{
	syslog(LOG_CRIT,"Error nn_append_neuron() in ga_prov_cross(): %s", strerror(errno));
	return(NULL);
}

parent2 = nn_free_neural_net(parent2);

return(return_index);
}
