/*  ga_prov_extract_zone.c */

/*  Copyright 2004-2005 Oswaldo Morizaki */

/*  This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/*
Region should be already marked (return zone is marked by 1, 
discarded zone is marked by 0)
*/

void * ga_prov_extract_zone(struct neural_net * net)
{
int k,l;
int counter;

struct neuron ** temp_neuron_array=NULL;

/* Isolate region */
if (!ga_prov_isolate_region(net))
{
	syslog(LOG_CRIT,"Error ga_prov_isolate_region() in ga_prov_extract_zone():%s", strerror(errno));
	return(NULL);
}	

/* Count number of neurons marked */
counter = 0;
for (k=net->num_neuron-1 ; k+1; k--)
{
	counter += net->neuron_array[k]->inner;
}

if (counter)
{
	/* Memory allocation of temp_net */
	if (!(temp_neuron_array = (struct neuron **)calloc(counter,sizeof(struct neuron *)) ))
	{
		syslog(LOG_CRIT,"Error calloc temp_neuron_array in ga_prov_extract_zone():%s",strerror(errno));
		return(NULL);
	}

	/* Copy marked neurons to temp_neuron_array */
	l=0;
	for (k=0; k< net->num_neuron; k++)
	{
		if (net->neuron_array[k]->inner)
		{
			if (!(temp_neuron_array[l]	= (struct neuron *)n_calloc_neuron(net->neuron_array[k]->dimension,
																			net->neuron_array[k]->momentum,
																			net->neuron_array[k]->num_con) ))
			{
				syslog(LOG_CRIT,"Error n_calloc_neuron() in ga_prov_extract_zone(): %s", strerror(errno));
				return(NULL);
			}
			n_copy_neuron(net->neuron_array[k], temp_neuron_array[l]);
			l += 1;
		}
	}
}
/* Free neuron_array */
for (k=0; k< net->num_neuron; k++)
{
	n_free_neuron(net->neuron_array[k]);
}
free(net->neuron_array);

/* Set new num_neuron value and new neuron_array */
net->num_neuron = counter;
net->neuron_array = temp_neuron_array;

return(net);
}
