/*  ga_prov_inmigrate.c */

/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int ga_prov_inmigrate(struct ga_server_config * conf, struct ga_service_client_index * index)
{
int k;
int counter = 0;
double med = 0;
double dev = 0;

for (k=0; k< index->num_client; k++)
{
	if (index->clients[k]->command == 3)
	{
		counter += 1;
		med += index->clients[k]->c_error;
	}
}

if (counter > 1)
{
	med /= counter;

	for (k=0; k< index->num_client; k++)
	{
		if (index->clients[k]->command == 3)
		{
			dev += pow((med - index->clients[k]->c_error),2);
		}
	}
	dev /= counter;
	dev = pow(dev,0.5);
	if ((fabs(dev - med)/med) <= conf->inm_level)
	{
		return(1);
	}
}
return(0);
}
