/*  ga_prov_mut_net.c */
/*  Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/*  This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"


/* index should contain a single element */
/* 
Probs:

alpha = 0
range = 1
conv_rate = 2
bias_corr = 3
delta_type = 4
momentum = 5
bias = 6
*/

void * ga_prov_mut_net(struct ga_server_config * conf, struct ga_service_client_index * index)
{
	int k,l,m;
	int num_add;
	int momentum;
	int num_inner;
	int winner;
	
	float temp;
	float prob[7];
	
	struct neural_net * net = NULL;
	
	if (!(net = (struct neural_net *)calloc(1,sizeof( struct neural_net)) ))
	{
		syslog(LOG_CRIT,"Error calloc net in ga_prov_mut_net: %s", strerror(errno));
		return(NULL);
	}
	if (!(net->neuron_array = (struct neuron **)calloc(1,sizeof( struct neuron *)) ))
	{
		syslog(LOG_CRIT,"Error calloc net->neuron_array in ga_prov_mut_net: %s", strerror(errno));
		return(NULL);
	}
	net->num_neuron = 1;
	net->dimension = conf->nn_dimension;
	net->type = conf->nn_type;

	/********************************************************/
	/* Mutate a whole network adding / substracting neurons */
	/********************************************************/
	if (va_toss(conf->mut_net_prob, index->clients[0]->id))
	{
		/* Set number of neurons to add / remove */
		num_add = va_dice_toss(index->clients[0]->id, conf->max_neuron_mut);
		for (k=0; k< num_add; k++)
		{
			/*****************/
			/* Append neuron */
			/*****************/
			if (va_coin_toss(k))
			{
				momentum = va_dice_toss(k, MAX_MOMENTUM);
				if (!(net->neuron_array[0] = (struct neuron *)n_calloc_neuron(conf->nn_dimension, momentum, 0) ))
				{
					syslog(LOG_CRIT,"Error n_calloc_neuron in ga_prov_mut_net: %s", strerror(errno));
					return(NULL);
				}
				
				/* Set parameters of the neuron */
				/* Set coordinates and range */
				for (l=0 ; l< conf->nn_dimension; l++)
				{
					temp = 0.9999*va_rand_gen(l) + 0.00005;	// Not an input nor output layer
					net->neuron_array[0]->x_c[l] = temp; //set coordinates
					net->neuron_array[0]->range[l] = (temp > 0.5) ? (va_rand_gen(l) / 2) : 
																( temp*va_rand_gen(l) ) ; //set range
				}
				/* Set alpha */
				for (l=0; l< net->neuron_array[0]->momentum; l++)
				{
					net->neuron_array[0]->alpha[l] = va_rand_gen(l)/2;
				}
				
				/* Set other parameters */
				net->neuron_array[0]->conv_rate = va_rand_gen(k)/2; // conv_rate
				net->neuron_array[0]->bias_corr = va_coin_toss(k); // bias_corr
				net->neuron_array[0]->delta_type = va_dice_toss(k, NUM_TYPE); // delta_type
				net->neuron_array[0]->delta_inf = MAX_DELTA_INF + MAX_DELTA_INF*va_rand_gen(k); // delta_inf
				net->neuron_array[0]->delta_disp = MAX_DELTA_DISP*va_rand_gen(k); // delta_disp
				net->neuron_array[0]->bias = va_rand_gen(k); //bias
				net->neuron_array[0]->decayment = va_rand_gen(k); //decayment
				
				/* Append to net */
				index->clients[0]->ret->net = (struct neural_net *)nn_append_neuron(index->clients[0]->ret->net, net);
				
				/* Free neuron */
				net->neuron_array[0] = (struct neuron *)n_free_neuron(net->neuron_array[0]);
			}
			/*****************/
			/* Remove neuron */
			/*****************/
			else			
			{
				/* Mark all neurons */
				for (l=0; l< net->num_neuron; l++)
				{
					net->neuron_array[k]->inner = 1;
				}

				/* Mark neuron for removing */
				num_inner = net->num_neuron - (conf->nn_num_input + conf->nn_num_output);
				winner = va_dice_toss(k, num_inner);
				
				net->neuron_array[conf->nn_num_input + winner] = 0;
				
				/* Extract zone */
				if (!(net = (struct neural_net *)ga_prov_extract_zone(net)))
				{
					syslog(LOG_CRIT,"Error ga_prov_extract_zone in ga_prov_mut_net: %s", strerror(errno));
					return(NULL);
				}
			}
		}
	}
	
	/*************************/
	/* Mutate single neurons */
	/*************************/
	/* Copy probs into prob vector */
	prob[0] = conf->prob_alpha;
	prob[1] = conf->prob_range;
	prob[2] = conf->prob_conv_rate;
	prob[3] = conf->prob_bias_corr;
	prob[4] = conf->prob_delta_type;
	prob[5] = conf->prob_momentum;
	prob[6] = conf->prob_bias;
	
	for (k=0; k< net->num_neuron; k++)
	{
		/* Check if mutation */
		if (va_toss(conf->mut_neuron_prob, k))
		{
			/* Select parameter for mutation */
			winner = va_roulette(7, prob);
			
			switch (winner)
			{
				case 0:			// alpha
				{
					for (l=0; l< net->neuron_array[k]->momentum; l++)
					{
						net->neuron_array[k]->alpha[l] = va_rand_gen(l)/2;
					}
					break;
				}
				case 1: 			// range
				{
					for (l=0; l < net->dimension ; l++)
					{
						net->neuron_array[k]->range[l] = va_rand_gen(l)/2;
					}
					break;
				}
				case 2:			// conv_rate
				{
					net->neuron_array[k]->conv_rate = va_rand_gen(k)/2;
					break;
				}
				case 3:			// bias_corr
				{
					net->neuron_array[k]->bias_corr = va_coin_toss(k);
					break;
				}
				case 4:			// delta_type
				{
					net->neuron_array[k]->delta_type = va_dice_toss(k, NUM_TYPE);
					break;
				}
				case 5:
				{
					m = va_dice_toss(k, MAX_MOMENTUM);
					if (net->neuron_array[k]->momentum != m)
					{
						if (net->neuron_array[k]->momentum == 0)
						{
							if (!(net->neuron_array[k]->alpha = (float *)calloc(m,sizeof(float)) ))
							{
								syslog(LOG_CRIT,"Error calloc alpha in ga_prov_mut_net: %s", strerror(errno));
								return(NULL);
							}
							for (l=0; l< m; l++)
							{
								net->neuron_array[k]->alpha[l] = va_rand_gen(l)/2;
							}
						}
						else
						{
							if (m == 0)
							{
								free(net->neuron_array[k]->alpha);
								net->neuron_array[k]->alpha = NULL;
							}
							else
							{
								net->neuron_array[k]->alpha = (float *)realloc(net->neuron_array[k]->alpha, m);
								if (m > net->neuron_array[k]->momentum)
								{
									for (l = net->neuron_array[k]->momentum-1; l < m; l++)
									{
										net->neuron_array[k]->alpha[l] = va_rand_gen(l)/2;
									}
								}
							}
						}
					}
					net->neuron_array[k]->momentum = m;
					break;
				}
				case 6:			// bias
				{
					net->neuron_array[k]->bias = va_rand_gen(k);
					break;
				}
			}
		}
	}
	return(net);
}
