/*  ga_prov_region_gen.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* Generates cut hyper-dimension cut region */
/*
origin is the center of the cut region
radius is the pseudo radius of the cut region

*/


int ga_prov_region_gen(int dimension, float *origin, float * radius)
{
	pid_t pid;
	int k;
	
	pid=getpid();
	
	/* Check if origin, radius are allocated */
	if (origin == NULL)
	{
		if (!(origin = (float *)calloc(dimension, sizeof(float))))
		{
			syslog(LOG_CRIT,"Error calloc origin in ga_prov_region_gen(): %s",strerror(errno));
			return(-1);
		}
	}
	else
	{
		if (!(origin = (float *)realloc(origin, dimension*sizeof(float))))
		{
			syslog(LOG_CRIT,"Error realloc origin in ga_prov_region_gen(): %s",strerror(errno));
			return(-1);
		}
	}

	if (radius == NULL)
	{
		if (!(radius = (float *)calloc(dimension, sizeof(float))))
		{
			syslog(LOG_CRIT,"Error calloc radius in ga_prov_region_gen(): %s",strerror(errno));
			return(-1);
		}
	}
	else
	{
		if (!(radius = (float *)realloc(radius, dimension*sizeof(float))))
		{
			syslog(LOG_CRIT,"Error realloc radius in ga_prov_region_gen(): %s",strerror(errno));
			return(-1);
		}
	}	
	/* Generate origin, radius */
	for (k=0; k< dimension; k++)
	{
		*(origin+k) = va_rand_gen(pid);
		*(radius+k) = va_rand_gen(pid) / 2;
	} 
	
	return(0);
}
