/*  ga_unpack_error.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */
/* 	This file is part of ga-nn-ag-2 

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
Unpacks error in block->char_vector 

Error:  	e000 e001 e002
			e010 e011 e012
			
			e100 e101 e102
			e110 e111 e112 

char_vector:

char_vector[0]	ERROR\0
char_vector[1] e000:e001:e002;e010:e011:e012\0
char_vector[2] e100:e101:e102;e110:e111:e112\0
char_vector[3] END_ERROR\0


Error:  	e000 e001 e002
					e010 e011 e012
			
					e100 e101 e102
					e110 e111 e112 
*/

void * ga_unpack_error(struct nn_return_f * ret, struct io_block * block)
{
	int k,l,m,n;
	struct io_block * temp_block1 = NULL;
	struct io_block * temp_block2 = NULL;

	/* Check ret */
	if (ret != NULL)
	{
		syslog(LOG_ERR,"Error ret is allocated, freeing");
		ret = (struct nn_return_f *)nn_free_return_f(ret);
	}
	/* Allocate ret */
	if (!(ret = (struct nn_return_f *)calloc(1, sizeof(struct nn_return_f))))
	{
		syslog(LOG_CRIT,"Error calloc(ret) in ga_unpack_error: %s", strerror(errno));
		return(NULL);
	}
	ret->net = NULL;


	/* Check if is an error block */
	if ((strncmp(block->char_vector[0],"ERROR", 5)))
	{
		syslog(LOG_INFO,"Error, doesn't seems to be a error block in ga_unpack_error");
		return(NULL);
	}

	/* Check if is terminated */
	if ((strncmp(block->char_vector[block->num-1],"END_ERROR", 9)))
	{
		syslog(LOG_INFO,"Error, not terminated / malformed block error in ga_unpack_error");
		return(NULL);
	}

	/* Get num_pat */
	ret->num_pat = block->num - 2;
	
	/* Memory reserve for ret->error, num_elem */
	if (!(ret->num_elem = (int *)calloc(ret->num_pat, sizeof(int))))
	{
		syslog(LOG_CRIT,"Error calloc ret->num_elem in ga_unpack_error: %s",strerror(errno));
		return(NULL);
	}
	if (!(ret->error = (float ***)calloc(ret->num_pat, sizeof(float **))))
	{
		syslog(LOG_CRIT,"Error calloc ret->error in ga_unpack_error: %s",strerror(errno));
		free(ret->num_elem);
		return(NULL);
	}
	
	/* Allocate temp_block1 */
	if (!(temp_block1 = (struct io_block *)va_calloc_io_block(
									0, 0, block->buffsize, temp_block1)))
	{
		syslog(LOG_CRIT,"Error va_calloc_io_block in ga_unpack_error()");
		return(NULL);
	}
	
	for (k=0; k< block->num-2; k++)
	{
		strncpy(temp_block1->pack_vector, block->char_vector[k+1], block->buffsize);
		
		if (!(temp_block1 = (struct io_block *)va_unpack_io_block(temp_block1, BLOCK_SEP)))
		{
			syslog(LOG_CRIT,"Error va_unpack_io_block in ga_unpack_error(): k=%d",k);
			free(ret->error);
			free(ret->num_elem);
			return(NULL);
		}

		/* Calloc ret->error[k] */
		if (!(ret->error[k] = (float **)calloc(temp_block1->num, sizeof(float *))))
		{
			syslog(LOG_CRIT,"Error calloc ret->error in ga_unpack_error: %s",strerror(errno));
			for (m=0; m< k; m++)
			{
				free(ret->error[m]);
			}
			free(ret->error);
			free(ret->num_elem);
			temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
			return(NULL);
		}
		ret->num_output = temp_block1->num;

		for (l=0; l< temp_block1->num; l++)
		{
			/* Allocate temp_block2 */
			if (!(temp_block2 = (struct io_block *)va_calloc_io_block(
											0, 0, temp_block1->buffsize, temp_block2)))
			{
				syslog(LOG_CRIT,"Error va_calloc_io_block in ga_unpack_error()");
				for (m=0; m< k; m++)
				{
					free(ret->error[m]);
				}
				free(ret->error);
				free(ret->num_elem);
				temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
				return(NULL);
			}
			
			strncpy(temp_block2->pack_vector, temp_block1->char_vector[l], temp_block1->buffsize);
			
			/* Unpack temp_block2->pack_vector */
			if (!(temp_block2 = (struct io_block *)va_unpack_io_block(temp_block2, ELEM_SEP)))
			{
				syslog(LOG_CRIT,"Error va_unpack_io_block in ga_unpack_error(): k=%d l=%d",k,l);
				for (m=0; m< k; m++)
				{
					free(ret->error[m]);
				}
				free(ret->error);
				free(ret->num_elem);
				temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
				return(NULL);
			}
			
			/* Calloc ret->error[k][l] */
			if (!(ret->error[k][l] = (float *)calloc(temp_block2->num, sizeof(float))))
			{
				syslog(LOG_CRIT,"Error calloc ret->error in ga_unpack_error: %s",strerror(errno));
				for (m=0; m< l; m++)
				{
					free(ret->error[k][m]);
				}
				
				for (m=0; m< k-1; m++)
				{
					for (n=0; n < ret->num_elem[m]; n++)
					{
						free(ret->error[m][n]);
					}
					free(ret->error[m]);
				}
				free(ret->error);
				free(ret->num_elem);
				temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
				temp_block2 = (struct io_block *)va_free_io_block(temp_block2);
				return(NULL);
			}
			ret->num_elem[k] = temp_block2->num;

			for (m=0; m< temp_block2->num; m++)
			{
				ret->error[k][l][m] = atof(temp_block2->char_vector[m]);
			}
			
			/* Remove temp_block2->char_vector */
			if (!(temp_block2 = (struct io_block *)va_delete_io_block(-1, temp_block2)))
			{
				syslog(LOG_CRIT,"Error va_delete_io_block(-1, temp_block2) in ga_unpack_error()");
				for (m=0; m< k; m++)
				{
					for (n=0; n < ret->num_elem[m]; n++)
					{
						free(ret->error[m][n]);
					}
					free(ret->error[m]);
				}
				free(ret->error);
				free(ret->num_elem);
				temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
				temp_block2 = (struct io_block *)va_free_io_block(temp_block2);

				return(NULL);
			}
		}	
		
		/* Remove temp_block1->char_vector */
		if (!(temp_block1 = (struct io_block *)va_delete_io_block(-1, temp_block1)))
		{
			syslog(LOG_CRIT,"Error va_delete_io_block(-1, temp_block1) in ga_unpack_error()");
			for (m=0; m< k; m++)
			{
				for (n=0; n < ret->num_elem[m]; n++)
				{
					free(ret->error[m][n]);
				}
				free(ret->error[m]);
			}
			free(ret->error);
			free(ret->num_elem);
			temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
			temp_block2 = (struct io_block *)va_free_io_block(temp_block2);
			return(NULL);
		}
	}

	/* Free temporal io_blocks */
	temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
	temp_block2 = (struct io_block *)va_free_io_block(temp_block2);
	
	return(ret);
}
