/*  nn_dread_neural_net.c */

/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/*
net should be NULL
*/

void * nn_dread_neural_net(struct neural_net * net, int descriptor)
{
	int k,l,m,n,o,p;
	int momentum;
	int dimension;
	int num_neuron;
	int num_input;
	int num_output;
	int age;
	int type;
	int num_con;
	int val;
	int num;
	
	double temp;
	
	char char_temp[BUFFSIZE];
	char exit_tag[BUFFSIZE];
	
	struct neuron temp_neuron;
	
	struct io_block * block = NULL;
	
	ga_errno = 0;

	/* Check if network isn't allocated */
	if (net != NULL)
	{
		syslog(LOG_CRIT,"Error in fread neural_net: neural_net already asigned");
		return(net);
	}

	/**********************************/
	/* Read NUM */
	
	/* allocation of block */
	block = NULL;
	if (!(block = (struct io_block *)va_calloc_io_block(0,0,0, block) ))
	{
		syslog(LOG_CRIT,"Error va_calloc_io_block() in nn_dread_neural_net()");
		return(NULL);
	}
	block->connfd = descriptor;

	if (!(block = (struct io_block *)va_dread_io_block(block)))
	{
		syslog(LOG_CRIT,"Error va_dread_io_block()");
		return(NULL);
	}
	
	m = 1;
	if(!strncmp(char_buffer,"neural_net",10))
	{
		m+=1;
		if (!strncmp(block->char_vector[m],"num_neuron",10))
		{
			num_neuron = atoi(block->char_vector[m]+11);
		}
		else
		{
			syslog(LOG_CRIT,"Malformed transmision wrong num_neuron");
			return(NULL);
		}
			
		m+=1;	//num_input
		if (!strncmp(block->char_vector[m],"num_input",9))
		{
			num_input = atoi(block->char_vector[m]+10);
		}
		else
		{
			syslog(LOG_CRIT,"Malformed transmision wrong num_input");
			return(NULL);
		}
			
		m+=1;	//num_output
		if (!strncmp(block->char_vector[m],"num_output",10))
		{
			num_output = atoi(block->char_vector[m]+11);						
		}
		else
		{
			syslog(LOG_CRIT,"Malformed transmision wrong num_output");
			return(NULL);
		}
			
		m+=1;	//age
		if (!strncmp(block->char_vector[m],"age",3))
		{
			age = atoi(block->char_vector[m]+4);
		}
		else
		{
			syslog(LOG_CRIT,"Malformed transmision wrong age");
			return(NULL);
		}
			
		m+=1;	//dimension
		if (!strncmp(block->char_vector[m],"dimension",9))
		{
			dimension = atoi(block->char_vector[m]+10);
		}
		else
		{
			syslog(LOG_CRIT,"Malformed transmision wrong dimension");
			return(NULL);
		}
			
		m+=1;	//type
		if (!strncmp(block->char_vector[m],"type",4))
		{
			type = atoi(block->char_vector[m]+5);
		}
		else
		{
			syslog(LOG_CRIT,"Malformed transmision wrong type");
			return(NULL);
		}

					
		/* neural net memory allocation */
		if (!(net = (struct neural_net *)calloc(1, sizeof(struct neural_net)) ))
		{
			ga_errno = 1;
			syslog(LOG_CRIT,"Error calloc neural_net in fread_neural_net()");
			return(NULL);
		}
			
		net->num_neuron = num_neuron;
		net->age = age;
		net->dimension = dimension;
		net->type = type;
		net->num_input = num_input;
		net->num_output = num_output;

		if (!(net->neuron_array = (struct neuron **)calloc(num_neuron, sizeof(struct neuron *)) ))
		{
			ga_errno = 1;
			syslog(LOG_CRIT,"Error calloc neural_net->neuron_array in fread_neural_net()");
			free(net);
			return(NULL);
		}

						
		for (k=0; k< num_neuron;k ++)
		{
			m+=1;	//neuron number
			if (k != atoi(block->char_vector[m]+7) )
			{
				ga_errno = 2;
				syslog(LOG_CRIT,"Malformed neural_net file neuron=%d %s",k,block->char_vector[m]);
				free(net->neuron_array);
				free(net);
				return(NULL);
			}
				
			m+=1;
			if (!strncmp(block->char_vector[m],"conv_rate",9))
			{
				temp_neuron.conv_rate=atof(block->char_vector[m]+10);		//conv_rate
			}
			else
			{
				syslog(LOG_CRIT,"Malformed transmision wrong conv_rate at neuron %d",k);
				return(NULL);
			}
				
			m+=1;
			if (!strncmp(block->char_vector[m],"bias",4))
			{
				temp_neuron.bias=atof(block->char_vector[m]+5);					//bias
			}
			else
			{
				syslog(LOG_CRIT,"Malformed transmision wrong bias at neuron %d",k);
				return(NULL);
			}

			m+=1;
			if (!strncmp(block->char_vector[m],"decayment",9))
			{
				temp_neuron.decayment=atof(block->char_vector[m]+10);		//decayment
			}
			else
			{
				syslog(LOG_CRIT,"Malformed transmision wrong decayment at neuron %d",k);
				return(NULL);
			}
				
			m+=1;
			if (!strncmp(block->char_vector[m],"block",5))
			{
				temp_neuron.block=atof(block->char_vector[m]+6);				//block
			}
			else
			{
				syslog(LOG_CRIT,"Malformed transmision wrong block at neuron %d",k);
				return(NULL);
			}

			m+=1;
			if (!strncmp(block->char_vector[m],"bias_corr",9))
			{
				temp_neuron.bias_corr=atoi(block->char_vector[m]+10);		//bias_correction
			}
			else
			{
				syslog(LOG_CRIT,"Malformed transmision wrong bias_corr at neuron %d",k);
				return(NULL);
			}
				
			m+=1;
			if (!strncmp(block->char_vector[m],"delta_type",10))
			{
				temp_neuron.delta_type=atoi(block->char_vector[m]+11);	//delta_type
			}
			else
			{
				syslog(LOG_CRIT,"Malformed transmision wrong delta_type at neuron %d",k);
				return(NULL);
			}
				
			m+=1;
			if (!strncmp(block->char_vector[m],"delta_inf",9))
			{
				temp_neuron.delta_inf=atof(block->char_vector[m]+10);	//delta_inf
			}
			else
			{
				syslog(LOG_CRIT,"Malformed transmision wrong delta_inf at neuron %d",k);
				return(NULL);
			}

			m+=1;
			if (!strncmp(block->char_vector[m],"delta_disp",10))
			{
				temp_neuron.delta_disp=atof(block->char_vector[m]+11);	//delta_disp
			}
			else
			{
				syslog(LOG_CRIT,"Malformed transmision wrong delta_disp at neuron %d",k);
				return(NULL);
			}

			m+=1;
			if (!strncmp(block->char_vector[m],"momentum",8))
			{
				temp_neuron.momentum=atoi(block->char_vector[m]+9);		//momentum
			}
			else
			{
				syslog(LOG_CRIT,"Malformed transmision wrong momentum at neuron %d",k);
				return(NULL);
			}

			m+=1;
			if (!strncmp(block->char_vector[m],"dimension",9))
			{
				temp_neuron.dimension=atoi(block->char_vector[m]+10);	//dimension
			}
			else
			{
				syslog(LOG_CRIT,"Malformed transmision wrong dimension at neuron %d",k);
				return(NULL);
			}
				
			m+=1;
			if (!strncmp(block->char_vector[m],"num_con",7))
			{
				temp_neuron.num_con=atoi(block->char_vector[m]+8); 		//num_con
			}
			else
			{
				syslog(LOG_CRIT,"Malformed transmision wrong num_con at neuron %d",k);
				return(NULL);
			}

			if (!(net->neuron_array[k] = (struct neuron *)n_calloc_neuron(
											temp_neuron.dimension, temp_neuron.momentum, temp_neuron.num_con) ))
			{
				ga_errno = 1;
				syslog(LOG_CRIT,"Error calloc_neuron() in fread_neural_net()");
				return(NULL);
			}
				
			/* Couldn't use copy_neuron(), since temp_neuron doesn't have connections" */
				
			net->neuron_array[k]->dimension = 		temp_neuron.dimension;
			net->neuron_array[k]->conv_rate = 		temp_neuron.conv_rate;
			net->neuron_array[k]->bias_corr = 		temp_neuron.bias_corr;
			net->neuron_array[k]->delta_type = 	temp_neuron.delta_type;
			net->neuron_array[k]->delta_inf = 	temp_neuron.delta_inf;
			net->neuron_array[k]->delta_disp = 	temp_neuron.delta_disp;
			net->neuron_array[k]->momentum = 		temp_neuron.momentum;
			net->neuron_array[k]->num_con = 			temp_neuron.num_con;
			net->neuron_array[k]->bias =					temp_neuron.bias;
			net->neuron_array[k]->inner =				temp_neuron.inner;
			net->neuron_array[k]->block =				temp_neuron.block;
			net->neuron_array[k]->decayment = 		temp_neuron.decayment;
			net->neuron_array[k]->clock = 				temp_neuron.clock;
	
			net->neuron_array[k]->value =				temp_neuron.value;
			net->neuron_array[k]->delta =				temp_neuron.delta;
			net->neuron_array[k]->p_value =			temp_neuron.p_value;
				
			m+=1; //range
			if (!strncmp(block->char_vector[m],"range",5))
			{
				n_load_vector(dimension, net->neuron_array[k]->range, block->char_vector[m]);
			}
			else
			{
				syslog(LOG_CRIT,"Malformed transmision wrong range at neuron %d",k);
				return(NULL);
			}

			m+=1; //x_c
			if (!strncmp(block->char_vector[m],"x_c",3))
			{
				n_load_vector(dimension, net->neuron_array[k]->x_c, block->char_vector[m]);
			}
			else
			{
				syslog(LOG_CRIT,"Malformed transmision wrong x_c at neuron %d",k);
				return(NULL);
			}

			m+=1; //alpha
			if (!strncmp(block->char_vector[m],"alpha",5))
			{
				if (net->neuron_array[k]->momentum > 0)
				{
					n_load_vector(net->neuron_array[k]->momentum, net->neuron_array[k]->alpha, block->char_vector[m]);
				}
			}
			else
			{
				syslog(LOG_CRIT,"Malformed transmision wrong alpha at neuron %d",k);
				return(NULL);
			}

			for (l=0; l < temp_neuron.num_con; l++)	//connections
			{
				m+=1;
				n_load_connection(dimension,net->neuron_array[k]->con[l],block->char_vector[m]);
			}
		}
		
		m+=1;
		if (strncmp(block->char_vector[m],"END_DWRITE",10))
		{
			syslog(LOG_CRIT,"Error END_DWRITE not received");
		}
	}
	return(net);
}
