/*  nn_f.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/*
Function returns nn_return_f structure (ret)


mode:
0 = test slave (test mode for ga_client), all parameters received by fifo
1 = train slave, all parameters received by fifo
*/

void * nn_f(struct nn_config conf, struct nn_pattern * in_pat, struct nn_pattern * out_pat, struct neural_net *net, struct nn_return_f * ret)
{
int k,l,m;
int num_neuron;
int in_counter;
int out_counter;
int num_pat;
int num_input;
int num_output;
int mode;
int counter;
int connfd;
int buffsize;
int input_len;
int output_len;

float * output_buffer = NULL;
float * error = NULL;

openlog("nn_f",LOG_PID,LOG_LOCAL2);

/* Check if return structure is free */
if (ret != NULL)
{
	syslog(LOG_ERR,"Error nn_f, ret isn't free, memory leak");
	free(ret);
	ret = NULL;
}

num_pat = conf.num_pat;
num_input = conf.num_input;
num_output = conf.num_output;
mode = conf.mode;
buffsize = conf.buffsize;

if (! (output_buffer=(float *)calloc(num_output,sizeof(float)) ))
{
	syslog(LOG_CRIT,"Error calloc output_buffer");
	return(NULL);
}

/* Sorting neural_net */
nn_sort_neuron_array(net);
for (k=0; k< num_neuron; k++)
{
	n_sort_neuron_connections(net->neuron_array[k]);
	net->neuron_array[k]->clock=0;
	for (l=0; l< net->neuron_array[k]->num_con; l++)
	{
		net->neuron_array[k]->con[l]->clock=0;
	}
}


/* Fill in_buff, out_buff */
for (k=0; k< num_pat; k++)

/* Memory reserve for error */
if (!(error = (float *)malloc(num_output*sizeof(float))))
{
	syslog(LOG_CRIT,"Error malloc error in nn_f: %s", strerror(errno));
	return(NULL);
}

/* Memory reserve for ret */
if (!(ret = (struct nn_return_f *)calloc(1, sizeof(struct nn_return_f))))
{
	syslog(LOG_CRIT,"Error calloc ret in nn_f: %s", strerror(errno));
	return(NULL);
}
if (!(ret->num_elem = (int *)calloc(num_pat, sizeof(int))))
{
	syslog(LOG_CRIT,"Error calloc ret->num_elem in nn_f: %s", strerror(errno));
	return(NULL);
}
if (!(ret->error = (float ***)calloc(num_pat, sizeof(float **))))
{
	syslog(LOG_CRIT,"Error calloc ret->error in nn_f: %s", strerror(errno));
	return(NULL);
}
for (k=0; k< num_pat; k++)
{
	if (!(ret->error[k] = (float **)calloc(num_output, sizeof(float *))))
	{
		syslog(LOG_CRIT,"Error calloc ret->error[%d] in nn_f: %s", k , strerror(errno));
		return(NULL);
	}
}
for (k=0; k< num_pat; k++)
{
	for (l=0; l< num_output; k++)
	{
		if (!(ret->error[k][l] = (float *)calloc(out_pat->num_elem[k], sizeof(float))))
		{
			syslog(LOG_CRIT,"Error calloc ret->error[%d][%d] in nn_f: %s", k, l, strerror(errno));
			return(NULL);
		}
	}
}

ret->num_pat = num_pat;
ret->num_output = num_output;

/* Now everything like always */
for (k=0; k< num_pat; k++)
{
	/* Set ret->num_elem */
	ret->num_elem[k] = out_pat->num_elem[k];

	/* Reset clocks and flags */
	for (l=0; l< net->num_neuron; l++)
	{
		for (m=0; m< net->neuron_array[l]->num_con; m++)
		{
			net->neuron_array[l]->con[m]->clock = 0;
			net->neuron_array[l]->con[m]->eoi_flag = 0;
		}
		net->neuron_array[l]->clock = 0;
		net->neuron_array[l]->eoi_flag = 0;
	}
	
	in_counter = 0;
	out_counter = 0;	
	while(out_counter < out_pat->num_elem[k])
	{
//		syslog(LOG_INFO,"Ready for loading inputs in_counter=%d input_len=%d num_input=%d",in_counter,input_len,num_input);

		/* Set input / clock / eoi_flag */
		if (in_counter < in_pat->num_elem[k])
		{
			for (l=0; l< num_input; l++)
			{
				net->neuron_array[l]->value = in_pat->pattern[k][in_counter][l];
				net->neuron_array[l]->clock += 1;
			}
			in_counter += 1;
		}
		else if (in_counter == in_pat->num_elem[k])
		{
			for (l=0; l< num_input; l++)
			{
				net->neuron_array[l]->eoi_flag = 1;
			}
		}
//		syslog(LOG_INFO,"Input loaded into net");

		/* Forward propagation */
		if (nn_forward_propagation(net,num_input,conf.threshold_level))
		{
			for (l= 0; l< num_output; l++)
			{
				output_buffer[l] = *(*(*(out_pat->pattern+k)+out_counter)+l);
			}

			/* Copy error and increase counter */
			nn_output_layer_error(net, num_output, output_buffer, conf.threshold_level, error);
			
			for (l=0; l< num_output; l++)
			{
				ret->error[k][l][out_counter] = error[l];
			}
			
			out_counter += 1;

//			syslog(LOG_INFO,"output_len: %d out_counter increased to: %d",output_len, out_counter);
		
		
			if (mode == 1) //mode 1 = training
			{
				nn_back_propagation(net,num_input,conf.threshold_level);
				nn_weight_update(net,num_input,&conf);
			}
		}
	}
}

ret->net = net;

free(output_buffer);
free(error);

syslog(LOG_INFO,"***** Exiting nn_f *****");

return(ret);
}
