/*  nn_load_nn_config.c */

/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* Need to accept whole argv  and argc */

int nn_load_nn_config(struct nn_config *conf, int argc, char ** argv)
{
	int k;
	int from_file = 0;
	FILE * file_pointer;

	char filename[BUFFSIZE];
	
	/* Default values */
	conf->input_flag = 0;
	conf->output_flag = 0;
	conf->threshold_level = 1.0;
	conf->mode = 1;
	conf->age_inf = 0.0;
	conf->buffsize = BUFFSIZE;
	strcpy(conf->init,"init\0");
	strcpy(conf->result,"result\0");

	for (k=0; k< argc; k++)
	{
		if (argv[k] != NULL)
		{
			if (!strncmp(argv[k],"config_file",11))
			{
				from_file = 1;
				strcpy(filename,(argv[k]+12));
			}
			else if (!strncmp(argv[k],"init",4))
			{
				strcpy(conf->init,(argv[k]+5));
				syslog(LOG_INFO,"init = %s",conf->init);
			}		
			else if (!strncmp(argv[k],"result",6))
			{
				strcpy(conf->result,(argv[k]+7));
				syslog(LOG_INFO,"result = %s",conf->result);
			}		
			else if (!strncmp(argv[k],"num_pat",7))
			{
				conf->num_pat=atoi(argv[k]+8);
			}
			else if (!strncmp(argv[k],"num_input",9))
			{
				conf->num_input=atoi(argv[k]+10);
			}
			else if (!strncmp(argv[k],"num_output",10))
			{
				conf->num_output=atoi(argv[k]+11);
			}
			else if (!strncmp(argv[k],"buffsize",8))
			{
				conf->buffsize=atoi(argv[k]+9);
			}
			else if (!strncmp(argv[k],"mode",4))
			{
				conf->mode=atoi(argv[k]+5);
			}
			else if (!strncmp(argv[k],"threshold_level",15))
			{
				conf->threshold_level=atof(argv[k]+16);
			}		
			else if (!strncmp(argv[k],"age_inf",7))
			{
				conf->age_inf=atof(argv[k]+8);
			}
			else if (!strncmp(argv[k],"input_preffix",13))
			{
				strcpy(char_buffer,argv[k]);
				va_clean_char_buffer(char_buffer);
				strcpy(conf->input_preffix,char_buffer+14);
				conf->input_flag = 1;
			}
			else if (!strncmp(argv[k],"output_preffix",14))
			{
				strcpy(char_buffer,argv[k]);
				va_clean_char_buffer(char_buffer);
				strcpy(conf->output_preffix,char_buffer+15);
				conf->output_flag = 1;
			}
		}
	}
	
	if (from_file)
	{
		if ((file_pointer=fopen(filename,"r")) == NULL)
		{
			return(-1);
		}
	
		while(!feof(file_pointer))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			if (!strncmp(char_buffer,"init",4))
			{
				strcpy(conf->init,(char_buffer+5));
			}		
			else if (!strncmp(char_buffer,"result",6))
			{
				strcpy(conf->result,(char_buffer+7));
			}		
			if (!strncmp(char_buffer,"num_pat",7))
			{
				conf->num_pat=atoi(char_buffer+8);
			}
			else if (!strncmp(char_buffer,"num_input",9))
			{
				conf->num_input=atoi(char_buffer+10);
			}
			else if (!strncmp(char_buffer,"num_output",10))
			{
				conf->num_output=atoi(char_buffer+11);
			}
			else if (!strncmp(char_buffer,"buffsize",8))
			{
				conf->buffsize=atoi(char_buffer+9);
			}
			else if (!strncmp(char_buffer,"mode",4))
			{
				conf->mode=atoi(char_buffer+5);
			}
			else if (!strncmp(char_buffer,"threshold_level",15))
			{
				conf->threshold_level=atof(char_buffer+16);
			}		
			else if (!strncmp(char_buffer,"age_inf",7))
			{
				conf->age_inf=atof(char_buffer+8);
			}
			else if (!strncmp(char_buffer,"input_preffix",13))
			{
				va_clean_char_buffer(char_buffer);
				strcpy(conf->input_preffix,char_buffer+14);
				conf->input_flag = 1;
			}
			else if (!strncmp(char_buffer,"output_preffix",14))
			{
				va_clean_char_buffer(char_buffer);
				strcpy(conf->output_preffix,char_buffer+15);
				conf->output_flag = 1;
			}
		}
		fclose(file_pointer);
	}
	
	return(1);
}
