/*  nn_sort_neuron_array.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int nn_sort_neuron_array(struct neural_net * net)
{
	int k,l,m;
	int number;
	int dimension;
	int num_neuron;
	
	struct neuron * temp_neuron;
	
	num_neuron = net->num_neuron;
	dimension = net->dimension;
	
	for (k= num_neuron; k ; k--)
	{
		number = 0;
		for (l= 0; l< k; l++)
		{
			if (n_is_above(net->neuron_array[l],net->neuron_array[number],NULL) == 0)
			{
				number = l;
			}
		}
		
		/* Allocate temp_neuron, then copy last neuron */
		if (number != (k-1) )
		{
			if (!( temp_neuron = (struct neuron *)n_calloc_neuron(dimension,
																	net->neuron_array[k-1]->momentum, 
																	net->neuron_array[k-1]->num_con) ))
			{
				ga_errno = 1;
				syslog(LOG_CRIT,"Error calloc_neuron() in sort_neuron_array()");
				return(1);
			}
			n_copy_neuron(net->neuron_array[k-1], temp_neuron);
		

			/* Free last neuron, allocate with new size, then copy higher neuron */
			net->neuron_array[k-1] = (struct neuron *)n_free_neuron(net->neuron_array[k-1]);
			
			if (!( net->neuron_array[k-1] = (struct neuron *)n_calloc_neuron(dimension,
																		net->neuron_array[number]->momentum, 
																		net->neuron_array[number]->num_con) ))
			{
				ga_errno = 1;
				syslog(LOG_CRIT,"Error calloc_neuron() in sort_neuron_array()");
				return(2);
			}
			n_copy_neuron(net->neuron_array[number], net->neuron_array[k-1]);

						
			/* Free higher neuron, allocate with new size, then copy temp_neuron */
			net->neuron_array[number] = (struct neuron *)n_free_neuron(net->neuron_array[number]);
			if (!( net->neuron_array[number] = (struct neuron *)n_calloc_neuron(dimension,
																		temp_neuron->momentum, temp_neuron->num_con) ))
			{
				ga_errno = 1;
				syslog(LOG_CRIT,"Error calloc_neuron() in sort_neuron_array()");
				return(3);
			}
			n_copy_neuron(temp_neuron, net->neuron_array[number]);

			/* Now free temp_neuron */
			temp_neuron = (struct neuron *)n_free_neuron(temp_neuron);
		}
	}
	return(0);	
}
