/*  va_fwrite_io_block.c */
/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
First element should be always NUM, so in case num isn't in block, 
function sent block num+1 first, it doesn't affect block size
*/
int va_fwrite_io_block(struct io_block * block, const char * filename)
{
	int k;
	int first;
	char char_temp[BUFFSIZE];
	
	FILE * file_ptr;
	
	if( (file_ptr=fopen(filename,"w")) == NULL)
	{
		syslog(LOG_CRIT,"Couldn't open %s: &s",filename,strerror(errno));
		return(-1);
	}
	
	/* Check if num is present */
	if (!strncmp(block->char_vector[0],"NUM",3))
	{
		first = 1;
	}
	else
	{
		first = 0;
	}
	
	/* Write everything else */
	for (k = first ; k< block->num ; k++)
	{
		if (block->char_vector[k] != NULL)
		{
			sprintf(char_temp,"%s\n",block->char_vector[k]);
		}
		else
		{
			sprintf(char_temp,"NULL\n");
		}
		fputs(char_temp,file_ptr);
	}
	
	fclose(file_ptr);
	return(0);
}
