/*  va_pack_io_block.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
- Function packs io_block->char_vector in io_block->pack_vector 
- Returns packed block 

- io_block->pack_vector should be blank (points to NULL) 
*/

void * va_pack_io_block(struct io_block * block, char sep)
{
	int k;
	int disp;
	int packsize = 0;
	size_t * vector_size;
	
	/* Check if io_block->pack_vector if free */
	if (block->pack_vector != NULL)
	{
		syslog(LOG_ERR,"io_block->pack_vector not empty, freeing");
		free(block->pack_vector);
	}
	
	/* Check if io_block->char_vector is not empty */
	if (block->num <= 0)
	{
		syslog(LOG_ERR,"Empty / malformed io_block, doing nothing");
		return(NULL);
	}
	
	/* Malloc vector_size */
	if (!(vector_size = (size_t *)malloc(block->num*sizeof(size_t))))
	{
		syslog(LOG_CRIT,"Error malloc vector_size in va_pack_io_block(): %s",strerror(errno));
		return(NULL);
	}
	
	/* Calculate packsize */
	for (k=0; k< block->num; k++)
	{
		if (block->char_vector[k] != NULL)
		{
			vector_size[k] = strlen(block->char_vector[k]);
			vector_size[k] += 1; //Space for the separator
		}
		else
		{
			vector_size[k] = 5; //NULL as string + separator
		}
		packsize += vector_size[k];
	}
	
	/* Calloc pack_vector */
	if (!(block->pack_vector = (char *)calloc(packsize,sizeof(char)) ))
	{
		syslog(LOG_CRIT,"Error calloc io_block->pack_vector in va_pack_io_block(): %s",strerror(errno));
		block = (struct io_block *)va_free_io_block(block);
		return(NULL);
	}
	
	/* Pack elements */
	disp = 0;
	for (k=0; k< block->num; k++)
	{
		if (block->char_vector[k] != NULL)
		{
			strncpy(block->pack_vector + disp, block->char_vector[k], vector_size[k]);
		}
		else
		{
			strncpy(block->pack_vector + disp, "NULL\0", vector_size[k]);
		}
		block->pack_vector[disp + vector_size[k] - 1] = sep;
		disp += vector_size[k];
	}
	block->pack_vector[packsize-1] = '\0';
	
	block->packsize=packsize;	
	
	free(vector_size);
	return(block);	
}
