/*  va_unorder_vector.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* 
Generates an unordered vector of a given size
*/

#include "my_header.h"
#include "aux_prot.h"

void * va_unorder_vector(int len, int * vector)
{
	int k,l,m,n;
	int *temp = NULL;
	/* Check if vector is NULL */
	if (vector != NULL)
	{
		return(vector);
	}

	/*	Memory reserve */
	if (!(temp = (int *)malloc(len*sizeof(int))))
	{
		syslog(LOG_CRIT,"Error malloc temp in va_unorder_vector: %s", strerror(errno));
		return(NULL);
	}
	if (!(vector = (int *)malloc(len*sizeof(int))))
	{
		syslog(LOG_CRIT,"Error malloc vector in va_unorder_vector: %s", strerror(errno));
		return(NULL);
	}

	/* Generate the base */
	for (k=0; k < len; k++)
	{
		*(temp+k) = k;
	}
	
	/* Generate secuence */
	for (k=0; k < len; k++)
	{
		l = len - k;
		m = va_dice_toss(k, l);
		vector[k] = temp[m];

		/* Eliminate used numbers */
		if (m != l)	
		{
			for (n = m+1; n < l; n++)
			{
				temp[n-1] = temp[n];
			}
		}
	}	
	
	free(temp);
	return(vector);
}
