/*  nn_dwrite_neural_net.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
8 basic parameters: 
	1) exit tag
	2) neural_net
	3) num_neuron
	4) num_input
	5) num_output
	6) age
	7) dimension
	8) type
	
15 basic neuron parameters:
	1) neuron number
	2) conv_rate
	3) bias
	4) decayment
	5) block
	6) bias_corr
	7) delta_type
	8) delta_inf
	9) delta_disp
	10) momentum
	11) dimension
	12) num_con
	13) range
	14) x_c
	15) alpha
	
1 line per connection

1 line for the close exit tag (should be NULL)

*/

int nn_dwrite_neural_net(struct neural_net * net, int descriptor)
{
	int k,l,m,n;
	int num_con;
	int num_neuron;
	int counter;
	
	char char_temp[BUFFSIZE];
	
	struct io_block * block = NULL;
	
	num_neuron = net->num_neuron;
	
	counter = 9; //Include NUM (1), close exit tag (1), and basic parameters (7)
	
	/* Add 15 for each neuron, and 1 line for each connection */
	for (k= 0; k< num_neuron; k++)
	{
		counter += 15;
		counter += net->neuron_array[k]->num_con;
	}
	
	/* Now memory reserve for io_block */
	if (!(block = (struct io_block *)va_calloc_io_block(counter,block) ))
	{
		ga_errno = 2;
		syslog(LOG_CRIT,"Error va_calloc_io_block() in nn_dwrite_neural_net()");
		return(-1);
	}

	/* Set parameters for io_block */
	block->connfd = descriptor;
	block->num = counter;

	sprintf(block->char_vector[0],"NUM=%d\0",counter);	
	sprintf(block->char_vector[1],"neural_net\0");
	sprintf(block->char_vector[2],"num_neuron=%d\0",net->num_neuron);
	sprintf(block->char_vector[3],"num_input=%d\0",net->num_input);
	sprintf(block->char_vector[4],"num_output=%d\0",net->num_output);
	sprintf(block->char_vector[5],"age=%d\0",net->age);
	sprintf(block->char_vector[6],"dimension=%d\0",net->dimension);
	sprintf(block->char_vector[7],"type=%d\0",net->type);

	n = 8;
	for (k=0;k<num_neuron; k++)
	{
		sprintf(block->char_vector[n],"neuron %d\0",k);
		n += 1;
		sprintf(block->char_vector[n],"conv_rate=%f\0",net->neuron_array[k]->conv_rate);	
		n += 1;
		sprintf(block->char_vector[n],"bias=%f\0",net->neuron_array[k]->bias);	
		n += 1;
		sprintf(block->char_vector[n],"decayment=%f\0",net->neuron_array[k]->decayment);	
		n += 1;
		sprintf(block->char_vector[n],"block=%d\0",net->neuron_array[k]->block);	
		n += 1;
		sprintf(block->char_vector[n],"bias_corr=%d\0",net->neuron_array[k]->bias_corr);	
		n += 1;
		sprintf(block->char_vector[n],"delta_type=%d\0",net->neuron_array[k]->delta_type);	
		n += 1;
		sprintf(block->char_vector[n],"delta_inf=%f\0",net->neuron_array[k]->delta_inf);	
		n += 1;
		sprintf(block->char_vector[n],"delta_disp=%f\0",net->neuron_array[k]->delta_disp);	
		n += 1;
		sprintf(block->char_vector[n],"momentum=%d\0",net->neuron_array[k]->momentum);	
		n += 1;
		sprintf(block->char_vector[n],"dimension=%d\0",net->neuron_array[k]->dimension);	
		n += 1;

		num_con = net->neuron_array[k]->num_con;
		sprintf(block->char_vector[n],"num_con=%d\0",num_con);	
		n += 1;
		sprintf(block->char_vector[n],"range=%1.5f",*(net->neuron_array[k]->range));	
		for (l=1; l< net->dimension; l++)
		{
			sprintf(char_temp,":%1.5f",net->neuron_array[k]->range[l]);	
			strcat(block->char_vector[n], char_temp);
		}
		sprintf(char_temp,"\0");
		strcat(block->char_vector[n], char_temp);
		n += 1;

		sprintf(block->char_vector[n],"x_c=%1.5f",*(net->neuron_array[k]->x_c));	
		for (l=1; l< net->dimension; l++)
		{
			sprintf(char_temp,":%1.5f",net->neuron_array[k]->x_c[l]);
			strcat(block->char_vector[n], char_temp);
		}
		sprintf(char_temp,"\0");
		strcat(block->char_vector[n], char_temp);
		n += 1;
	 
		if (net->neuron_array[k]->momentum > 0)
		{
			sprintf(block->char_vector[n],"alpha=%1.5f",*(net->neuron_array[k]->alpha));	
			for (l=1; l< net->neuron_array[k]->momentum; l++)
			{
				sprintf(char_temp,":%1.5f",net->neuron_array[k]->alpha[l]);	
				strcat(block->char_vector[n], char_temp);
			}
			sprintf(char_temp,"\0");
			strcat(block->char_vector[n], char_temp);
		}
		else
		{
			sprintf(block->char_vector[n],"alpha=NULL\0");	
		}
		n += 1;


		/* Connection order : age:weight:con_x[0]:... */
		for (l= 0; l< num_con; l++)
		{
			sprintf(block->char_vector[n],"con=%d",net->neuron_array[k]->con[l]->age);
			sprintf(char_temp,":%1.5f",net->neuron_array[k]->con[l]->weight);
			strcat(block->char_vector[n],char_temp);
			
			for (m=0; m< net->dimension; m++)
			{
				sprintf(char_temp,":%1.5f",net->neuron_array[k]->con[l]->con_x[m]);	
				strcat(block->char_vector[n], char_temp);
			}
			sprintf(char_temp,"\0");
			strcat(block->char_vector[n], char_temp);
			n += 1;
		}
	}
	sprintf(block->char_vector[n],"END_DWRITE\0");

	/* Now write to descriptor */
	if (va_dwrite_io_block(block)< 0)
	{
		syslog(LOG_CRIT,"Error va_dwrite_io_block() in nn_dwrite_neural_net()");
		return(-1);
	}
	
	/* Now free memory */
	block = (struct io_block *)va_free_io_block(block);

	return(0);
}
