/*  append_neuron.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/** Append over parent1 **/
/* parent1, parent2 should be at least allocated */
void * append_neuron(struct neural_net * parent1, struct neural_net * parent2)
{
	int k,l,m,n,o,p,q;
	int counter;
	int num_neuron;
	int inner;
	int collision;
	int num_con;
	float temp;
	float * range;
	float * dist;
	
	int num_neuron1, num_neuron2;
	int dimension;

	struct neural_net * temp_net;
	struct connection ** temp_con;
	
	num_neuron1 = parent1->num_neuron;
	num_neuron2 = parent2->num_neuron;
	dimension = parent1->dimension;
	ga_errno = 0;

			
	counter=0; //number of elements to append
	for (k=0; k < num_neuron2; k++)
	{
		if (parent2->neuron_array[k]->inner > 0)
		{
			counter += 1;
		}
	} 

	//Just in case realloc fails
	temp_net = NULL;
	if (counter > 0)
	{
		num_neuron = (num_neuron1 + counter);
		
		if ( !(range = (float *)calloc(dimension,sizeof(float)) ))
		{
			syslog(LOG_CRIT,"Error calloc range in append_neuron()");
			return(NULL);
		}
		if ( !(dist = (float *)calloc(dimension,sizeof(float)) ))
		{
			syslog(LOG_CRIT,"Error calloc dist in append_neuron()");
			return(NULL);
		}
		
		if( !(temp_net = (struct neural_net *)copy_neural_net(parent1, temp_net)) )
		{
			syslog(LOG_CRIT,"Error in copy parent1 to temp_net");
			return(NULL);
		}
		
		if ( (parent1 = (struct neural_net *)free_neural_net(parent1) ))
		{
			syslog(LOG_CRIT,"Error in free_neural_net parent1",k);
			return(NULL);
		}
		
		/*** Resize of parent1 ***/
		/*** Memory allocation parameters common to all neurons (x_c, range) ***/
		if (!(parent1 = (struct neural_net *)calloc(1,sizeof(struct neural_net)) ))
		{
			syslog(LOG_CRIT,"Error calloc parent1 in append_neuron()");
			free(parent1);
			ga_errno = 1;
			return(temp_net);
		}
		
		parent1->dimension = temp_net->dimension;
		parent1->type = temp_net->type;
		parent1->age = temp_net->age;
		parent1->num_input = temp_net->num_input;
		parent1->num_output = temp_net->num_output;
		
		if (!(parent1->neuron_array = (struct neuron **)calloc(num_neuron,
																		sizeof(struct neuron *)) ))
		{
			syslog(LOG_CRIT,"Error calloc parent1 in append_neuron()");
			ga_errno = 1;
			free(parent1);
			return(temp_net);
		}
		
		/*** Memory allocation parameters for parent1, then copy from temp_net***/
		for (k=0; k< num_neuron1; k++)
		{
			if(!(parent1->neuron_array[k] = (struct neuron *)calloc_neuron(dimension, 
						temp_net->neuron_array[k]->momentum, temp_net->neuron_array[k]->num_con) ))
			{
				syslog(LOG_CRIT,"Error calloc parent1->neuron_array[%d] in append_neuron()",k);
				ga_errno = 1;
				free(parent1->neuron_array);
				return(temp_net);
			}
			copy_neuron(temp_net->neuron_array[k], parent1->neuron_array[k]);
		}

		/*** Memory allocation parameters for parent2, then copy extra neurons***/
		l=num_neuron1;
		for (k=0; k< num_neuron2; k++)
		{
			if (parent2->neuron_array[k]->inner > 0)
			{
				if(!(parent1->neuron_array[l] = (struct neuron *)calloc_neuron(dimension, 
							parent2->neuron_array[k]->momentum,
							parent2->neuron_array[k]->num_con) ))
				{
					syslog(LOG_CRIT,"Error calloc parent1->neuron_array[%d] in append_neuron()",l);
					ga_errno = 1;
					free(parent1->neuron_array);
					return(temp_net);
				}
				copy_neuron(parent2->neuron_array[k], parent1->neuron_array[l]);
				
				/* Increase num_input / num_output if necesary */
				if (parent2->neuron_array[k]->x_c[0] == 0.0)
				{
					parent1->num_input += 1;
				}
				if (parent2->neuron_array[k]->x_c[0] == 1.0)
				{
					parent1->num_output += 1;
				}
				l += 1;	
			}
		}

		/** Collision search and correct **/
		
		collision = 1;
		while (collision > 0)
		{
			collision = 0;
			for (k=0; k< num_neuron1; k++)
			{
				for (l= num_neuron1; l< num_neuron; l++)
				{
					if (is_above(parent1->neuron_array[k], parent1->neuron_array[l],NULL) == 10)
					{
						collision += 1;
						m = dice_toss(l,dimension);
						temp = rand_gen(m);

						/* If part of a block, change connections */
						if (parent1->neuron_array[l]->block > 10) // part of a block
						{
							for (n = num_neuron1; n< num_neuron; n++)
							{
								/* neuron->neuron inside a block */
								if( (l != n) &&
										(is_connected(parent1->neuron_array[l],parent1->neuron_array[n],&o) == 11)) 
								{
									parent1->neuron_array[n]->con[o]->con_x[m] = temp;
									break;
								}
							}
						}
						/* Change neuron coordinates */
						parent1->neuron_array[l]->x_c[m] = temp;
					}
				}
			}
		}

					
/** Make connections **/
/* Connections are posible after a non equal coordinate appear */

/** out - in connections **/
		for (k=0; k< num_neuron1; k++)
		{ 
			for (l=num_neuron1; l<num_neuron; l++)
			{
				inner = parent1->neuron_array[l]->inner;
				if ((inner != 0) && (inner != 11)) // search just for posible connections
				{
					/* neuron_array[k] above neuron_array[l] */
					if (is_above(parent1->neuron_array[k], parent1->neuron_array[l], &m) == 0) 
					{
						/* Clear range and dist vector */
						for (n=0; n< dimension; n++)
						{	
							dist[n] = 0;
							range[n] = 0;
						}	
						
						/* neuron_array[l] is inside or bottom of the append zone */
						if ( (parent1->neuron_array[l]->inner == 1) ||
								 (parent1->neuron_array[l]->inner == 2)  )
						{
							for (n=m; n< dimension; n++)
							{
								dist[n] = parent1->neuron_array[k]->x_c[n] - parent1->neuron_array[l]->x_c[n];
								range[n] = (parent1->neuron_array[k]->range[n] > 
														parent1->neuron_array[l]->range[n] ) ?
														parent1->neuron_array[l]->range[n] :
														parent1->neuron_array[k]->range[n];
							}	
						}
						/* neuron_array[l] is at top of the append zone */
						else if ( (parent1->neuron_array[l]->inner == 3) ||
		 								  (parent1->neuron_array[l]->inner == 4) ||
										  (parent1->neuron_array[l]->inner == 13) ||
										  (parent1->neuron_array[l]->inner == 14) )
						{
							for (n=m; n< dimension; n++)
							{
								dist[n] = parent1->neuron_array[k]->x_c[n] - parent1->neuron_array[l]->x_c[n];
								range[n] = (parent1->neuron_array[k]->range[n] > 
														parent1->neuron_array[l]->range[n] ) ?
														parent1->neuron_array[k]->range[n] :
														parent1->neuron_array[l]->range[n];
							}	
						}
						
						/* View if connection is possible */							
						o=1;
						
						for (n=m; n< dimension; n++)
						{
							if (range[n] < 0.99*dist[n])
							{
								o -= 1; // o < 1 means no connection is posible
							}
						}	
						if (o > 0)
						{
							/* If no connections were present */
							num_con = parent1->neuron_array[k]->num_con;
							if (num_con == 0)
							{
								if (!(parent1->neuron_array[k]->con = (struct connection **)calloc
										(1,sizeof(struct connection *)) ))
								{
									ga_errno = 1;
									free_neural_net(parent1);
									syslog(LOG_CRIT,"Error calloc parent1->neuron_array[%d]->con",k);
									return(temp_net);
								}
							}
							else //temp_con used to avoid memory leak
							{
								if (!(temp_con = (struct connection **)realloc
										(parent1->neuron_array[k]->con,(num_con+1)*sizeof(struct connection *)) ))
								{
									ga_errno = 1;
									free_neural_net(parent1);
									syslog(LOG_CRIT,"Error recalloc parent1->neuron_array[%d]->con",k);
									return(temp_net);
								}
								parent1->neuron_array[k]->con = temp_con;
							}
							
							/* Memory allocation for new connection */
							if (!(parent1->neuron_array[k]->con[num_con] = (struct connection *)
									calloc_connection(dimension,parent1->neuron_array[k]->momentum) ))
							{
								ga_errno = 1;
								free_neural_net(parent1);
								syslog(LOG_CRIT,"Error calloc parent1->neuron_array[%d]->con[%d]",k,num_con);
								return(temp_net);
							}
							
							/* Make connection */
							for (n=0; n< dimension; n++)
							{
								parent1->neuron_array[k]->con[num_con]->con_x[n] = 
													parent1->neuron_array[l]->x_c[n];
							}
							parent1->neuron_array[k]->con[num_con]->weight = rand_gen(m);
							parent1->neuron_array[k]->num_con += 1;
						}
					}
				}
			}
		}
		
		/** in - out connections **/
		for (k=0; k< num_neuron1; k++)
		{ 
			for (l=num_neuron1; l<num_neuron; l++)
			{
				inner = parent1->neuron_array[l]->inner;
				if ((inner != 0) && (inner != 11)) // search just for posible connections
				{
					/* neuron_array[l] above neuron_array[k] */
					if (is_above(parent1->neuron_array[l], parent1->neuron_array[k], &m) == 0) 
					{
						/* Clear range and dist vector */
						for (n=0; n< dimension; n++)
						{	
							dist[n] = 0;
							range[n] = 0;
						}	

						/* neuron_array[l] is inside or top of the append zone */
						if ( (parent1->neuron_array[l]->inner == 1) ||
								 (parent1->neuron_array[l]->inner == 3) )
						{
							for (n=m; n< dimension; n++)
							{
								dist[n] = parent1->neuron_array[k]->x_c[n] - parent1->neuron_array[l]->x_c[n];
								range[n] = (parent1->neuron_array[k]->range[n] > 
														parent1->neuron_array[l]->range[n] ) ?
														parent1->neuron_array[l]->range[n] :
														parent1->neuron_array[k]->range[n];
							}	
						}
						/* neuron_array[l] is at bottom of the append zone */
						else if ( (parent1->neuron_array[l]->inner == 2) ||
		 								 (parent1->neuron_array[l]->inner == 4) ||
										 (parent1->neuron_array[l]->inner == 12) ||
										 (parent1->neuron_array[l]->inner == 14) )
						{
							for (n=m; n< dimension; n++)
							{
								dist[n] = parent1->neuron_array[l]->x_c[n] - parent1->neuron_array[k]->x_c[n];
								range[n] = (parent1->neuron_array[k]->range[n] > 
														parent1->neuron_array[l]->range[n] ) ?
														parent1->neuron_array[k]->range[n] :
														parent1->neuron_array[l]->range[n];
								parent1->neuron_array[l]->range[n] = range[n]; //range update;
							}	
						}
						
						/* View if connection is possible */							
						o=1;
						for (n=m; n< dimension; n++)
						{
							if (range[n] < 0.99*dist[n] )
							{
								o -= 1; // o < 1 means no connection is posible
							}
						}	
						if (o > 0)
						{
							/* If no connections were present */
							num_con = parent1->neuron_array[l]->num_con;
							if (num_con == 0)
							{
								if (!(parent1->neuron_array[l]->con = (struct connection **)calloc
										(1,sizeof(struct connection *)) ))
								{
									ga_errno = 1;
									free_neural_net(parent1);
									syslog(LOG_CRIT,"Error calloc parent1->neuron_array[%d]->con",k);
									return(temp_net);
								}
							}
							else //temp_con used to avoid memory leak
							{
								if (!(temp_con = (struct connection **)realloc
										(parent1->neuron_array[l]->con,(num_con+1)*sizeof(struct connection *)) ))
								{
									ga_errno = 1;
									free_neural_net(parent1);
									syslog(LOG_CRIT,"Error recalloc parent1->neuron_array[%d]->con",k);
									return(temp_net);
								}
								parent1->neuron_array[l]->con = temp_con;
							}
							
							/* Memory allocation for new connection */
							if (!(parent1->neuron_array[l]->con[num_con] = (struct connection *)
									calloc_connection(dimension,parent1->neuron_array[l]->momentum) ))
							{
								ga_errno = 1;
								free_neural_net(parent1);
								syslog(LOG_CRIT,"Error calloc parent1->neuron_array[%d]->con[%d]",k,num_con);
								return(temp_net);
							}
							
							/* Make connection */
							for (n=0; n< dimension; n++)
							{
								parent1->neuron_array[l]->con[num_con]->con_x[n] = 
													parent1->neuron_array[k]->x_c[n];
							}
							parent1->neuron_array[l]->con[num_con]->weight = rand_gen(m);
							parent1->neuron_array[l]->num_con += 1;
						}
					}
				}
			}
		}

		parent1->num_neuron = num_neuron;
	}
	else
	{
		parent1->num_neuron = num_neuron;
	}

	while (sort_neuron_array(parent1) != 0)
	{
		syslog(LOG_CRIT,"parent1->neuron_array not sorted, retrying");
	}
	
	for (k=0; k< parent1->num_neuron; k++)
	{
		sort_neuron_connections(parent1->neuron_array[k]);
	}
	
	free_neural_net(temp_net);
	return(parent1);
}
